/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.gui.CreditsScreen;
import harmonised.pmmo.gui.GlossaryScreen;
import harmonised.pmmo.gui.ListScreen;
import harmonised.pmmo.gui.PrefsChoiceScreen;
import harmonised.pmmo.gui.TileButton;
import harmonised.pmmo.util.XP;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class MainScreen
extends Screen {
    private final List<IGuiEventListener> children = Lists.newArrayList();
    private final ResourceLocation box = XP.getResLoc("pmmo", "textures/gui/screenboxy.png");
    private final ResourceLocation logo = XP.getResLoc("pmmo", "textures/gui/logo.png");
    private static TileButton exitButton;
    public static Map<JType, Integer> scrollAmounts;
    MainWindow sr = Minecraft.func_71410_x().func_228018_at_();
    private int boxWidth = 256;
    private int boxHeight = 256;
    private int x;
    private int y;
    private List<TileButton> tileButtons;
    private UUID uuid;

    public MainScreen(UUID uuid, ITextComponent titleIn) {
        super(titleIn);
        this.uuid = uuid;
    }

    protected void init() {
        this.tileButtons = new ArrayList<TileButton>();
        this.x = this.sr.func_198107_o() / 2 - this.boxWidth / 2;
        this.y = this.sr.func_198087_p() / 2 - this.boxHeight / 2;
        exitButton = new TileButton(this.x + this.boxWidth - 24, this.y - 8, 7, 0, "pmmo.exit", JType.NONE, something -> Minecraft.func_71410_x().field_71439_g.func_71053_j());
        TileButton glossaryButton = new TileButton(this.x + 24 + 36, this.y + 24 + 144, 3, 5, "pmmo.glossary", JType.NONE, button -> Minecraft.func_71410_x().func_147108_a((Screen)new GlossaryScreen(this.uuid, (ITextComponent)new TranslationTextComponent(((TileButton)button).transKey, new Object[0]), true)));
        TileButton creditsButton = new TileButton(this.x + 24 + 72, this.y + 24 + 144, 3, 4, "pmmo.credits", JType.NONE, button -> Minecraft.func_71410_x().func_147108_a((Screen)new CreditsScreen(this.uuid, (ITextComponent)new TranslationTextComponent(((TileButton)button).transKey, new Object[0]), JType.CREDITS)));
        TileButton prefsButton = new TileButton(this.x + 24 + 108, this.y + 24 + 144, 3, 7, "pmmo.preferences", JType.NONE, button -> Minecraft.func_71410_x().func_147108_a((Screen)new PrefsChoiceScreen((ITextComponent)new TranslationTextComponent(((TileButton)button).transKey, new Object[0]))));
        TileButton statsButton = new TileButton(this.x + 24 + 144, this.y + 24 + 144, 3, 6, "pmmo.stats", JType.NONE, button -> Minecraft.func_71410_x().func_147108_a((Screen)new ListScreen(this.uuid, (ITextComponent)new TranslationTextComponent(((TileButton)button).transKey, new Object[0]), "", JType.STATS, (PlayerEntity)Minecraft.func_71410_x().field_71439_g)));
        this.addButton((Widget)exitButton);
        this.tileButtons.add(glossaryButton);
        this.tileButtons.add(creditsButton);
        this.tileButtons.add(prefsButton);
        this.tileButtons.add(statsButton);
        for (TileButton button2 : this.tileButtons) {
            this.addButton((Widget)button2);
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(1);
        super.render(mouseX, mouseY, partialTicks);
        this.x = this.sr.func_198107_o() / 2 - this.boxWidth / 2;
        this.y = this.sr.func_198087_p() / 2 - this.boxHeight / 2;
        for (TileButton button : this.tileButtons) {
            if (mouseX <= button.x || mouseY <= button.y || mouseX >= button.x + 32 || mouseY >= button.y + 32) continue;
            this.renderTooltip(new TranslationTextComponent(button.transKey, new Object[0]).func_150254_d(), mouseX, mouseY);
        }
        RenderSystem.enableBlend();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.logo);
        this.blit(this.sr.func_198107_o() / 2 - 100, this.sr.func_198087_p() / 2 - 80, 0, 0, 200, 60);
    }

    public void renderBackground(int p_renderBackground_1_) {
        if (this.minecraft != null) {
            this.fillGradient(0, 0, this.width, this.height, 0x66222222, 0x66333333);
            MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.BackgroundDrawnEvent((Screen)this));
        } else {
            this.renderDirtBackground(p_renderBackground_1_);
        }
        this.boxHeight = 256;
        this.boxWidth = 256;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.box);
        RenderSystem.disableBlend();
        this.blit(this.x, this.y, 0, 0, this.boxWidth, this.boxHeight);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scroll) {
        return super.mouseScrolled(mouseX, mouseY, scroll);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 1) {
            exitButton.onPress();
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    static {
        scrollAmounts = new HashMap<JType, Integer>();
    }
}

