/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.gui;

import harmonised.pmmo.gui.PrefsSlider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.button.Button;

public class PrefsEntry {
    public static FontRenderer font = Minecraft.func_71410_x().field_71466_p;
    public PrefsSlider slider;
    public Button button;
    public TextFieldWidget textField;
    public String preference;
    public String prefix;
    public String suffix;
    public double defaultVal;
    public final int sliderWidth = 150;
    public final int height = 16;
    private final int textFieldWidth = 36;
    public final boolean isSwitch;
    public final boolean removeIfMax;

    public PrefsEntry(String preference, String prefix, String suffix, double minVal, double maxVal, double curVal, double defaultVal, boolean showDec, boolean showStr, boolean removeIfMax, boolean isSwitch) {
        this.preference = preference;
        this.prefix = prefix;
        this.suffix = suffix;
        this.isSwitch = isSwitch;
        this.removeIfMax = removeIfMax;
        if (defaultVal > maxVal) {
            defaultVal = maxVal;
        }
        if (defaultVal < minVal) {
            defaultVal = minVal;
        }
        if (curVal > maxVal) {
            curVal = maxVal;
        }
        if (curVal < minVal) {
            curVal = minVal;
        }
        this.defaultVal = defaultVal;
        this.slider = new PrefsSlider(0, 0, 150, 16, preference, prefix, suffix, minVal, maxVal, curVal, showDec, showStr, isSwitch, button -> {});
        if (!isSwitch) {
            this.textField = new TextFieldWidget(font, 0, 0, 36, 16, "");
            this.textField.func_146203_f(5);
            this.textField.func_146180_a(this.slider.getMessage());
        }
        this.button = new Button(0, 0, 16 + (isSwitch ? 36 : 0), 16, isSwitch ? "RESET" : "R", button -> this.resetValue());
    }

    public void resetValue() {
        this.slider.setValue(this.defaultVal);
        this.slider.updateSlider();
        if (this.isSwitch) {
            this.slider.setMessage(this.slider.getValue() == 1.0 ? "On" : "Off");
        } else {
            this.textField.func_146180_a(this.slider.getMessage());
        }
    }

    public int getWidth() {
        return 202;
    }

    public int getHeight() {
        return 27;
    }

    public int getX() {
        return this.slider.x;
    }

    public int getY() {
        return this.slider.y;
    }

    public void setX(int x) {
        this.slider.x = x;
        if (this.isSwitch) {
            this.button.x = x + 150;
        } else {
            this.button.x = x + 150 + 36;
            this.textField.x = x + 150;
        }
    }

    public void setY(int y) {
        this.slider.y = y;
        this.button.y = y;
        if (!this.isSwitch) {
            this.textField.y = y;
        }
    }

    public void mouseClicked(double mouseX, double mouseY, int button) {
        this.slider.mouseClicked(mouseX, mouseY, button);
        this.button.mouseClicked(mouseX, mouseY, button);
    }

    public void mouseReleased(double mouseX, double mouseY, int button) {
        this.slider.mouseReleased(mouseX, mouseY, button);
        this.button.mouseReleased(mouseX, mouseY, button);
    }

    public void mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        this.slider.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
        this.button.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }
}

