/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.gui;

import com.google.common.collect.Lists;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.events.PlayerTickHandler;
import harmonised.pmmo.gui.MainScreen;
import harmonised.pmmo.gui.PrefsChoiceScreen;
import harmonised.pmmo.gui.PrefsEntry;
import harmonised.pmmo.gui.PrefsScrollPanel;
import harmonised.pmmo.gui.TileButton;
import harmonised.pmmo.gui.XPOverlayGUI;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.DP;
import harmonised.pmmo.util.XP;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class PrefsScreen
extends Screen {
    public static Map<String, Double> prefsMap;
    private final List<IGuiEventListener> children = Lists.newArrayList();
    private final ResourceLocation box = XP.getResLoc("pmmo", "textures/gui/screenboxy.png");
    private int i;
    private double value;
    private static Button exitButton;
    MainWindow sr = Minecraft.func_71410_x().func_228018_at_();
    private int boxWidth = 256;
    private int boxHeight = 256;
    private int x;
    private int y;
    private int scrollX;
    private int scrollY;
    private int buttonX;
    private PrefsScrollPanel scrollPanel;
    private final JType jType;
    private ArrayList<PrefsEntry> prefsEntries;
    private ITextComponent title;
    private PlayerEntity player;

    public PrefsScreen(ITextComponent titleIn, JType jType) {
        super(titleIn);
        this.player = Minecraft.func_71410_x().field_71439_g;
        this.title = titleIn;
        this.jType = jType;
    }

    protected void init() {
        prefsMap = Config.getPreferencesMap(this.player);
        this.x = this.sr.func_198107_o() / 2 - this.boxWidth / 2;
        this.y = this.sr.func_198087_p() / 2 - this.boxHeight / 2;
        this.scrollX = this.x + 16;
        this.scrollY = this.y + 10;
        this.buttonX = this.scrollX + 4;
        exitButton = new TileButton(this.x + this.boxWidth - 24, this.y - 8, 7, 0, "", JType.STATS, button -> Minecraft.func_71410_x().func_147108_a((Screen)new PrefsChoiceScreen((ITextComponent)new TranslationTextComponent("pmmo.stats", new Object[0]))));
        this.prefsEntries = new ArrayList();
        switch (this.jType) {
            case SETTINGS: {
                this.value = Math.min((double)Skill.BUILDING.getLevel(this.player) / Config.getConfig("levelsPerOneReach"), Config.getConfig("maxExtraReachBoost"));
                this.prefsEntries.add(new PrefsEntry("maxExtraReachBoost", "", "", 0.0, this.value, prefsMap.getOrDefault("maxExtraReachBoost", this.value), this.value, true, true, true, false));
                this.value = Math.min((double)Skill.ENDURANCE.getLevel(this.player) / Config.getConfig("levelsPerHeart"), Config.getConfig("maxExtraHeartBoost"));
                this.prefsEntries.add(new PrefsEntry("maxExtraHeartBoost", "", "", 0.0, this.value, prefsMap.getOrDefault("maxExtraHeartBoost", this.value), this.value, false, true, true, false));
                this.value = Math.min((double)Skill.COMBAT.getLevel(this.player) / Config.getConfig("levelsPerDamage"), Config.getConfig("maxExtraDamageBoost"));
                this.prefsEntries.add(new PrefsEntry("maxExtraDamageBoost", "", "", 0.0, this.value, prefsMap.getOrDefault("maxExtraDamageBoost", this.value), this.value, false, true, true, false));
                this.value = Math.min((double)Skill.AGILITY.getLevel(this.player) * Config.getConfig("speedBoostPerLevel"), Config.getConfig("maxSpeedBoost"));
                this.prefsEntries.add(new PrefsEntry("maxSpeedBoost", "", "", 0.0, this.value, prefsMap.getOrDefault("maxSpeedBoost", this.value), this.value, true, true, true, false));
                this.value = Math.min((double)Skill.AGILITY.getLevel(this.player) * Config.getConfig("levelsPerSprintJumpBoost"), Config.getConfig("maxJumpBoost"));
                this.prefsEntries.add(new PrefsEntry("maxSprintJumpBoost", "", "", 0.0, this.value, prefsMap.getOrDefault("maxSprintJumpBoost", this.value), this.value, true, true, true, false));
                this.value = Math.min((double)Skill.AGILITY.getLevel(this.player) * Config.getConfig("levelsPerCrouchJumpBoost"), Config.getConfig("maxJumpBoost"));
                this.prefsEntries.add(new PrefsEntry("maxCrouchJumpBoost", "", "", 0.0, this.value, prefsMap.getOrDefault("maxCrouchJumpBoost", this.value), this.value, true, true, true, false));
                this.prefsEntries.add(new PrefsEntry("wipeAllSkillsUponDeathPermanently", "", "", 0.0, 1.0, prefsMap.getOrDefault("wipeAllSkillsUponDeathPermanently", 0.0), 0.0, false, true, false, true));
                this.prefsEntries.add(new PrefsEntry("spawnFireworksCausedByMe", "", "", 0.0, 1.0, prefsMap.getOrDefault("spawnFireworksCausedByMe", 1.0), 1.0, false, true, false, true));
                this.prefsEntries.add(new PrefsEntry("spawnFireworksCausedByOthers", "", "", 0.0, 1.0, prefsMap.getOrDefault("spawnFireworksCausedByOthers", 1.0), 1.0, false, true, false, true));
                break;
            }
            case GUI_SETTINGS: {
                this.prefsEntries.add(new PrefsEntry("barOffsetX", "", "", 0.0, 1.0, prefsMap.getOrDefault("barOffsetX", 0.5), 0.5, true, true, false, false));
                this.prefsEntries.add(new PrefsEntry("barOffsetY", "", "", 0.0, 1.0, prefsMap.getOrDefault("barOffsetY", 0.0), 0.0, true, true, false, false));
                this.prefsEntries.add(new PrefsEntry("veinBarOffsetX", "", "", 0.0, 1.0, prefsMap.getOrDefault("veinBarOffsetX", 0.5), 0.5, true, true, false, false));
                this.prefsEntries.add(new PrefsEntry("veinBarOffsetY", "", "", 0.0, 1.0, prefsMap.getOrDefault("veinBarOffsetY", 0.65), 0.65, true, true, false, false));
                this.prefsEntries.add(new PrefsEntry("xpDropOffsetX", "", "", 0.0, 1.0, prefsMap.getOrDefault("xpDropOffsetX", 0.5), 0.5, true, true, false, false));
                this.prefsEntries.add(new PrefsEntry("xpDropOffsetY", "", "", 0.0, 1.0, prefsMap.getOrDefault("xpDropOffsetY", 0.0), 0.0, true, true, false, false));
                this.prefsEntries.add(new PrefsEntry("xpDropSpawnDistance", "", "", 0.0, 1000.0, prefsMap.getOrDefault("xpDropSpawnDistance", 50.0), 50.0, false, true, false, false));
                this.prefsEntries.add(new PrefsEntry("xpDropOpacityPerTime", "", "", 0.0, 255.0, prefsMap.getOrDefault("xpDropOpacityPerTime", 5.0), 5.0, false, true, false, false));
                this.prefsEntries.add(new PrefsEntry("xpDropMaxOpacity", "", "", 0.0, 255.0, prefsMap.getOrDefault("xpDropMaxOpacity", 200.0), 200.0, false, true, false, false));
                this.prefsEntries.add(new PrefsEntry("xpDropDecayAge", "", "", 0.0, 5000.0, prefsMap.getOrDefault("xpDropDecayAge", 350.0), 350.0, false, true, false, false));
                this.prefsEntries.add(new PrefsEntry("minXpGrow", "", "", 0.01, 100.0, prefsMap.getOrDefault("minXpGrow", 1.0), 1.0, true, true, false, false));
                this.prefsEntries.add(new PrefsEntry("showSkillsListAtCorner", "", "", 0.0, 1.0, prefsMap.getOrDefault("showSkillsListAtCorner", 1.0), 1.0, false, true, false, true));
                this.prefsEntries.add(new PrefsEntry("showXpDrops", "", "", 0.0, 1.0, prefsMap.getOrDefault("showXpDrops", 1.0), 1.0, false, true, false, true));
                this.prefsEntries.add(new PrefsEntry("stackXpDrops", "", "", 0.0, 1.0, prefsMap.getOrDefault("stackXpDrops", 1.0), 1.0, false, true, false, true));
                this.prefsEntries.add(new PrefsEntry("xpDropsAttachedToBar", "", "", 0.0, 1.0, prefsMap.getOrDefault("xpDropsAttachedToBar", 1.0), 1.0, false, true, false, true));
                this.prefsEntries.add(new PrefsEntry("xpBarAlwaysOn", "", "", 0.0, 1.0, prefsMap.getOrDefault("xpBarAlwaysOn", 0.0), 0.0, false, true, false, true));
                this.prefsEntries.add(new PrefsEntry("xpLeftDisplayAlwaysOn", "", "", 0.0, 1.0, prefsMap.getOrDefault("xpLeftDisplayAlwaysOn", 0.0), 0.0, false, true, false, true));
                this.prefsEntries.add(new PrefsEntry("lvlUpScreenshot", "", "", 0.0, 1.0, prefsMap.getOrDefault("lvlUpScreenshot", 0.0), 0.0, false, true, false, true));
                this.prefsEntries.add(new PrefsEntry("xpDropsShowXpBar", "", "", 0.0, 1.0, prefsMap.getOrDefault("xpDropsShowXpBar", 1.0), 1.0, false, true, false, true));
            }
        }
        this.i = 0;
        for (PrefsEntry prefEntry : this.prefsEntries) {
            if (!prefEntry.isSwitch) {
                prefEntry.textField.func_212954_a(text -> {
                    try {
                        this.value = Double.parseDouble(text);
                        if (this.value > prefEntry.slider.maxValue) {
                            this.value = prefEntry.slider.maxValue;
                        }
                        if (this.value < prefEntry.slider.minValue) {
                            this.value = prefEntry.slider.minValue;
                        }
                        prefEntry.slider.setValue(this.value);
                        prefEntry.slider.updateSlider();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
                prefEntry.textField.func_200675_a(text -> text.matches("^[0-9]{0,3}[.]?[0-9]*$") && text.replace(".", "").length() < 5);
            }
            prefEntry.slider.setResponder(slider -> {
                slider.precision = 4;
                prefsMap.put(slider.preference, slider.getValue());
                if (prefEntry.removeIfMax && slider.getValue() == slider.maxValue) {
                    prefsMap.remove(slider.preference);
                }
                XPOverlayGUI.doInit();
                PlayerTickHandler.syncPrefs = true;
            });
            prefEntry.slider.updateSlider();
            prefEntry.setX(this.x + 24);
            prefEntry.setY(this.y + 24 + 18 * this.i++);
        }
        this.scrollPanel = new PrefsScrollPanel(Minecraft.func_71410_x(), this.boxWidth - 40, this.boxHeight - 21, this.scrollY, this.scrollX, this.prefsEntries);
        if (!MainScreen.scrollAmounts.containsKey((Object)this.jType)) {
            MainScreen.scrollAmounts.put(this.jType, 0);
        }
        this.scrollPanel.setScroll(MainScreen.scrollAmounts.get((Object)this.jType));
        this.children.add((IGuiEventListener)this.scrollPanel);
        this.addButton((Widget)exitButton);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(1);
        if (this.font.func_78256_a(this.title.getString()) > 220) {
            this.drawCenteredString(this.font, this.title.func_150254_d(), this.sr.func_198107_o() / 2, this.y - 10, 0xFFFFFF);
        } else {
            this.drawCenteredString(this.font, this.title.func_150254_d(), this.sr.func_198107_o() / 2, this.y - 5, 0xFFFFFF);
        }
        this.x = this.sr.func_198107_o() / 2 - this.boxWidth / 2;
        this.y = this.sr.func_198087_p() / 2 - this.boxHeight / 2;
        this.scrollPanel.render(mouseX, mouseY, partialTicks);
        for (PrefsEntry prefEntry : this.prefsEntries) {
            if (mouseX < prefEntry.button.x || mouseX >= prefEntry.button.x + prefEntry.button.getWidth() || mouseY < prefEntry.button.y || mouseY >= prefEntry.button.y + prefEntry.button.getHeight()) continue;
            this.renderTooltip(prefEntry.isSwitch ? (prefEntry.defaultVal == 1.0 ? "ON" : "OFF") : (prefEntry.removeIfMax && prefEntry.defaultVal == prefEntry.slider.maxValue ? "MAX" : DP.dpSoft(prefEntry.defaultVal)), mouseX, mouseY);
        }
        MainScreen.scrollAmounts.replace(this.jType, this.scrollPanel.getScroll());
        super.render(mouseX, mouseY, partialTicks);
    }

    public void renderBackground(int p_renderBackground_1_) {
        if (this.minecraft != null) {
            this.fillGradient(0, 0, this.width, this.height, 0x66222222, 0x66333333);
            MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.BackgroundDrawnEvent((Screen)this));
        }
        this.boxHeight = 256;
        this.boxWidth = 256;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.box);
        this.blit(this.x, this.y, 0, 0, this.boxWidth, this.boxHeight);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scroll) {
        if (this.prefsEntries.size() >= 9) {
            this.scrollPanel.mouseScrolled(mouseX, mouseY, scroll);
        }
        return super.mouseScrolled(mouseX, mouseY, scroll);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 1) {
            exitButton.onPress();
            return true;
        }
        for (PrefsEntry prefEntry : this.prefsEntries) {
            if (!(mouseY >= (double)this.scrollPanel.getTop()) || !(mouseY <= (double)this.scrollPanel.getBottom())) continue;
            prefEntry.mouseClicked(mouseX, mouseY, button);
            if (prefEntry.isSwitch || !prefEntry.textField.mouseClicked(mouseX, mouseY, button)) continue;
            this.setFocused((IGuiEventListener)prefEntry.textField);
        }
        this.scrollPanel.mouseClicked(mouseX, mouseY, button);
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        for (PrefsEntry prefEntry : this.prefsEntries) {
            if (!(mouseY >= (double)this.scrollPanel.getTop()) || !(mouseY <= (double)this.scrollPanel.getBottom())) continue;
            prefEntry.mouseReleased(mouseX, mouseY, button);
        }
        this.scrollPanel.mouseReleased(mouseX, mouseY, button);
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        for (PrefsEntry prefEntry : this.prefsEntries) {
            if (!(mouseY >= (double)this.scrollPanel.getTop()) || !(mouseY <= (double)this.scrollPanel.getBottom())) continue;
            prefEntry.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
        }
        this.scrollPanel.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    public static TranslationTextComponent getTransComp(String translationKey, Double ... args) {
        return new TranslationTextComponent(translationKey, (Object[])args);
    }
}

