/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.network;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.network.MessageXp;
import harmonised.pmmo.network.NetworkHandler;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.DP;
import harmonised.pmmo.util.XP;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessageLevelUp {
    public static final Logger LOGGER = LogManager.getLogger();
    private int skill;
    private int level;

    public MessageLevelUp(int skill, int level) {
        this.skill = skill;
        this.level = level;
    }

    public MessageLevelUp() {
    }

    public static MessageLevelUp decode(PacketBuffer buf) {
        MessageLevelUp packet = new MessageLevelUp();
        packet.skill = buf.readInt();
        packet.level = buf.readInt();
        return packet;
    }

    public static void encode(MessageLevelUp packet, PacketBuffer buf) {
        buf.writeInt(packet.skill);
        buf.writeInt(packet.level);
    }

    public static void handlePacket(MessageLevelUp packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            Skill skill = Skill.getSkill(packet.skill);
            if (packet.level <= skill.getLevel((PlayerEntity)player)) {
                Map<String, Double> prefsMap = Config.getPreferencesMap((PlayerEntity)player);
                String skillName = skill.name().toLowerCase();
                Vec3d playerPos = player.func_213303_ch();
                if (Config.forgeConfig.levelUpFirework.get().booleanValue() && (!prefsMap.containsKey("spawnFireworksCausedByMe") || prefsMap.get("spawnFireworksCausedByMe") != 0.0)) {
                    XP.spawnRocket(player.field_70170_p, player.func_180425_c(), skill);
                }
                LOGGER.info(player.func_145748_c_().getString() + " has reached level " + packet.level + " in " + skillName + "! [" + player.field_71093_bK.getRegistryName().toString() + "|x:" + DP.dp(playerPos.func_82615_a()) + "|y:" + DP.dp(playerPos.func_82617_b()) + "|z:" + DP.dp(playerPos.func_82616_c()) + "]");
                if (packet.level % Config.forgeConfig.levelsPerMilestone.get() == 0 && Config.forgeConfig.broadcastMilestone.get().booleanValue()) {
                    player.field_71133_b.func_184103_al().func_181057_v().forEach(otherPlayer -> {
                        if (otherPlayer.func_110124_au() != player.func_110124_au()) {
                            Map<String, Double> otherprefsMap = Config.getPreferencesMap((PlayerEntity)otherPlayer);
                            otherPlayer.func_146105_b(new TranslationTextComponent("pmmo.milestoneLevelUp", new Object[]{player.func_145748_c_(), packet.level, new TranslationTextComponent("pmmo." + skillName, new Object[0])}).func_150255_a(XP.getSkillStyle(skill)), false);
                            if (Config.forgeConfig.milestoneLevelUpFirework.get().booleanValue() && (!otherprefsMap.containsKey("spawnFireworksCausedByOthers") || otherprefsMap.get("spawnFireworksCausedByOthers") != 0.0)) {
                                XP.spawnRocket(otherPlayer.field_70170_p, otherPlayer.func_180425_c(), skill);
                            }
                        }
                    });
                }
            } else {
                NetworkHandler.sendToPlayer(new MessageXp(skill.getXp((PlayerEntity)player), skill.getValue(), 0.0, true), player);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

