/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.network;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.config.JsonConfig;
import harmonised.pmmo.events.WorldTickHandler;
import harmonised.pmmo.proxy.ClientHandler;
import harmonised.pmmo.proxy.ServerHandler;
import harmonised.pmmo.skills.AttributeHandler;
import harmonised.pmmo.util.NBTHelper;
import harmonised.pmmo.util.XP;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessageUpdatePlayerNBT {
    public static final Logger LOGGER = LogManager.getLogger();
    public CompoundNBT reqPackage = new CompoundNBT();
    public int type;

    public MessageUpdatePlayerNBT(CompoundNBT theNBT, int type) {
        this.reqPackage = theNBT;
        this.type = type;
    }

    MessageUpdatePlayerNBT() {
    }

    public static MessageUpdatePlayerNBT decode(PacketBuffer buf) {
        MessageUpdatePlayerNBT packet = new MessageUpdatePlayerNBT();
        packet.reqPackage = buf.func_150793_b();
        packet.type = buf.readInt();
        return packet;
    }

    public static void encode(MessageUpdatePlayerNBT packet, PacketBuffer buf) {
        buf.func_150786_a(packet.reqPackage);
        buf.writeInt(packet.type);
    }

    public static void handlePacket(MessageUpdatePlayerNBT packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            switch (packet.type) {
                case 0: 
                case 1: {
                    if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().equals((Object)LogicalSide.CLIENT)) {
                        ClientHandler.updateNBTTag(packet);
                        break;
                    }
                    ServerHandler.updateNBTTag(packet, (PlayerEntity)((NetworkEvent.Context)ctx.get()).getSender());
                    break;
                }
                case 2: {
                    if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().equals((Object)LogicalSide.CLIENT)) {
                        Config.setConfigMap(NBTHelper.nbtToMapString(packet.reqPackage));
                        WorldTickHandler.refreshVein();
                        AttributeHandler.init();
                        break;
                    }
                    LOGGER.error("TYPE " + packet.type + " UPDATE NBT PACKET HAS BEEN SENT TO SERVER", (Object)packet);
                    break;
                }
                case 3: {
                    if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().equals((Object)LogicalSide.CLIENT)) {
                        UUID uuid = UUID.fromString(packet.reqPackage.func_74779_i("UUID"));
                        packet.reqPackage.func_82580_o("UUID");
                        String name = packet.reqPackage.func_74779_i("name");
                        packet.reqPackage.func_82580_o("name");
                        if (!XP.playerNames.containsKey(uuid)) {
                            XP.playerNames.put(uuid, name);
                        }
                        XP.setOfflineXpMap(uuid, NBTHelper.nbtToMapSkill(packet.reqPackage));
                        ClientHandler.openStats(uuid);
                        break;
                    }
                    LOGGER.error("TYPE " + packet.type + " UPDATE NBT PACKET HAS BEEN SENT TO SERVER", (Object)packet);
                    break;
                }
                case 4: {
                    if (packet.reqPackage.func_74764_b("wipe")) {
                        JsonConfig.data = new HashMap<JType, Map<String, Map<String, Double>>>();
                        JsonConfig.initMap(JsonConfig.data);
                        break;
                    }
                    NBTHelper.addData3(JsonConfig.data, NBTHelper.nbtToData3(packet.reqPackage));
                    break;
                }
                case 5: {
                    if (packet.reqPackage.func_74764_b("wipe")) {
                        JsonConfig.data2 = new HashMap<JType, Map<String, Map<String, Map<String, Double>>>>();
                        JsonConfig.initMap2(JsonConfig.data2);
                        break;
                    }
                    NBTHelper.addData4(JsonConfig.data2, NBTHelper.nbtToData4(packet.reqPackage));
                    break;
                }
                case 6: {
                    if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().equals((Object)LogicalSide.CLIENT)) {
                        ClientHandler.updateNBTTag(packet);
                        break;
                    }
                    LOGGER.error("XP BOOST PACKET SENT TO SERVER");
                    break;
                }
                default: {
                    LOGGER.error("WRONG SYNC ID AT NBT UPDATE PACKET", (Object)packet);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

