/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.pmmo_saved_data;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.party.Party;
import harmonised.pmmo.party.PartyMemberInfo;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.NBTHelper;
import harmonised.pmmo.util.XP;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.storage.WorldSavedData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PmmoSavedData
extends WorldSavedData {
    public static final Logger LOGGER = LogManager.getLogger();
    private static PmmoSavedData pmmoSavedData;
    private static MinecraftServer server;
    private static String NAME;
    private Map<UUID, Map<Skill, Double>> xp = new HashMap<UUID, Map<Skill, Double>>();
    private Map<UUID, Map<Skill, Double>> scheduledXp = new HashMap<UUID, Map<Skill, Double>>();
    private Map<UUID, Map<String, Double>> abilities = new HashMap<UUID, Map<String, Double>>();
    private Map<UUID, Map<String, Double>> preferences = new HashMap<UUID, Map<String, Double>>();
    private Map<UUID, Map<String, Map<Skill, Double>>> xpBoosts = new HashMap<UUID, Map<String, Map<Skill, Double>>>();
    private Set<Party> parties = new HashSet<Party>();
    private Map<UUID, String> name = new HashMap<UUID, String>();

    public PmmoSavedData() {
        super(NAME);
    }

    public void func_76184_a(CompoundNBT inData) {
        if (inData.func_74764_b("players")) {
            CompoundNBT playersTag = inData.func_74775_l("players");
            for (String playerUuidKey : playersTag.func_150296_c()) {
                CompoundNBT playerTag = playersTag.func_74775_l(playerUuidKey);
                if (playerTag.func_74764_b("xp")) {
                    CompoundNBT xpTag = playerTag.func_74775_l("xp");
                    for (String tag : new HashSet(xpTag.func_150296_c())) {
                        if (Skill.getInt(tag) != 0) continue;
                        if (Skill.getInt(tag.toLowerCase()) != 0) {
                            xpTag.func_218657_a(tag.toLowerCase(), xpTag.func_74781_a(tag));
                        }
                        if (tag.toLowerCase().equals("repairing")) {
                            xpTag.func_218657_a("smithing", xpTag.func_74781_a(tag));
                        }
                        LOGGER.info("REMOVING INVALID SKILL " + tag + " FROM PLAYER " + playerUuidKey);
                        xpTag.func_82580_o(tag);
                    }
                }
                if (playerTag.func_74764_b("name")) {
                    this.name.put(UUID.fromString(playerUuidKey), playerTag.func_74779_i("name"));
                }
                this.xp = NBTHelper.nbtToMapUuidSkill(NBTHelper.extractNbtPlayersIndividualTagsFromPlayersTag(playersTag, "xp"));
                this.scheduledXp = NBTHelper.nbtToMapUuidSkill(NBTHelper.extractNbtPlayersIndividualTagsFromPlayersTag(playersTag, "scheduledXp"));
                this.abilities = NBTHelper.nbtToMapUuidString(NBTHelper.extractNbtPlayersIndividualTagsFromPlayersTag(playersTag, "abilities"));
                this.preferences = NBTHelper.nbtToMapUuidString(NBTHelper.extractNbtPlayersIndividualTagsFromPlayersTag(playersTag, "preferences"));
                this.xpBoosts = NBTHelper.nbtToMapStringMapUuidSkill(NBTHelper.extractNbtPlayersIndividualTagsFromPlayersTag(playersTag, "xpBoosts"));
            }
        }
        if (inData.func_74764_b("parties")) {
            CompoundNBT partiesTag = inData.func_74775_l("parties");
            for (String key : partiesTag.func_150296_c()) {
                CompoundNBT partyTag = partiesTag.func_74775_l(key);
                CompoundNBT membersTag = partyTag.func_74775_l("members");
                HashSet<PartyMemberInfo> membersInfo = new HashSet<PartyMemberInfo>();
                for (String id : membersTag.func_150296_c()) {
                    CompoundNBT memberInfoTag = membersTag.func_74775_l(id);
                    PartyMemberInfo memberInfo = new PartyMemberInfo(UUID.fromString(memberInfoTag.func_74779_i("uuid")), memberInfoTag.func_74763_f("joinDate"), memberInfoTag.func_74769_h("xpGained"));
                    membersInfo.add(memberInfo);
                }
                this.parties.add(new Party(partyTag.func_74763_f("creationDate"), membersInfo));
            }
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT outData) {
        CompoundNBT playersTag = new CompoundNBT();
        CompoundNBT partiesTag = new CompoundNBT();
        for (Map.Entry<UUID, Map<Skill, Double>> entry : this.xp.entrySet()) {
            HashMap<String, CompoundNBT> playerMap = new HashMap<String, CompoundNBT>();
            playerMap.put("xp", NBTHelper.mapSkillToNbt(this.xp.getOrDefault(entry.getKey(), new HashMap())));
            playerMap.put("scheduledXp", NBTHelper.mapSkillToNbt(this.scheduledXp.getOrDefault(entry.getKey(), new HashMap())));
            playerMap.put("abilities", NBTHelper.mapStringToNbt(this.abilities.getOrDefault(entry.getKey(), new HashMap())));
            playerMap.put("preferences", NBTHelper.mapStringToNbt(this.preferences.getOrDefault(entry.getKey(), new HashMap())));
            playerMap.put("xpBoosts", NBTHelper.mapStringMapSkillToNbt(this.xpBoosts.getOrDefault(entry.getKey(), new HashMap())));
            CompoundNBT playerTag = NBTHelper.mapStringNbtToNbt(playerMap);
            playerTag.func_74778_a("name", this.name.get(entry.getKey()));
            playersTag.func_218657_a(entry.getKey().toString(), (INBT)playerTag);
        }
        outData.func_218657_a("players", (INBT)playersTag);
        int i = 0;
        for (Party party : this.parties) {
            CompoundNBT partyTag = new CompoundNBT();
            CompoundNBT membersTag = new CompoundNBT();
            int j = 0;
            for (PartyMemberInfo memberInfo : party.getAllMembersInfo()) {
                CompoundNBT memberInfoTag = new CompoundNBT();
                memberInfoTag.func_74778_a("uuid", memberInfo.uuid.toString());
                memberInfoTag.func_74772_a("joinDate", memberInfo.joinDate);
                memberInfoTag.func_74780_a("xpGained", memberInfo.xpGained);
                membersTag.func_218657_a("" + j++, (INBT)memberInfoTag);
            }
            partyTag.func_74772_a("creationDate", party.getCreationDate());
            partyTag.func_218657_a("members", (INBT)membersTag);
            partiesTag.func_218657_a("" + i, (INBT)partyTag);
            ++i;
        }
        outData.func_218657_a("parties", (INBT)partiesTag);
        return outData;
    }

    public Map<Skill, Double> getXpMap(UUID uuid) {
        if (!this.xp.containsKey(uuid)) {
            this.xp.put(uuid, new HashMap());
        }
        return this.xp.get(uuid);
    }

    public Map<Skill, Double> getScheduledXpMap(UUID uuid) {
        if (!this.scheduledXp.containsKey(uuid)) {
            this.scheduledXp.put(uuid, new HashMap());
        }
        return this.scheduledXp.get(uuid);
    }

    public Map<String, Double> getAbilitiesMap(UUID uuid) {
        if (!this.abilities.containsKey(uuid)) {
            this.abilities.put(uuid, new HashMap());
        }
        return this.abilities.get(uuid);
    }

    public Map<String, Double> getPreferencesMap(UUID uuid) {
        if (!this.preferences.containsKey(uuid)) {
            this.preferences.put(uuid, new HashMap());
        }
        return this.preferences.get(uuid);
    }

    public double getXp(Skill skill, UUID uuid) {
        if (skill.equals((Object)Skill.INVALID_SKILL)) {
            LOGGER.error("Invalid Skill at getXp");
            return -1.0;
        }
        return ((Map)this.xp.getOrDefault(uuid, new HashMap())).getOrDefault((Object)skill, 0.0);
    }

    public int getLevel(Skill skill, UUID uuid) {
        return XP.levelAtXp(this.getXp(skill, uuid));
    }

    public double getLevelDecimal(Skill skill, UUID uuid) {
        return XP.levelAtXpDecimal(this.getXp(skill, uuid));
    }

    public boolean setXp(Skill skill, UUID uuid, double amount) {
        if (!skill.equals((Object)Skill.INVALID_SKILL)) {
            double maxXp = Config.getConfig("maxXp");
            if (amount > maxXp) {
                amount = maxXp;
            }
            if (amount < 0.0) {
                amount = 0.0;
            }
            if (!this.xp.containsKey(uuid)) {
                this.xp.put(uuid, new HashMap());
            }
            this.xp.get(uuid).put(skill, amount);
            this.func_76186_a(true);
            return true;
        }
        LOGGER.error("Invalid Skill at method setXp, amount: " + amount);
        return false;
    }

    public boolean addXp(Skill skill, UUID uuid, double amount) {
        if (!skill.equals((Object)Skill.INVALID_SKILL)) {
            this.setXp(skill, uuid, this.getXp(skill, uuid) + amount);
            this.func_76186_a(true);
            return true;
        }
        LOGGER.error("Invalid Skill at method addXp, amount: " + amount);
        return false;
    }

    public void scheduleXp(Skill skill, UUID uuid, double amount, String sourceName) {
        if (!skill.equals((Object)Skill.INVALID_SKILL)) {
            Map<Skill, Double> scheduledXpMap = this.getScheduledXpMap(uuid);
            if (!scheduledXpMap.containsKey((Object)skill)) {
                scheduledXpMap.put(skill, amount);
            } else {
                scheduledXpMap.put(skill, amount + scheduledXpMap.get((Object)skill));
            }
            LOGGER.debug("Scheduled " + amount + "xp for: " + sourceName + ", to: " + this.getName(uuid));
            this.func_76186_a(true);
        } else {
            LOGGER.error("Invalid Skill at method addXp, amount: " + amount);
        }
    }

    public void removeScheduledXpUuid(UUID uuid) {
        this.scheduledXp.remove(uuid);
    }

    public void setName(String name, UUID uuid) {
        this.name.put(uuid, name);
    }

    public String getName(UUID uuid) {
        return this.name.getOrDefault(uuid, "Nameless Warning");
    }

    public Party getParty(UUID uuid) {
        Party party = null;
        for (Party thisParty : this.parties) {
            if (thisParty.getMemberInfo(uuid) == null) continue;
            party = thisParty;
        }
        return party;
    }

    public boolean makeParty(UUID uuid) {
        if (this.getParty(uuid) == null) {
            Party party = new Party(System.currentTimeMillis(), new HashSet<PartyMemberInfo>());
            party.addMember(uuid);
            this.parties.add(party);
            return true;
        }
        return false;
    }

    public int addToParty(UUID ownerUuid, UUID newMemberUuid) {
        Party ownerParty = this.getParty(ownerUuid);
        Party newMemberParty = this.getParty(newMemberUuid);
        if (ownerParty == null) {
            return -1;
        }
        if (newMemberParty != null) {
            return -2;
        }
        if (ownerParty.getMembersCount() + 1 > Party.getMaxPartyMembers()) {
            return -4;
        }
        ownerParty.addMember(newMemberUuid);
        this.func_76185_a();
        return 0;
    }

    public int removeFromParty(UUID uuid) {
        Party party = this.getParty(uuid);
        if (party == null) {
            return -1;
        }
        party.removeMember(uuid);
        if (party.getPartySize() == 0) {
            this.parties.remove(party);
            this.func_76185_a();
            return 1;
        }
        return 0;
    }

    public static void init(MinecraftServer server) {
        PmmoSavedData.server = server;
        pmmoSavedData = (PmmoSavedData)server.func_71218_a(DimensionType.field_223227_a_).func_217481_x().func_215752_a(PmmoSavedData::new, NAME);
    }

    public static PmmoSavedData get() {
        return pmmoSavedData;
    }

    public static MinecraftServer getServer() {
        return server;
    }

    public Map<String, Map<Skill, Double>> getPlayerXpBoostsMap(UUID playerUUID) {
        return this.xpBoosts.getOrDefault(playerUUID, new HashMap());
    }

    public Map<Skill, Double> getPlayerXpBoostMap(UUID playerUUID, UUID xpBoostUUID) {
        return this.getPlayerXpBoostsMap(playerUUID).getOrDefault(xpBoostUUID, new HashMap());
    }

    public double getPlayerXpBoost(UUID playerUUID, Skill skill) {
        double xpBoost = 0.0;
        for (Map.Entry<String, Map<Skill, Double>> entry : this.getPlayerXpBoostsMap(playerUUID).entrySet()) {
            xpBoost += entry.getValue().getOrDefault((Object)skill, 0.0).doubleValue();
        }
        return xpBoost;
    }

    public void setPlayerXpBoostsMaps(UUID playerUUID, Map<String, Map<Skill, Double>> newBoosts) {
        this.xpBoosts.put(playerUUID, newBoosts);
        this.func_76186_a(true);
    }

    public void setPlayerXpBoost(UUID playerUUID, String xpBoostKey, Map<Skill, Double> newXpBoosts) {
        for (Map.Entry<Skill, Double> entry : newXpBoosts.entrySet()) {
            this.setPlayerXpBoost(playerUUID, xpBoostKey, entry.getKey(), entry.getValue());
        }
        ServerPlayerEntity player = XP.getPlayerByUUID(playerUUID, server);
        if (player != null) {
            XP.syncPlayerXpBoost((PlayerEntity)player);
        }
        this.func_76186_a(true);
    }

    public void removePlayerXpBoost(UUID playerUUID, String xpBoostKey) {
        this.getPlayerXpBoostsMap(playerUUID).remove(xpBoostKey);
        this.func_76186_a(true);
    }

    public void removeAllPlayerXpBoosts(UUID playerUUID) {
        this.xpBoosts.remove(playerUUID);
        this.func_76186_a(true);
    }

    private void setPlayerXpBoost(UUID playerUUID, String xpBoostKey, Skill skill, Double xpBoost) {
        if (!this.xpBoosts.containsKey(playerUUID)) {
            this.xpBoosts.put(playerUUID, new HashMap());
        }
        if (!this.xpBoosts.get(playerUUID).containsKey(xpBoostKey)) {
            this.xpBoosts.get(playerUUID).put(xpBoostKey, new HashMap());
        }
        this.xpBoosts.get(playerUUID).get(xpBoostKey).put(skill, xpBoost);
        this.func_76186_a(true);
    }

    static {
        NAME = "pmmo";
    }
}

