/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.skills;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.config.JsonConfig;
import harmonised.pmmo.events.WorldTickHandler;
import harmonised.pmmo.skills.Skill;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;

public class AttributeHandler {
    private static final UUID reachModifierID = UUID.fromString("b20d3436-0d39-4868-96ab-d0a4856e68c6");
    private static final UUID speedModifierID = UUID.fromString("d6103cbc-b90b-4c4b-b3c0-92701fb357b3");
    private static final UUID hpModifierID = UUID.fromString("c95a6e8c-a1c3-4177-9118-1e2cf49b7fcb");
    private static final UUID damageModifierID = UUID.fromString("992b11f1-7b3f-48d9-8ebd-1acfc3257b17");
    private static double levelsPerOneReach;
    private static double levelsPerHeart;
    private static double levelsPerDamage;
    private static double maxSpeedBoost;
    private static double speedBoostPerLevel;
    private static int maxExtraHeartBoost;
    private static double maxExtraReachBoost;
    private static double maxExtraDamageBoost;

    public static void init() {
        levelsPerOneReach = Config.getConfig("levelsPerOneReach");
        levelsPerHeart = Config.getConfig("levelsPerHeart");
        levelsPerDamage = Config.getConfig("levelsPerDamage");
        maxSpeedBoost = Config.getConfig("maxSpeedBoost");
        speedBoostPerLevel = Config.getConfig("speedBoostPerLevel");
        maxExtraHeartBoost = (int)Config.getConfig("maxExtraHeartBoost");
        maxExtraReachBoost = Config.getConfig("maxExtraReachBoost");
        maxExtraDamageBoost = Config.getConfig("maxExtraDamageBoost");
    }

    public static void updateAll(PlayerEntity player) {
        if (!player.field_70170_p.func_201670_d()) {
            WorldTickHandler.updateVein(player, 0.0);
        }
        AttributeHandler.updateReach(player);
        AttributeHandler.updateHP(player);
        AttributeHandler.updateDamage(player);
    }

    public static double getReach(PlayerEntity player) {
        IAttributeInstance reachAttribute = player.func_110148_a(PlayerEntity.REACH_DISTANCE);
        if (reachAttribute.func_111127_a(reachModifierID) == null) {
            return reachAttribute.func_111125_b();
        }
        return reachAttribute.func_111125_b() + reachAttribute.func_111127_a(reachModifierID).func_111164_d();
    }

    public static void updateReach(PlayerEntity player) {
        IAttributeInstance reachAttribute = player.func_110148_a(PlayerEntity.REACH_DISTANCE);
        Map<String, Double> prefsMap = Config.getPreferencesMap(player);
        double buildLevel = Skill.BUILDING.getLevel(player);
        double reach = -0.91 + buildLevel / levelsPerOneReach;
        Double maxReachPref = null;
        if (prefsMap.containsKey("maxExtraReachBoost")) {
            maxReachPref = prefsMap.get("maxExtraReachBoost");
        }
        if (reach > maxExtraReachBoost) {
            reach = maxExtraReachBoost;
        }
        if (maxReachPref != null && reach > maxReachPref) {
            reach = maxReachPref;
        }
        if (reachAttribute.func_111127_a(reachModifierID) == null || reachAttribute.func_111127_a(reachModifierID).func_111164_d() != reach) {
            AttributeModifier reachModifier = new AttributeModifier(reachModifierID, "Reach bonus thanks to Build Level", reach, AttributeModifier.Operation.ADDITION);
            reachAttribute.func_188479_b(reachModifierID);
            reachAttribute.func_111121_a(reachModifier);
        }
    }

    public static double getBaseSpeed(PlayerEntity player) {
        return player.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b();
    }

    public static double getSpeedBoost(PlayerEntity player) {
        int agilityLevel = Skill.AGILITY.getLevel(player);
        return AttributeHandler.getSpeedBoost(agilityLevel, AttributeHandler.getBaseSpeed(player));
    }

    public static double getSpeedBoost(int agilityLevel, double baseSpeed) {
        Map<String, Double> prefsMap = Config.getPreferencesMapOffline();
        Double maxSpeedBoostPref = null;
        if (prefsMap.containsKey("maxSpeedBoost")) {
            maxSpeedBoostPref = prefsMap.get("maxSpeedBoost");
        }
        double speedBoost = (double)agilityLevel * speedBoostPerLevel;
        double maxSpeed = baseSpeed * (maxSpeedBoost / 100.0);
        if (maxSpeedBoostPref != null && maxSpeed > baseSpeed * (maxSpeedBoostPref / 100.0)) {
            maxSpeed = baseSpeed * (maxSpeedBoostPref / 100.0);
        }
        if (speedBoost > maxSpeed) {
            speedBoost = maxSpeed;
        }
        return speedBoost;
    }

    public static void updateSpeed(PlayerEntity player) {
        IAttributeInstance speedAttribute = player.func_110148_a(SharedMonsterAttributes.field_111263_d);
        double speedBoost = AttributeHandler.getSpeedBoost(player);
        if (speedBoost > 0.0 && (speedAttribute.func_111127_a(speedModifierID) == null || speedAttribute.func_111127_a(speedModifierID).func_111164_d() != speedBoost)) {
            AttributeModifier speedModifier = new AttributeModifier(speedModifierID, "Speed bonus thanks to Agility Level", speedBoost, AttributeModifier.Operation.ADDITION);
            speedAttribute.func_188479_b(speedModifierID);
            speedAttribute.func_111121_a(speedModifier);
        }
    }

    public static void resetSpeed(PlayerEntity player) {
        IAttributeInstance speedAttribute = player.func_110148_a(SharedMonsterAttributes.field_111263_d);
        speedAttribute.func_188479_b(speedModifierID);
    }

    public static void updateHP(PlayerEntity player) {
        IAttributeInstance hpAttribute = player.func_110148_a(SharedMonsterAttributes.field_111267_a);
        Map<String, Double> prefsMap = Config.getPreferencesMap(player);
        double enduranceLevel = Skill.ENDURANCE.getLevel(player);
        int heartBoost = (int)Math.floor(enduranceLevel / levelsPerHeart) * 2;
        Integer maxHPPref = null;
        if (prefsMap.containsKey("maxExtraHeartBoost")) {
            maxHPPref = (int)Math.floor(prefsMap.get("maxExtraHeartBoost") * 2.0);
        }
        if (heartBoost > maxExtraHeartBoost * 2) {
            heartBoost = maxExtraHeartBoost * 2;
        }
        if (maxHPPref != null && heartBoost > maxHPPref) {
            heartBoost = maxHPPref;
        }
        AttributeModifier hpModifier = new AttributeModifier(hpModifierID, "Max HP Bonus thanks to Endurance Level", (double)heartBoost, AttributeModifier.Operation.ADDITION);
        hpAttribute.func_188479_b(hpModifierID);
        hpAttribute.func_111121_a(hpModifier);
    }

    public static void updateDamage(PlayerEntity player) {
        double combatLevel;
        double damageBoost;
        IAttributeInstance damageAttribute = player.func_110148_a(SharedMonsterAttributes.field_111264_e);
        Map<String, Double> prefsMap = Config.getPreferencesMap(player);
        Double maxDamagePref = null;
        if (prefsMap.containsKey("maxExtraDamageBoost")) {
            maxDamagePref = prefsMap.get("maxExtraDamageBoost");
        }
        if ((damageBoost = (combatLevel = (double)Skill.COMBAT.getLevel(player)) / levelsPerDamage) > maxExtraDamageBoost) {
            damageBoost = maxExtraDamageBoost;
        }
        if (maxDamagePref != null && damageBoost > maxDamagePref) {
            damageBoost = maxDamagePref;
        }
        AttributeModifier damageModifier = new AttributeModifier(damageModifierID, "Damage Boost thanks to Combat Level", damageBoost, AttributeModifier.Operation.ADDITION);
        damageAttribute.func_188479_b(damageModifierID);
        damageAttribute.func_111121_a(damageModifier);
    }

    public static void updateHP(MobEntity mob, float bonus) {
        IAttributeInstance hpAttribute = mob.func_110148_a(SharedMonsterAttributes.field_111267_a);
        if (hpAttribute != null) {
            boolean wasMaxHealth = mob.func_110143_aJ() == mob.func_110138_aP();
            double maxMobHPBoost = Config.forgeConfig.maxMobHPBoost.get();
            double mobHPBoostPerPowerLevel = Config.forgeConfig.mobHPBoostPerPowerLevel.get();
            if (!(mob instanceof AnimalEntity)) {
                bonus = (float)((double)bonus * mobHPBoostPerPowerLevel);
            }
            if ((double)(bonus = (float)((double)bonus * AttributeHandler.getBiomeMobMultiplier(mob, "hpBonus"))) > maxMobHPBoost) {
                bonus = (float)maxMobHPBoost;
            }
            AttributeModifier hpModifier = new AttributeModifier(hpModifierID, "Max HP Bonus thanks to Nearby Player Power Level", (double)bonus, AttributeModifier.Operation.ADDITION);
            hpAttribute.func_188479_b(hpModifierID);
            hpAttribute.func_111121_a(hpModifier);
            if (wasMaxHealth) {
                mob.func_70606_j(mob.func_110138_aP());
            }
        }
    }

    public static void updateDamage(MobEntity mob, float bonus) {
        IAttributeInstance damageAttribute = mob.func_110148_a(SharedMonsterAttributes.field_111264_e);
        if (damageAttribute != null) {
            double maxMobDamageBoost = Config.forgeConfig.maxMobDamageBoost.get();
            double mobDamageBoostPerPowerLevel = Config.forgeConfig.mobDamageBoostPerPowerLevel.get();
            bonus = (float)((double)bonus * mobDamageBoostPerPowerLevel);
            if ((double)(bonus = (float)((double)bonus * AttributeHandler.getBiomeMobMultiplier(mob, "damageBonus"))) > maxMobDamageBoost) {
                bonus = (float)maxMobDamageBoost;
            }
            AttributeModifier damageModifier = new AttributeModifier(damageModifierID, "Damage Boost thanks to Nearby Player Power Level", (double)bonus, AttributeModifier.Operation.ADDITION);
            damageAttribute.func_188479_b(damageModifierID);
            damageAttribute.func_111121_a(damageModifier);
        }
    }

    public static void updateSpeed(MobEntity mob, float bonus) {
        IAttributeInstance speedAttribute = mob.func_110148_a(SharedMonsterAttributes.field_111263_d);
        if (speedAttribute != null && !(mob instanceof AnimalEntity)) {
            double maxMobSpeedBoost = Config.forgeConfig.maxMobSpeedBoost.get();
            double mobSpeedBoostPerPowerLevel = Config.forgeConfig.mobSpeedBoostPerPowerLevel.get();
            bonus = (float)((double)bonus * mobSpeedBoostPerPowerLevel);
            if ((double)(bonus = (float)((double)bonus * AttributeHandler.getBiomeMobMultiplier(mob, "speedBonus"))) > maxMobSpeedBoost) {
                bonus = (float)maxMobSpeedBoost;
            }
            AttributeModifier speedModifier = new AttributeModifier(speedModifierID, "Movement Speed Boost thanks to Nearby Player Power Level", (double)(bonus / 100.0f), AttributeModifier.Operation.ADDITION);
            speedAttribute.func_188479_b(speedModifierID);
            speedAttribute.func_111121_a(speedModifier);
        }
    }

    private static double getBiomeMobMultiplier(MobEntity mob, String type) {
        Biome biome = mob.field_70170_p.func_226691_t_(new BlockPos(mob.func_213303_ch()));
        ResourceLocation biomeResLoc = biome.getRegistryName();
        double multiplier = 1.0;
        if (biomeResLoc != null) {
            String biomeKey = biome.getRegistryName().toString();
            Map<String, Double> theMap = JsonConfig.data.get((Object)JType.BIOME_MOB_MULTIPLIER).get(biomeKey);
            if (theMap != null && theMap.containsKey(type)) {
                multiplier = theMap.get(type);
            }
        }
        return multiplier;
    }
}

