/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.skills;

import harmonised.pmmo.network.MessageXp;
import harmonised.pmmo.network.NetworkHandler;
import harmonised.pmmo.pmmo_saved_data.PmmoSavedData;
import harmonised.pmmo.skills.AttributeHandler;
import harmonised.pmmo.util.XP;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;

public enum Skill {
    INVALID_SKILL(0),
    MINING(1),
    BUILDING(2),
    EXCAVATION(3),
    WOODCUTTING(4),
    FARMING(5),
    AGILITY(6),
    ENDURANCE(7),
    COMBAT(8),
    ARCHERY(9),
    SMITHING(10),
    FLYING(11),
    SWIMMING(12),
    FISHING(13),
    CRAFTING(14),
    MAGIC(15),
    SLAYER(16),
    HUNTER(17),
    FLETCHING(18),
    TAMING(19),
    ENGINEERING(20),
    BLOOD_MAGIC(21),
    ASTRAL_MAGIC(22),
    GOOD_MAGIC(23),
    EVIL_MAGIC(24),
    ARCANE_MAGIC(25),
    ELEMENTAL(26),
    EARTH(27),
    WATER(28),
    AIR(29),
    FIRE(30),
    LIGHTNING(31),
    VOID(32),
    THAUMATIC(33),
    SUMMONING(34),
    INVENTION(35),
    RUNECRAFTING(36),
    PRAYER(37),
    COOKING(38),
    FIREMAKING(39),
    TRADING(41),
    SAILING(42),
    ALCHEMY(43),
    CONSTRUCTION(44),
    LEATHERWORKING(45),
    EXPLORATION(46);

    public static final Map<Skill, Integer> skillMap;
    public static final Map<String, Skill> stringMap;
    public static final Skill[] valuesArray;
    private final int value;

    public String toString() {
        return this.name().toLowerCase();
    }

    private Skill(int i) {
        this.value = i;
    }

    public static int getInt(String i) {
        if (stringMap.get(i.toLowerCase()) != null) {
            return stringMap.get(i.toLowerCase()).getValue();
        }
        return 0;
    }

    public static String getString(int i) {
        for (Skill theEnum : Skill.values()) {
            if (theEnum.value != i) continue;
            return theEnum.name().toLowerCase();
        }
        return "none";
    }

    public static Skill getSkill(String input) {
        for (Skill theEnum : Skill.values()) {
            if (!theEnum.name().toLowerCase().equals(input.toLowerCase())) continue;
            return theEnum;
        }
        return INVALID_SKILL;
    }

    public static Skill getSkill(int input) {
        for (Skill theEnum : Skill.values()) {
            if (theEnum.value != input) continue;
            return theEnum;
        }
        return INVALID_SKILL;
    }

    public int getValue() {
        return this.value;
    }

    public ResourceLocation getResLoc() {
        return new ResourceLocation("pmmo", this.toString());
    }

    public int getLevel(PlayerEntity player) {
        if (player.field_70170_p.func_201670_d()) {
            return XP.levelAtXp(XP.getOfflineXp(this, player.func_110124_au()));
        }
        return PmmoSavedData.get().getLevel(this, player.func_110124_au());
    }

    public int getLevel(UUID uuid) {
        return PmmoSavedData.get().getLevel(this, uuid);
    }

    public double getLevelDecimal(PlayerEntity player) {
        if (player.field_70170_p.func_201670_d()) {
            return XP.levelAtXpDecimal(XP.getOfflineXp(this, player.func_110124_au()));
        }
        return PmmoSavedData.get().getLevelDecimal(this, player.func_110124_au());
    }

    public double getLevelDecimal(UUID uuid) {
        return PmmoSavedData.get().getLevelDecimal(this, uuid);
    }

    public double getXp(PlayerEntity player) {
        if (player.field_70170_p.func_201670_d()) {
            return XP.getOfflineXp(this, player.func_110124_au());
        }
        return PmmoSavedData.get().getXp(this, player.func_110124_au());
    }

    public double getXp(UUID uuid) {
        return PmmoSavedData.get().getXp(this, uuid);
    }

    public void setLevel(ServerPlayerEntity player, double amount) {
        this.setXp(player, XP.xpAtLevelDecimal(amount));
    }

    public void setXp(UUID uuid, double amount) {
        ServerPlayerEntity player = PmmoSavedData.getServer().func_184103_al().func_177451_a(uuid);
        if (player == null) {
            PmmoSavedData.get().setXp(this, uuid, amount);
        } else {
            this.setXp(player, amount);
        }
    }

    public void setXp(ServerPlayerEntity player, double amount) {
        if (PmmoSavedData.get().setXp(this, player.func_110124_au(), amount)) {
            AttributeHandler.updateAll((PlayerEntity)player);
            XP.updateRecipes(player);
            NetworkHandler.sendToPlayer(new MessageXp(amount, this.getValue(), 0.0, false), player);
        }
    }

    public void addLevel(UUID uuid, double amount, String sourceName, boolean skip, boolean ignoreBonuses) {
        double missingXp = XP.xpAtLevelDecimal(this.getLevelDecimal(uuid) + amount) - this.getXp(uuid);
        this.addXp(uuid, missingXp, sourceName, skip, ignoreBonuses);
    }

    public void addLevel(ServerPlayerEntity player, double amount, String sourceName, boolean skip, boolean ignoreBonuses) {
        double missingXp = XP.xpAtLevelDecimal(this.getLevelDecimal((PlayerEntity)player) + amount) - this.getXp((PlayerEntity)player);
        this.addXp(player, missingXp, sourceName, skip, ignoreBonuses);
    }

    public void addXp(UUID uuid, double amount, String sourceName, boolean skip, boolean ignoreBonuses) {
        ServerPlayerEntity player = PmmoSavedData.getServer().func_184103_al().func_177451_a(uuid);
        if (player == null) {
            PmmoSavedData.get().scheduleXp(this, uuid, amount, sourceName);
        } else {
            this.addXp(player, amount, sourceName, skip, ignoreBonuses);
        }
    }

    public void addXp(ServerPlayerEntity player, double amount, String sourceName, boolean skip, boolean ignoreBonuses) {
        XP.awardXp(player, this, sourceName, amount, skip, ignoreBonuses, false);
    }

    static {
        skillMap = new HashMap<Skill, Integer>();
        stringMap = new HashMap<String, Skill>();
        valuesArray = new Skill[Skill.values().length - 1];
        int i = 0;
        for (Skill skill : Skill.values()) {
            if (skill.equals((Object)INVALID_SKILL)) continue;
            skillMap.put(skill, skill.value);
            stringMap.put(skill.toString(), skill);
            Skill.valuesArray[i++] = skill;
        }
    }
}

