/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.util;

import harmonised.pmmo.config.JType;
import harmonised.pmmo.skills.Skill;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public class NBTHelper {
    public static Map<String, Double> nbtToMapString(CompoundNBT nbt) {
        HashMap<String, Double> map = new HashMap<String, Double>();
        for (String key : nbt.func_150296_c()) {
            map.put(key, nbt.func_74769_h(key));
        }
        return map;
    }

    public static Map<Skill, Double> nbtToMapSkill(CompoundNBT nbt) {
        HashMap<Skill, Double> map = new HashMap<Skill, Double>();
        for (String key : nbt.func_150296_c()) {
            if (Skill.getSkill(key) == Skill.INVALID_SKILL) continue;
            map.put(Skill.getSkill(key), nbt.func_74769_h(key));
        }
        return map;
    }

    public static CompoundNBT mapStringToNbt(Map<String, Double> map) {
        if (map == null) {
            return new CompoundNBT();
        }
        CompoundNBT nbt = new CompoundNBT();
        for (Map.Entry<String, Double> entry : map.entrySet()) {
            nbt.func_74780_a(entry.getKey(), entry.getValue().doubleValue());
        }
        return nbt;
    }

    public static CompoundNBT mapStringMapSkillToNbt(Map<String, Map<Skill, Double>> map) {
        CompoundNBT nbt = new CompoundNBT();
        for (Map.Entry<String, Map<Skill, Double>> entry : map.entrySet()) {
            nbt.func_218657_a(entry.getKey(), (INBT)NBTHelper.mapSkillToNbt(entry.getValue()));
        }
        return nbt;
    }

    public static CompoundNBT mapSkillToNbt(Map<Skill, Double> map) {
        CompoundNBT nbt = new CompoundNBT();
        for (Map.Entry<Skill, Double> entry : map.entrySet()) {
            nbt.func_74780_a(entry.getKey().toString(), entry.getValue().doubleValue());
        }
        return nbt;
    }

    public static CompoundNBT mapUuidSkillToNbt(Map<UUID, Map<Skill, Double>> inMap) {
        CompoundNBT outData = new CompoundNBT();
        for (Map.Entry<UUID, Map<Skill, Double>> entry : inMap.entrySet()) {
            outData.func_218657_a(entry.getKey().toString(), (INBT)NBTHelper.mapSkillToNbt(entry.getValue()));
        }
        return outData;
    }

    public static CompoundNBT mapUuidStringToNbt(Map<UUID, Map<String, Double>> inMap) {
        CompoundNBT outData = new CompoundNBT();
        for (Map.Entry<UUID, Map<String, Double>> entry : inMap.entrySet()) {
            outData.func_218657_a(entry.getKey().toString(), (INBT)NBTHelper.mapStringToNbt(entry.getValue()));
        }
        return outData;
    }

    public static Map<UUID, Map<String, Double>> nbtToMapUuidString(CompoundNBT inData) {
        HashMap<UUID, Map<String, Double>> outMap = new HashMap<UUID, Map<String, Double>>();
        for (String uuidKey : inData.func_150296_c()) {
            outMap.put(UUID.fromString(uuidKey), NBTHelper.nbtToMapString(inData.func_74775_l(uuidKey)));
        }
        return outMap;
    }

    public static Map<UUID, Map<Skill, Double>> nbtToMapUuidSkill(CompoundNBT inData) {
        HashMap<UUID, Map<Skill, Double>> outMap = new HashMap<UUID, Map<Skill, Double>>();
        for (String uuidKey : inData.func_150296_c()) {
            outMap.put(UUID.fromString(uuidKey), NBTHelper.nbtToMapSkill(inData.func_74775_l(uuidKey)));
        }
        return outMap;
    }

    public static Map<String, Map<Skill, Double>> nbtToMapStringSkill(CompoundNBT inData) {
        HashMap<String, Map<Skill, Double>> outMap = new HashMap<String, Map<Skill, Double>>();
        for (String key : inData.func_150296_c()) {
            outMap.put(key, NBTHelper.nbtToMapSkill(inData.func_74775_l(key)));
        }
        return outMap;
    }

    public static Map<UUID, Map<String, Map<Skill, Double>>> nbtToMapStringMapUuidSkill(CompoundNBT inData) {
        HashMap<UUID, Map<String, Map<Skill, Double>>> outMap = new HashMap<UUID, Map<String, Map<Skill, Double>>>();
        for (String playerUUIDKey : inData.func_150296_c()) {
            UUID playerUUID = UUID.fromString(playerUUIDKey);
            outMap.put(playerUUID, new HashMap());
            for (String xpBoostKey : inData.func_74775_l(playerUUIDKey).func_150296_c()) {
                ((Map)outMap.get(playerUUID)).put(xpBoostKey, NBTHelper.nbtToMapSkill(inData.func_74775_l(playerUUIDKey).func_74775_l(xpBoostKey)));
            }
        }
        return outMap;
    }

    public static CompoundNBT mapStringNbtToNbt(Map<String, CompoundNBT> inMap) {
        CompoundNBT outNbt = new CompoundNBT();
        for (Map.Entry<String, CompoundNBT> entry : inMap.entrySet()) {
            outNbt.func_218657_a(entry.getKey(), (INBT)entry.getValue());
        }
        return outNbt;
    }

    public static CompoundNBT extractNbtPlayersIndividualTagsFromPlayersTag(CompoundNBT playersTag, String element) {
        CompoundNBT outData = new CompoundNBT();
        for (String uuidKey : playersTag.func_150296_c()) {
            CompoundNBT playerTag = playersTag.func_74775_l(uuidKey);
            if (!playerTag.func_74764_b(element)) continue;
            outData.func_218657_a(uuidKey, (INBT)playerTag.func_74775_l(element));
        }
        return outData;
    }

    public static Map<JType, Map<String, Map<String, Double>>> nbtToData3(CompoundNBT input) {
        HashMap<JType, Map<String, Map<String, Double>>> output = new HashMap<JType, Map<String, Map<String, Double>>>();
        for (String jTypeKey : input.func_150296_c()) {
            JType jType = JType.getJType(jTypeKey);
            output.put(jType, new HashMap());
            for (String topKey : input.func_74775_l(jTypeKey).func_150296_c()) {
                ((Map)output.get((Object)jType)).put(topKey, new HashMap());
                for (String botKey : input.func_74775_l(jTypeKey).func_74775_l(topKey).func_150296_c()) {
                    ((Map)((Map)output.get((Object)jType)).get(topKey)).put(botKey, input.func_74775_l(jTypeKey).func_74775_l(topKey).func_74769_h(botKey));
                }
            }
        }
        return output;
    }

    public static CompoundNBT data3ToNbt(Map<JType, Map<String, Map<String, Double>>> input) {
        CompoundNBT output = new CompoundNBT();
        for (JType jType : input.keySet()) {
            output.func_218657_a(jType.toString(), (INBT)new CompoundNBT());
            for (String topKey : input.get((Object)jType).keySet()) {
                output.func_74775_l(jType.toString()).func_218657_a(topKey, (INBT)new CompoundNBT());
                for (String botKey : input.get((Object)jType).get(topKey).keySet()) {
                    Double value = input.get((Object)jType).get(topKey).get(botKey);
                    output.func_74775_l(jType.toString()).func_74775_l(topKey).func_74780_a(botKey, value.doubleValue());
                }
            }
        }
        return output;
    }

    public static void addData3(Map<JType, Map<String, Map<String, Double>>> input1, Map<JType, Map<String, Map<String, Double>>> input2) {
        for (Map.Entry<JType, Map<String, Map<String, Double>>> entry3 : input2.entrySet()) {
            if (!input1.containsKey((Object)entry3.getKey())) {
                input1.put(entry3.getKey(), new HashMap());
            }
            for (Map.Entry<String, Map<String, Double>> entry2 : entry3.getValue().entrySet()) {
                if (!input1.get((Object)entry3.getKey()).containsKey(entry2.getKey())) {
                    input1.get((Object)entry3.getKey()).put(entry2.getKey(), new HashMap());
                }
                for (Map.Entry<String, Double> entry1 : entry2.getValue().entrySet()) {
                    if (input1.get((Object)entry3.getKey()).get(entry2.getKey()).containsKey(entry1.getKey())) continue;
                    input1.get((Object)entry3.getKey()).get(entry2.getKey()).put(entry1.getKey(), entry1.getValue());
                }
            }
        }
    }

    public static Map<JType, Map<String, Map<String, Map<String, Double>>>> nbtToData4(CompoundNBT input) {
        HashMap<JType, Map<String, Map<String, Map<String, Double>>>> output = new HashMap<JType, Map<String, Map<String, Map<String, Double>>>>();
        for (String jTypeKey : input.func_150296_c()) {
            JType jType = JType.getJType(jTypeKey);
            output.put(jType, new HashMap());
            for (String topKey : input.func_74775_l(jTypeKey).func_150296_c()) {
                ((Map)output.get((Object)jType)).put(topKey, new HashMap());
                for (String midKey : input.func_74775_l(jTypeKey).func_74775_l(topKey).func_150296_c()) {
                    ((Map)((Map)output.get((Object)jType)).get(topKey)).put(midKey, new HashMap());
                    for (String botKey : input.func_74775_l(jTypeKey).func_74775_l(topKey).func_74775_l(midKey).func_150296_c()) {
                        ((Map)((Map)((Map)output.get((Object)jType)).get(topKey)).get(midKey)).put(botKey, input.func_74775_l(jTypeKey).func_74775_l(topKey).func_74775_l(midKey).func_74769_h(botKey));
                    }
                }
            }
        }
        return output;
    }

    public static CompoundNBT data4ToNbt(Map<JType, Map<String, Map<String, Map<String, Double>>>> input) {
        CompoundNBT output = new CompoundNBT();
        for (JType jType : input.keySet()) {
            output.func_218657_a(jType.toString(), (INBT)new CompoundNBT());
            for (String topKey : input.get((Object)jType).keySet()) {
                output.func_74775_l(jType.toString()).func_218657_a(topKey, (INBT)new CompoundNBT());
                for (String midKey : input.get((Object)jType).get(topKey).keySet()) {
                    output.func_74775_l(jType.toString()).func_74775_l(topKey).func_218657_a(midKey, (INBT)new CompoundNBT());
                    for (String botKey : input.get((Object)jType).get(topKey).get(midKey).keySet()) {
                        Double value = input.get((Object)jType).get(topKey).get(midKey).get(botKey);
                        output.func_74775_l(jType.toString()).func_74775_l(topKey).func_74775_l(midKey).func_74780_a(botKey, value.doubleValue());
                    }
                }
            }
        }
        return output;
    }

    public static void addData4(Map<JType, Map<String, Map<String, Map<String, Double>>>> input1, Map<JType, Map<String, Map<String, Map<String, Double>>>> input2) {
        for (Map.Entry<JType, Map<String, Map<String, Map<String, Double>>>> entry4 : input2.entrySet()) {
            if (!input1.containsKey((Object)entry4.getKey())) {
                input1.put(entry4.getKey(), new HashMap());
            }
            for (Map.Entry<String, Map<String, Map<String, Double>>> entry3 : entry4.getValue().entrySet()) {
                if (!input1.get((Object)entry4.getKey()).containsKey(entry3.getKey())) {
                    input1.get((Object)entry4.getKey()).put(entry3.getKey(), new HashMap());
                }
                for (Map.Entry<String, Map<String, Double>> entry2 : entry3.getValue().entrySet()) {
                    if (input1.get((Object)entry4.getKey()).get(entry3.getKey()).containsKey(entry2.getKey())) continue;
                    input1.get((Object)entry4.getKey()).get(entry3.getKey()).put(entry2.getKey(), entry2.getValue());
                }
            }
        }
    }
}

