/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.util;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.config.JsonConfig;
import harmonised.pmmo.events.PlayerConnectedHandler;
import harmonised.pmmo.network.MessageUpdateBoolean;
import harmonised.pmmo.network.MessageUpdatePlayerNBT;
import harmonised.pmmo.network.MessageXp;
import harmonised.pmmo.network.NetworkHandler;
import harmonised.pmmo.party.Party;
import harmonised.pmmo.pmmo_saved_data.PmmoSavedData;
import harmonised.pmmo.skills.AttributeHandler;
import harmonised.pmmo.skills.PMMOFireworkEntity;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.DP;
import harmonised.pmmo.util.NBTHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class XP {
    public static final Logger LOGGER = LogManager.getLogger();
    private static Map<Material, String> materialHarvestTool = new HashMap<Material, String>();
    private static Map<Skill, Integer> skillColors = new HashMap<Skill, Integer>();
    public static Set<UUID> isVeining = new HashSet<UUID>();
    public static Map<Skill, Style> skillStyle = new HashMap<Skill, Style>();
    public static Map<String, Style> textStyle = new HashMap<String, Style>();
    public static Map<UUID, String> playerNames = new HashMap<UUID, String>();
    public static Map<UUID, Map<Skill, Double>> offlineXp = new HashMap<UUID, Map<Skill, Double>>();
    private static Map<UUID, String> lastBiome = new HashMap<UUID, String>();
    private static int debugInt = 0;

    public static void initValues() {
        skillColors.put(Skill.MINING, 65535);
        skillColors.put(Skill.BUILDING, 65535);
        skillColors.put(Skill.EXCAVATION, 15112448);
        skillColors.put(Skill.WOODCUTTING, 16753434);
        skillColors.put(Skill.FARMING, 58880);
        skillColors.put(Skill.AGILITY, 0x66CC66);
        skillColors.put(Skill.ENDURANCE, 0xCC0000);
        skillColors.put(Skill.COMBAT, 0xFF3300);
        skillColors.put(Skill.ARCHERY, 0xFFFF00);
        skillColors.put(Skill.SMITHING, 0xF0F0F0);
        skillColors.put(Skill.FLYING, 0xCCCCFF);
        skillColors.put(Skill.SWIMMING, 0x3366FF);
        skillColors.put(Skill.FISHING, 52479);
        skillColors.put(Skill.CRAFTING, 0xFF9900);
        skillColors.put(Skill.MAGIC, 255);
        skillColors.put(Skill.SLAYER, 0xFFFFFF);
        skillColors.put(Skill.HUNTER, 13596693);
        skillColors.put(Skill.FLETCHING, 16750336);
        skillColors.put(Skill.TAMING, 0xFFFFFF);
        skillColors.put(Skill.ENGINEERING, 0xFFFFFF);
        skillColors.put(Skill.COOKING, 15112448);
        skillColors.put(Skill.ALCHEMY, 15112448);
        skillStyle.put(Skill.MINING, new Style().func_150238_a(TextFormatting.AQUA));
        skillStyle.put(Skill.BUILDING, new Style().func_150238_a(TextFormatting.AQUA));
        skillStyle.put(Skill.EXCAVATION, new Style().func_150238_a(TextFormatting.GOLD));
        skillStyle.put(Skill.WOODCUTTING, new Style().func_150238_a(TextFormatting.GOLD));
        skillStyle.put(Skill.FARMING, new Style().func_150238_a(TextFormatting.GREEN));
        skillStyle.put(Skill.AGILITY, new Style().func_150238_a(TextFormatting.GREEN));
        skillStyle.put(Skill.ENDURANCE, new Style().func_150238_a(TextFormatting.DARK_RED));
        skillStyle.put(Skill.COMBAT, new Style().func_150238_a(TextFormatting.RED));
        skillStyle.put(Skill.ARCHERY, new Style().func_150238_a(TextFormatting.YELLOW));
        skillStyle.put(Skill.SMITHING, new Style().func_150238_a(TextFormatting.GRAY));
        skillStyle.put(Skill.FLYING, new Style().func_150238_a(TextFormatting.GRAY));
        skillStyle.put(Skill.SWIMMING, new Style().func_150238_a(TextFormatting.AQUA));
        skillStyle.put(Skill.FISHING, new Style().func_150238_a(TextFormatting.AQUA));
        skillStyle.put(Skill.CRAFTING, new Style().func_150238_a(TextFormatting.GOLD));
        skillStyle.put(Skill.MAGIC, new Style().func_150238_a(TextFormatting.BLUE));
        skillStyle.put(Skill.SLAYER, new Style().func_150238_a(TextFormatting.GRAY));
        skillStyle.put(Skill.HUNTER, new Style().func_150238_a(TextFormatting.GOLD));
        skillStyle.put(Skill.FLETCHING, new Style().func_150238_a(TextFormatting.DARK_GREEN));
        skillStyle.put(Skill.TAMING, new Style().func_150238_a(TextFormatting.WHITE));
        skillStyle.put(Skill.ENGINEERING, new Style().func_150238_a(TextFormatting.WHITE));
        skillStyle.put(Skill.COOKING, new Style().func_150238_a(TextFormatting.GOLD));
        skillStyle.put(Skill.ALCHEMY, new Style().func_150238_a(TextFormatting.GOLD));
        textStyle.put("red", new Style().func_150238_a(TextFormatting.RED));
        textStyle.put("green", new Style().func_150238_a(TextFormatting.GREEN));
        textStyle.put("dark_green", new Style().func_150238_a(TextFormatting.DARK_GREEN));
        textStyle.put("yellow", new Style().func_150238_a(TextFormatting.YELLOW));
        textStyle.put("grey", new Style().func_150238_a(TextFormatting.GRAY));
        textStyle.put("cyan", new Style().func_150238_a(TextFormatting.AQUA));
        textStyle.put("blue", new Style().func_150238_a(TextFormatting.BLUE));
        textStyle.put("dark_blue", new Style().func_150238_a(TextFormatting.DARK_BLUE));
        textStyle.put("pink", new Style().func_150238_a(TextFormatting.LIGHT_PURPLE));
        textStyle.put("dark_purple", new Style().func_150238_a(TextFormatting.DARK_PURPLE));
        PlayerConnectedHandler.lapisPatreons.add(UUID.fromString("e4c7e475-c1ff-4f94-956c-ac5be02ce04a"));
        PlayerConnectedHandler.dandelionPatreons.add(UUID.fromString("8eb0578d-c113-49d3-abf6-a6d36f6d1116"));
        PlayerConnectedHandler.dandelionPatreons.add(UUID.fromString("554b53b8-d0fa-409e-ab87-2a34bf83e506"));
        PlayerConnectedHandler.ironPatreons.add(UUID.fromString("2ea5efa1-756b-4c9e-9605-7f53830d6cfa"));
        PlayerConnectedHandler.ironPatreons.add(UUID.fromString("0bc51f06-9906-41ea-9fb4-7e9be169c980"));
        PlayerConnectedHandler.ironPatreons.add(UUID.fromString("5bfdb948-7b66-476a-aefe-d45e4778fb2d"));
        materialHarvestTool.put(Material.field_151574_g, "pickaxe");
        materialHarvestTool.put(Material.field_151592_s, "pickaxe");
        materialHarvestTool.put(Material.field_151588_w, "pickaxe");
        materialHarvestTool.put(Material.field_151573_f, "pickaxe");
        materialHarvestTool.put(Material.field_151598_x, "pickaxe");
        materialHarvestTool.put(Material.field_76233_E, "pickaxe");
        materialHarvestTool.put(Material.field_151591_t, "pickaxe");
        materialHarvestTool.put(Material.field_151576_e, "pickaxe");
        materialHarvestTool.put(Material.field_215711_w, "pickaxe");
        materialHarvestTool.put(Material.field_175972_I, "pickaxe");
        materialHarvestTool.put(Material.field_151594_q, "pickaxe");
        materialHarvestTool.put(Material.field_151575_d, "axe");
        materialHarvestTool.put(Material.field_151584_j, "axe");
        materialHarvestTool.put(Material.field_151572_C, "axe");
        materialHarvestTool.put(Material.field_151571_B, "shovel");
        materialHarvestTool.put(Material.field_151578_c, "shovel");
        materialHarvestTool.put(Material.field_151595_p, "shovel");
        materialHarvestTool.put(Material.field_151597_y, "shovel");
        materialHarvestTool.put(Material.field_204868_h, "shovel");
        materialHarvestTool.put(Material.field_151596_z, "shovel");
        materialHarvestTool.put(Material.field_151585_k, "hoe");
        materialHarvestTool.put(Material.field_203243_f, "hoe");
        materialHarvestTool.put(Material.field_151570_A, "hoe");
        materialHarvestTool.put(Material.field_151589_v, "hoe");
        materialHarvestTool.put(Material.field_151582_l, "hoe");
        materialHarvestTool.put(Material.field_215713_z, "hoe");
        materialHarvestTool.put(Material.field_215712_y, "hoe");
        materialHarvestTool.put(Material.field_151577_b, "hoe");
        materialHarvestTool.put(Material.field_151580_n, "shears");
        materialHarvestTool.put(Material.field_151593_r, "shears");
        materialHarvestTool.put(Material.field_151590_u, "shears");
        materialHarvestTool.put(Material.field_151566_D, "shears");
        materialHarvestTool.put(Material.field_151569_G, "shears");
        materialHarvestTool.put(Material.field_151568_F, "shears");
        materialHarvestTool.put(Material.field_151583_m, "shears");
    }

    public static Style getSkillStyle(Skill skill) {
        return skillStyle.getOrDefault((Object)skill, new Style());
    }

    public static Skill getSkill(Material material) {
        return XP.getSkillFromTool(XP.correctHarvestTool(material));
    }

    public static Skill getSkill(BlockState state) {
        return XP.getSkill(state.func_185904_a());
    }

    public static Skill getSkillFromTool(String tool) {
        if (tool == null) {
            return Skill.INVALID_SKILL;
        }
        switch (tool) {
            case "pickaxe": {
                return Skill.MINING;
            }
            case "shovel": {
                return Skill.EXCAVATION;
            }
            case "axe": {
                return Skill.WOODCUTTING;
            }
            case "hoe": {
                return Skill.FARMING;
            }
            case "shears": {
                return Skill.CRAFTING;
            }
        }
        return Skill.INVALID_SKILL;
    }

    public static Map<String, Double> getXp(String registryName, JType jType) {
        return XP.getXp(new ResourceLocation(registryName), jType);
    }

    public static Map<String, Double> getXp(ResourceLocation registryName, JType jType) {
        HashMap<String, Double> theMap = new HashMap<String, Double>();
        if (JsonConfig.data.get((Object)jType).containsKey(registryName.toString())) {
            for (Map.Entry<String, Double> entry : JsonConfig.data.get((Object)jType).get(registryName.toString()).entrySet()) {
                if (!(entry.getValue() instanceof Double)) continue;
                theMap.put(entry.getKey(), (double)entry.getValue());
            }
        }
        return theMap;
    }

    public static Integer getSkillColor(Skill skill) {
        return skillColors.getOrDefault((Object)skill, 0xFFFFFF);
    }

    public static String correctHarvestTool(Material material) {
        if (material == null) {
            return "none";
        }
        if (materialHarvestTool.get(material) != null) {
            return materialHarvestTool.get(material);
        }
        return "none";
    }

    public static String checkMaterial(Material material) {
        if (material.equals(Material.field_151579_a)) {
            return "AIR";
        }
        if (material.equals(Material.field_189963_J)) {
            return "STRUCTURE_VOID";
        }
        if (material.equals(Material.field_151567_E)) {
            return "PORTAL";
        }
        if (material.equals(Material.field_151593_r)) {
            return "CARPET";
        }
        if (material.equals(Material.field_151585_k)) {
            return "PLANTS";
        }
        if (material.equals(Material.field_203243_f)) {
            return "OCEAN_PLANT";
        }
        if (material.equals(Material.field_151582_l)) {
            return "TALL_PLANTS";
        }
        if (material.equals(Material.field_204868_h)) {
            return "SEA_GRASS";
        }
        if (material.equals(Material.field_151586_h)) {
            return "WATER";
        }
        if (material.equals(Material.field_203244_i)) {
            return "BUBBLE_COLUMN";
        }
        if (material.equals(Material.field_151587_i)) {
            return "LAVA";
        }
        if (material.equals(Material.field_151597_y)) {
            return "SNOW";
        }
        if (material.equals(Material.field_151581_o)) {
            return "FIRE";
        }
        if (material.equals(Material.field_151594_q)) {
            return "MISCELLANEOUS";
        }
        if (material.equals(Material.field_151569_G)) {
            return "WEB";
        }
        if (material.equals(Material.field_151591_t)) {
            return "REDSTONE_LIGHT";
        }
        if (material.equals(Material.field_151571_B)) {
            return "CLAY";
        }
        if (material.equals(Material.field_151578_c)) {
            return "EARTH";
        }
        if (material.equals(Material.field_151577_b)) {
            return "ORGANIC";
        }
        if (material.equals(Material.field_151598_x)) {
            return "PACKED_ICE";
        }
        if (material.equals(Material.field_151595_p)) {
            return "SAND";
        }
        if (material.equals(Material.field_151583_m)) {
            return "SPONGE";
        }
        if (material.equals(Material.field_215711_w)) {
            return "SHULKER";
        }
        if (material.equals(Material.field_151575_d)) {
            return "WOOD";
        }
        if (material.equals(Material.field_215712_y)) {
            return "BAMBOO_SAPLING";
        }
        if (material.equals(Material.field_215713_z)) {
            return "BAMBOO";
        }
        if (material.equals(Material.field_151580_n)) {
            return "WOOL";
        }
        if (material.equals(Material.field_151590_u)) {
            return "TNT";
        }
        if (material.equals(Material.field_151584_j)) {
            return "LEAVES";
        }
        if (material.equals(Material.field_151592_s)) {
            return "GLASS";
        }
        if (material.equals(Material.field_151588_w)) {
            return "ICE";
        }
        if (material.equals(Material.field_151570_A)) {
            return "CACTUS";
        }
        if (material.equals(Material.field_151576_e)) {
            return "ROCK";
        }
        if (material.equals(Material.field_151573_f)) {
            return "IRON";
        }
        if (material.equals(Material.field_151596_z)) {
            return "SNOW_BLOCK";
        }
        if (material.equals(Material.field_151574_g)) {
            return "ANVIL";
        }
        if (material.equals(Material.field_175972_I)) {
            return "BARRIER";
        }
        if (material.equals(Material.field_76233_E)) {
            return "PISTON";
        }
        if (material.equals(Material.field_151589_v)) {
            return "CORAL";
        }
        if (material.equals(Material.field_151572_C)) {
            return "GOURD";
        }
        if (material.equals(Material.field_151566_D)) {
            return "DRAGON_EGG";
        }
        if (material.equals(Material.field_151568_F)) {
            return "CAKE";
        }
        return "UNKNOWN";
    }

    public static void sendMessage(String msg, boolean bar, PlayerEntity player) {
        player.func_146105_b((ITextComponent)new StringTextComponent(msg), bar);
    }

    public static void sendMessage(String msg, boolean bar, PlayerEntity player, TextFormatting format) {
        player.func_146105_b(new StringTextComponent(msg).func_150255_a(new Style().func_150238_a(format)), bar);
    }

    public static Map<String, Double> multiplyMap(Map<String, Double> mapOne, double multiplier) {
        for (String key : mapOne.keySet()) {
            mapOne.replace(key, mapOne.get(key) * multiplier);
        }
        return mapOne;
    }

    public static Map<String, Double> addMaps(Map<String, Double> mapOne, Map<String, Double> mapTwo) {
        for (String key : mapTwo.keySet()) {
            if (mapOne.containsKey(key)) {
                mapOne.replace(key, mapOne.get(key) + mapTwo.get(key));
                continue;
            }
            mapOne.put(key, mapTwo.get(key));
        }
        return mapOne;
    }

    private static int doubleObjectToInt(Object object) {
        return (int)Math.floor((Double)object);
    }

    public static double getExtraChance(UUID uuid, String resLoc, JType jType, boolean offline) {
        return XP.getExtraChance(uuid, XP.getResLoc(resLoc), jType, offline);
    }

    public static double getExtraChance(UUID uuid, ResourceLocation resLoc, JType jType, boolean offline) {
        double extraChance;
        int startLevel;
        Skill skill;
        String regKey = resLoc.toString();
        double extraChancePerLevel = 0.0;
        int highestReq = 1;
        if (JsonConfig.data.get((Object)JType.REQ_BREAK).containsKey(resLoc.toString())) {
            highestReq = JsonConfig.data.get((Object)JType.REQ_BREAK).get(resLoc.toString()).entrySet().stream().map(a -> XP.doubleObjectToInt(a.getValue())).reduce(0, Math::max);
        }
        switch (jType) {
            case INFO_ORE: {
                skill = Skill.MINING;
                break;
            }
            case INFO_LOG: {
                skill = Skill.WOODCUTTING;
                break;
            }
            case INFO_PLANT: {
                skill = Skill.FARMING;
                break;
            }
            case INFO_SMELT: {
                skill = Skill.SMITHING;
                break;
            }
            case INFO_COOK: {
                skill = Skill.COOKING;
                break;
            }
            case INFO_BREW: {
                skill = Skill.ALCHEMY;
                break;
            }
            default: {
                LOGGER.error("WRONG getExtraChance CHANCE TYPE! PLEASE REPORT!");
                return 0.0;
            }
        }
        int n = startLevel = offline ? XP.getOfflineLevel(skill, uuid) : skill.getLevel(uuid);
        if (JsonConfig.data.get((Object)jType).containsKey(regKey) && JsonConfig.data.get((Object)jType).get(regKey).containsKey("extraChance")) {
            extraChancePerLevel = JsonConfig.data.get((Object)jType).get(regKey).get("extraChance");
        }
        if ((extraChance = (double)(startLevel - highestReq) * extraChancePerLevel) < 0.0) {
            extraChance = 0.0;
        }
        return extraChance;
    }

    public static boolean hasElement(ResourceLocation key, JType jType) {
        return XP.hasElement(key.toString(), jType);
    }

    public static boolean hasElement(String key, JType jType) {
        return JsonConfig.data.get((Object)jType).containsKey(key);
    }

    public static boolean rollChance(double extraChance) {
        return Math.random() < extraChance;
    }

    public static void dropItems(int dropsLeft, Item item, World world, BlockPos pos) {
        if (dropsLeft > 0) {
            while (dropsLeft > 64) {
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)item, 64));
                dropsLeft -= 64;
            }
            Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)item, dropsLeft));
        }
    }

    public static void dropItemStack(ItemStack itemStack, World world, Vec3d pos) {
        XP.dropItemStack(itemStack, world, new BlockPos(pos));
    }

    public static void dropItemStack(ItemStack itemStack, World world, BlockPos pos) {
        Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)itemStack);
    }

    public static boolean isPlayerSurvival(PlayerEntity player) {
        return !player.func_184812_l_() && !player.func_175149_v();
    }

    public static Collection<PlayerEntity> getNearbyPlayers(Entity mob) {
        World world = mob.func_130014_f_();
        List allPlayers = world.func_217369_A();
        ArrayList<PlayerEntity> nearbyPlayers = new ArrayList<PlayerEntity>();
        Float closestDistance = null;
        for (PlayerEntity player : allPlayers) {
            float tempDistance = mob.func_70032_d((Entity)player);
            if (closestDistance != null && !(tempDistance < closestDistance.floatValue())) continue;
            closestDistance = Float.valueOf(tempDistance);
        }
        if (closestDistance != null) {
            float searchRange = closestDistance.floatValue() + 30.0f;
            for (PlayerEntity player : allPlayers) {
                if (!(mob.func_70032_d((Entity)player) < searchRange)) continue;
                nearbyPlayers.add(player);
            }
        }
        return nearbyPlayers;
    }

    public static float getPowerLevel(UUID uuid) {
        int enduranceLevel = Skill.ENDURANCE.getLevel(uuid);
        int combatLevel = Skill.COMBAT.getLevel(uuid);
        int archeryLevel = Skill.ARCHERY.getLevel(uuid);
        int magicLevel = Skill.MAGIC.getLevel(uuid);
        int maxOffensive = combatLevel;
        if (maxOffensive < archeryLevel) {
            maxOffensive = archeryLevel;
        }
        if (maxOffensive < magicLevel) {
            maxOffensive = magicLevel;
        }
        return ((float)enduranceLevel + (float)maxOffensive * 1.5f) / 50.0f;
    }

    public static ServerPlayerEntity getPlayerByUUID(UUID uuid) {
        return XP.getPlayerByUUID(uuid, PmmoSavedData.getServer());
    }

    public static ServerPlayerEntity getPlayerByUUID(UUID uuid, MinecraftServer server) {
        ServerPlayerEntity matchedPlayer = null;
        for (ServerPlayerEntity player : server.func_184103_al().func_181057_v()) {
            if (!player.func_110124_au().equals(uuid)) continue;
            matchedPlayer = player;
            break;
        }
        return matchedPlayer;
    }

    public static double getDistance(Vec3d a, Vec3d b) {
        return Math.sqrt(Math.pow(a.func_82615_a() - b.func_82615_a(), 2.0) + Math.pow(a.func_82617_b() - b.func_82617_b(), 2.0) + Math.pow(a.func_82616_c() - b.func_82616_c(), 2.0));
    }

    public static <T extends Entity> Set<T> getEntitiesInRange(Vec3d origin, Set<T> entities, double range) {
        HashSet<Entity> withinRange = new HashSet<Entity>();
        for (Entity entity : entities) {
            Vec3d pos = entity.func_213303_ch();
            double distance = XP.getDistance(origin, pos);
            if (!(distance <= range)) continue;
            withinRange.add(entity);
        }
        return withinRange;
    }

    public static void syncPlayerDataAndConfig(PlayerEntity player) {
        XP.syncPlayerData3(player);
        XP.syncPlayerData4(player);
        XP.syncPlayerXpBoost(player);
        NetworkHandler.sendToPlayer(new MessageUpdateBoolean(true, 1), (ServerPlayerEntity)player);
        NetworkHandler.sendToPlayer(new MessageUpdatePlayerNBT(NBTHelper.mapStringToNbt(Config.localConfig), 2), (ServerPlayerEntity)player);
    }

    public static void syncPlayerXpBoost(PlayerEntity player) {
        NetworkHandler.sendToPlayer(new MessageUpdatePlayerNBT(NBTHelper.mapStringMapSkillToNbt(Config.getXpBoostsMap(player)), 6), (ServerPlayerEntity)player);
    }

    public static void syncPlayerData3(PlayerEntity player) {
        CompoundNBT fullData = NBTHelper.data3ToNbt(JsonConfig.localData);
        CompoundNBT dataChunk = new CompoundNBT();
        dataChunk.func_74757_a("wipe", true);
        NetworkHandler.sendToPlayer(new MessageUpdatePlayerNBT(dataChunk, 4), (ServerPlayerEntity)player);
        dataChunk = new CompoundNBT();
        int i = 0;
        for (String key3 : fullData.func_150296_c()) {
            if (!dataChunk.func_74764_b(key3)) {
                dataChunk.func_218657_a(key3, (INBT)new CompoundNBT());
            }
            for (String key2 : fullData.func_74775_l(key3).func_150296_c()) {
                if (i >= 1000) {
                    i = 0;
                    NetworkHandler.sendToPlayer(new MessageUpdatePlayerNBT(dataChunk, 4), (ServerPlayerEntity)player);
                    dataChunk = new CompoundNBT();
                    dataChunk.func_218657_a(key3, (INBT)new CompoundNBT());
                }
                dataChunk.func_74775_l(key3).func_218657_a(key2, (INBT)fullData.func_74775_l(key3).func_74775_l(key2));
                ++i;
            }
        }
        NetworkHandler.sendToPlayer(new MessageUpdatePlayerNBT(dataChunk, 4), (ServerPlayerEntity)player);
    }

    public static void syncPlayerData4(PlayerEntity player) {
        CompoundNBT fullData = NBTHelper.data4ToNbt(JsonConfig.localData2);
        CompoundNBT dataChunk = new CompoundNBT();
        dataChunk.func_74757_a("wipe", true);
        NetworkHandler.sendToPlayer(new MessageUpdatePlayerNBT(dataChunk, 5), (ServerPlayerEntity)player);
        dataChunk = new CompoundNBT();
        int i = 0;
        for (String key4 : fullData.func_150296_c()) {
            if (!dataChunk.func_74764_b(key4)) {
                dataChunk.func_218657_a(key4, (INBT)new CompoundNBT());
            }
            for (String key3 : fullData.func_74775_l(key4).func_150296_c()) {
                if (!dataChunk.func_74775_l(key4).func_74764_b(key3)) {
                    dataChunk.func_74775_l(key4).func_218657_a(key3, (INBT)new CompoundNBT());
                }
                for (String key2 : fullData.func_74775_l(key4).func_74775_l(key3).func_150296_c()) {
                    if (i >= 1000) {
                        i = 0;
                        NetworkHandler.sendToPlayer(new MessageUpdatePlayerNBT(dataChunk, 5), (ServerPlayerEntity)player);
                        dataChunk = new CompoundNBT();
                        dataChunk.func_218657_a(key4, (INBT)new CompoundNBT());
                        dataChunk.func_74775_l(key4).func_218657_a(key3, (INBT)new CompoundNBT());
                    }
                    dataChunk.func_74775_l(key4).func_74775_l(key3).func_218657_a(key2, (INBT)fullData.func_74775_l(key4).func_74775_l(key3).func_74775_l(key2));
                    ++i;
                }
            }
        }
        NetworkHandler.sendToPlayer(new MessageUpdatePlayerNBT(dataChunk, 5), (ServerPlayerEntity)player);
    }

    public static void syncPlayer(PlayerEntity player) {
        CompoundNBT prefsTag = NBTHelper.mapStringToNbt(Config.getPreferencesMap(player));
        CompoundNBT abilitiesTag = NBTHelper.mapStringToNbt(Config.getAbilitiesMap(player));
        XP.syncPlayerDataAndConfig(player);
        XP.syncPlayerXpBoost(player);
        XP.updateRecipes((ServerPlayerEntity)player);
        NetworkHandler.sendToPlayer(new MessageXp(0.0, 42069, 0.0, true), (ServerPlayerEntity)player);
        NetworkHandler.sendToPlayer(new MessageUpdatePlayerNBT(prefsTag, 0), (ServerPlayerEntity)player);
        NetworkHandler.sendToPlayer(new MessageUpdatePlayerNBT(abilitiesTag, 1), (ServerPlayerEntity)player);
        AttributeHandler.updateAll(player);
        for (Map.Entry<Skill, Double> entry : Config.getXpMap(player).entrySet()) {
            NetworkHandler.sendToPlayer(new MessageXp(entry.getValue(), entry.getKey().getValue(), 0.0, true), (ServerPlayerEntity)player);
        }
    }

    public static boolean checkReq(PlayerEntity player, String res, JType jType) {
        return XP.checkReq(player, XP.getResLoc(res), jType);
    }

    public static ResourceLocation getResLoc(String regKey) {
        try {
            return new ResourceLocation(regKey.replaceAll(" ", "").trim());
        }
        catch (Exception e) {
            return new ResourceLocation("");
        }
    }

    public static ResourceLocation getResLoc(String firstPart, String secondPart) {
        try {
            return new ResourceLocation(firstPart, secondPart);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Map<String, Double> getReqMap(String registryName, JType type) {
        Map<String, Map<String, Double>> fullMap = JsonConfig.data.get((Object)type);
        HashMap<String, Double> map = null;
        if (fullMap != null && fullMap.containsKey(registryName)) {
            map = new HashMap<String, Double>();
            for (Map.Entry<String, Double> entry : fullMap.get(registryName).entrySet()) {
                map.put(entry.getKey(), entry.getValue());
            }
        }
        return map;
    }

    public static boolean checkReq(PlayerEntity player, ResourceLocation res, JType jType) {
        boolean failedReq = false;
        try {
            if (res == null) {
                return true;
            }
            if (res.equals((Object)Items.field_190931_a.getRegistryName()) || player.func_184812_l_()) {
                return true;
            }
            if (JsonConfig.data.get((Object)JType.PLAYER_SPECIFIC).containsKey(player.func_110124_au().toString()) && JsonConfig.data.get((Object)JType.PLAYER_SPECIFIC).get(player.func_110124_au().toString()).containsKey("ignoreReq")) {
                return true;
            }
            String registryName = res.toString();
            Map<String, Double> reqMap = XP.getReqMap(registryName, jType);
            if (reqMap != null) {
                for (Map.Entry<String, Double> entry : reqMap.entrySet()) {
                    double startLevel = Skill.getSkill(entry.getKey()).getLevel(player);
                    if (!(startLevel < entry.getValue())) continue;
                    failedReq = true;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
        }
        return !failedReq;
    }

    public static int getHighestReq(String regKey, JType jType) {
        int highestReq = 1;
        Map<String, Double> map = XP.getReqMap(regKey, jType);
        if (map != null) {
            for (Map.Entry<String, Double> entry : map.entrySet()) {
                if (!((double)highestReq < entry.getValue())) continue;
                highestReq = (int)entry.getValue().doubleValue();
            }
        }
        return highestReq;
    }

    public static Item getItem(String regKey) {
        ResourceLocation resLoc = XP.getResLoc(regKey);
        Item item = (Item)ForgeRegistries.ITEMS.getValue(resLoc);
        if (item != null && !item.equals(Items.field_190931_a)) {
            return item;
        }
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(resLoc);
        if (block != null) {
            return block.func_199767_j();
        }
        return Items.field_190931_a;
    }

    public static Item getItem(ResourceLocation resLoc) {
        return (Item)ForgeRegistries.ITEMS.getValue(resLoc);
    }

    public static boolean scanBlock(Block block, int radius, PlayerEntity player) {
        BlockPos playerPos = XP.vecToBlock(player.func_213303_ch());
        boolean matched = false;
        for (int x = -radius; x <= radius; ++x) {
            block1: for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    Block currBlock = player.field_70170_p.func_180495_p(new BlockPos(playerPos.func_177958_n() + x, playerPos.func_177956_o() + y, playerPos.func_177952_p() + z)).func_177230_c();
                    if (!currBlock.equals(block)) continue;
                    matched = true;
                    continue block1;
                }
            }
        }
        return matched;
    }

    public static double getWornXpBoost(PlayerEntity player, Item item, String skillName) {
        double boost = 0.0;
        if (!item.equals(Items.field_190931_a)) {
            String regName = item.getRegistryName().toString();
            Map<String, Double> itemXpMap = JsonConfig.data.get((Object)JType.XP_BONUS_WORN).get(regName);
            if (itemXpMap != null && itemXpMap.containsKey(skillName) && XP.checkReq(player, item.getRegistryName(), JType.REQ_WEAR)) {
                boost = itemXpMap.get(skillName);
            }
        }
        return boost;
    }

    public static double getGlobalMultiplier(Skill skill) {
        return ((Map)JsonConfig.data.get((Object)JType.XP_MULTIPLIER_DIMENSION).getOrDefault("all_dimensions", new HashMap())).getOrDefault(skill.toString(), 1.0);
    }

    public static double getDimensionMultiplier(Skill skill, PlayerEntity player) {
        try {
            String dimensionKey = player.field_70170_p.func_201675_m().func_186058_p().getRegistryName().toString();
            return ((Map)JsonConfig.data.get((Object)JType.XP_MULTIPLIER_DIMENSION).getOrDefault(dimensionKey, new HashMap())).getOrDefault(skill.toString(), 1.0);
        }
        catch (Exception e) {
            return 1.0;
        }
    }

    public static double getDifficultyMultiplier(PlayerEntity player, Skill skill) {
        double difficultyMultiplier = 1.0;
        if (skill == Skill.COMBAT || skill == Skill.ARCHERY || skill == Skill.ENDURANCE) {
            switch (player.field_70170_p.func_175659_aa()) {
                case PEACEFUL: {
                    difficultyMultiplier = Config.forgeConfig.peacefulMultiplier.get();
                    break;
                }
                case EASY: {
                    difficultyMultiplier = Config.forgeConfig.easyMultiplier.get();
                    break;
                }
                case NORMAL: {
                    difficultyMultiplier = Config.forgeConfig.normalMultiplier.get();
                    break;
                }
                case HARD: {
                    difficultyMultiplier = Config.forgeConfig.hardMultiplier.get();
                    break;
                }
            }
        }
        return difficultyMultiplier;
    }

    public static double getItemBoost(PlayerEntity player, Skill skill) {
        if (player.func_184614_ca().func_77973_b().getRegistryName() == null) {
            return 0.0;
        }
        double itemBoost = 0.0;
        String skillName = skill.toString().toLowerCase();
        String regKey = player.func_184614_ca().func_77973_b().getRegistryName().toString();
        Map<String, Double> heldMap = JsonConfig.data.get((Object)JType.XP_BONUS_HELD).get(regKey);
        PlayerInventory inv = player.field_71071_by;
        if (heldMap != null && heldMap.containsKey(skillName)) {
            heldMap.get(skillName);
        }
        if (!inv.func_70301_a(39).func_190926_b()) {
            itemBoost += XP.getWornXpBoost(player, player.field_71071_by.func_70301_a(39).func_77973_b(), skillName);
        }
        if (!inv.func_70301_a(38).func_190926_b()) {
            itemBoost += XP.getWornXpBoost(player, player.field_71071_by.func_70301_a(38).func_77973_b(), skillName);
        }
        if (!inv.func_70301_a(37).func_190926_b()) {
            itemBoost += XP.getWornXpBoost(player, player.field_71071_by.func_70301_a(37).func_77973_b(), skillName);
        }
        if (!inv.func_70301_a(36).func_190926_b()) {
            itemBoost += XP.getWornXpBoost(player, player.field_71071_by.func_70301_a(36).func_77973_b(), skillName);
        }
        if (!inv.func_70301_a(40).func_190926_b()) {
            itemBoost += XP.getWornXpBoost(player, player.field_71071_by.func_70301_a(40).func_77973_b(), skillName);
        }
        return itemBoost;
    }

    public static double getDimensionBoost(PlayerEntity player, Skill skill) {
        String dimensionKey = player.field_70170_p.func_201675_m().func_186058_p().getRegistryName().toString();
        return ((Map)JsonConfig.data.get((Object)JType.XP_BONUS_DIMENSION).getOrDefault(dimensionKey, new HashMap())).getOrDefault(skill.toString(), 0.0);
    }

    public static double getGlobalBoost(Skill skill) {
        return ((Map)JsonConfig.data.get((Object)JType.XP_BONUS_DIMENSION).getOrDefault("all_dimensions", new HashMap())).getOrDefault(skill.toString(), 0.0);
    }

    public static CompoundNBT writeUniqueId(UUID uuid) {
        CompoundNBT compoundnbt = new CompoundNBT();
        compoundnbt.func_74772_a("M", uuid.getMostSignificantBits());
        compoundnbt.func_74772_a("L", uuid.getLeastSignificantBits());
        return compoundnbt;
    }

    public static double getBiomeBoost(PlayerEntity player, Skill skill) {
        double biomeBoost = 0.0;
        double theBiomeBoost = 0.0;
        double biomePenaltyMultiplier = Config.getConfig("biomePenaltyMultiplier");
        String skillName = skill.toString().toLowerCase();
        Biome biome = player.field_70170_p.func_226691_t_(XP.vecToBlock(player.func_213303_ch()));
        ResourceLocation resLoc = biome.getRegistryName();
        if (resLoc == null) {
            return 0.0;
        }
        String biomeKey = resLoc.toString();
        Map<String, Double> biomeMap = JsonConfig.data.get((Object)JType.XP_BONUS_BIOME).get(biomeKey);
        if (biomeMap != null && biomeMap.containsKey(skillName)) {
            theBiomeBoost = biomeMap.get(skillName);
        }
        biomeBoost = XP.checkReq(player, resLoc, JType.REQ_BIOME) ? theBiomeBoost : Math.min(theBiomeBoost, -biomePenaltyMultiplier * 100.0);
        return biomeBoost;
    }

    public static double getMultiplier(PlayerEntity player, Skill skill) {
        double multiplier = Config.forgeConfig.globalMultiplier.get();
        double globalMultiplier = XP.getGlobalMultiplier(skill);
        double dimensionMultiplier = XP.getDimensionMultiplier(skill, player);
        double difficultyMultiplier = XP.getDifficultyMultiplier(player, skill);
        double globalBoost = XP.getGlobalBoost(skill);
        double itemBoost = XP.getItemBoost(player, skill);
        double biomeBoost = XP.getBiomeBoost(player, skill);
        double dimensionBoost = XP.getDimensionBoost(player, skill);
        double playerBoost = PmmoSavedData.get().getPlayerXpBoost(player.func_110124_au(), skill);
        double additiveMultiplier = 1.0 + (itemBoost + biomeBoost + dimensionBoost + globalBoost + playerBoost) / 100.0;
        multiplier *= globalMultiplier;
        multiplier *= dimensionMultiplier;
        multiplier *= difficultyMultiplier;
        return Math.max(0.0, multiplier *= additiveMultiplier);
    }

    public static double getHorizontalDistance(Vec3d p1, Vec3d p2) {
        return Math.sqrt(Math.pow(p1.func_82615_a() - p2.func_82615_a(), 2.0) + Math.pow(p1.func_82616_c() - p2.func_82616_c(), 2.0));
    }

    public static int getMaxVein(PlayerEntity player, Skill skill) {
        int maxVein = 0;
        int level = skill.getLevel(player) - 1;
        switch (skill) {
            case MINING: {
                maxVein = level / 5;
                break;
            }
            case WOODCUTTING: {
                maxVein = level / 2;
                break;
            }
            case EXCAVATION: {
                maxVein = level;
                break;
            }
            case FARMING: {
                maxVein = level;
            }
        }
        return maxVein;
    }

    public static void awardXp(ServerPlayerEntity player, Skill skill, @Nullable String sourceName, double amount, boolean skip, boolean ignoreBonuses, boolean causedByParty) {
        if (amount <= 0.0 || player.field_70170_p.field_72995_K || player instanceof FakePlayer) {
            return;
        }
        if (skill.getValue() == 0) {
            LOGGER.error("INVALID SKILL AT AWARD XP! SOURCE: " + sourceName + ", AMOUNT: " + amount);
            return;
        }
        PmmoSavedData pmmoSavedData = PmmoSavedData.get();
        String skillName = skill.name().toLowerCase();
        UUID uuid = player.func_110124_au();
        if (!ignoreBonuses) {
            Party party;
            amount *= XP.getMultiplier((PlayerEntity)player, skill);
            if (!causedByParty && (party = pmmoSavedData.getParty(uuid)) != null) {
                Set<ServerPlayerEntity> membersInRange = party.getOnlineMembersInRange(player);
                int membersInRangeSize = membersInRange.size();
                double partyMultiplier = party.getMultiplier(membersInRangeSize);
                party.submitXpGained(uuid, amount *= partyMultiplier);
                amount /= (double)(membersInRangeSize + 1);
                for (ServerPlayerEntity partyMember : membersInRange) {
                    XP.awardXp(partyMember, skill, sourceName, amount, skip, ignoreBonuses, true);
                }
            }
        }
        if (amount <= 0.0) {
            return;
        }
        String playerName = player.func_145748_c_().getString();
        int startLevel = skill.getLevel(uuid);
        double startXp = skill.getXp(uuid);
        double maxXp = Config.getConfig("maxXp");
        if (startXp >= 2.0E9) {
            return;
        }
        if (startXp + amount >= 2.0E9) {
            XP.sendMessage(skillName + " cap of 2b xp reached, you fucking psycho!", false, (PlayerEntity)player, TextFormatting.LIGHT_PURPLE);
            LOGGER.info(player.func_145748_c_().getString() + " " + skillName + " 2b cap reached");
            amount = 2.0E9 - startXp;
        }
        pmmoSavedData.addXp(skill, uuid, amount);
        int currLevel = skill.getLevel(uuid);
        if (startLevel != currLevel) {
            AttributeHandler.updateAll((PlayerEntity)player);
            XP.updateRecipes(player);
            if (ModList.get().isLoaded("compatskills")) {
                String commandArgs = "reskillable incrementskill " + playerName + " compatskills." + (Object)((Object)skill) + " 1";
                try {
                    if (!player.field_70170_p.field_72995_K) {
                        player.func_184102_h().func_195571_aL().func_197054_a().execute(commandArgs, (Object)player.func_195051_bN().func_197031_a());
                    }
                }
                catch (CommandSyntaxException e) {
                    LOGGER.error("PMMO Level Up - compatskills command went wrong! args: " + commandArgs, (Throwable)e);
                }
            }
            if (JsonConfig.data.get((Object)JType.LEVEL_UP_COMMAND).get(skillName.toLowerCase()) != null) {
                Map<String, Double> commandMap = JsonConfig.data.get((Object)JType.LEVEL_UP_COMMAND).get(skillName.toLowerCase());
                for (Map.Entry<String, Double> entry : commandMap.entrySet()) {
                    int commandLevel = (int)Math.floor(entry.getValue());
                    if (startLevel >= commandLevel || currLevel < commandLevel) continue;
                    String command = entry.getKey().replace(">player<", playerName).replace(">level<", "" + commandLevel);
                    try {
                        player.func_184102_h().func_195571_aL().func_197054_a().execute(command, (Object)player.func_184102_h().func_195573_aM());
                        LOGGER.info("Executing command \"" + command + "\"\nTrigger: " + playerName + " level up from " + startLevel + " to " + currLevel + " in " + skill.name() + ", trigger level " + commandLevel);
                    }
                    catch (CommandSyntaxException e) {
                        LOGGER.error("Invalid level up command \"" + command + "\"", (Throwable)e);
                    }
                }
            }
        }
        NetworkHandler.sendToPlayer(new MessageXp(startXp, skill.getValue(), amount, skip), player);
        if (!skip) {
            LOGGER.debug(playerName + " +" + amount + "xp in: " + skillName + " for: " + sourceName + " total xp: " + skill.getXp(uuid));
        }
        if (startXp + amount >= maxXp && startXp < maxXp) {
            XP.sendMessage(skillName + " max startLevel reached, you psycho!", false, (PlayerEntity)player, TextFormatting.LIGHT_PURPLE);
            LOGGER.info(playerName + " " + skillName + " max startLevel reached");
        }
    }

    public static void awardXpTrigger(UUID uuid, String triggerKey, @Nullable String sourceName, boolean skip, boolean ignoreBonuses) {
        if (JsonConfig.data.get((Object)JType.XP_VALUE_TRIGGER).containsKey(triggerKey)) {
            XP.awardXpMap(uuid, JsonConfig.data.get((Object)JType.XP_VALUE_TRIGGER).get(triggerKey), sourceName, skip, ignoreBonuses);
        } else {
            LOGGER.error("TRIGGER XP AWARD \"" + triggerKey + "\" DOES NOT HAVE ANY VALUES, CANNOT AWARD");
        }
    }

    public static void awardXpMap(UUID uuid, Map<String, Double> map, @Nullable String sourceName, boolean skip, boolean ignoreBonuses) {
        for (Map.Entry<String, Double> entry : map.entrySet()) {
            Skill.getSkill(entry.getKey()).addXp(uuid, (double)entry.getValue(), sourceName, skip, ignoreBonuses);
        }
    }

    public static void awardXpMapDouble(UUID uuid, Map<String, Double> map, @Nullable String sourceName, boolean skip, boolean ignoreBonuses) {
        for (Map.Entry<String, Double> entry : map.entrySet()) {
            Skill.getSkill(entry.getKey()).addXp(uuid, (double)entry.getValue(), sourceName, skip, ignoreBonuses);
        }
    }

    public static void updateRecipes(ServerPlayerEntity player) {
        if (Config.forgeConfig.craftReqEnabled.get().booleanValue()) {
            Collection allRecipes = player.func_184102_h().func_199529_aN().func_199510_b();
            HashSet<IRecipe> removeRecipes = new HashSet<IRecipe>();
            HashSet<IRecipe> newRecipes = new HashSet<IRecipe>();
            for (IRecipe recipe : allRecipes) {
                if (XP.checkReq((PlayerEntity)player, recipe.func_77571_b().func_77973_b().getRegistryName(), JType.REQ_CRAFT)) {
                    newRecipes.add(recipe);
                    continue;
                }
                removeRecipes.add(recipe);
            }
            player.func_192037_E().func_197925_b(removeRecipes, player);
            player.func_192037_E().func_197926_a(newRecipes, player);
        }
    }

    public static void scanUnlocks(int level, Skill skill) {
    }

    private static int getGap(int a, int b) {
        return a - b;
    }

    public static int getSkillReqGap(PlayerEntity player, ResourceLocation res, JType jType) {
        Map<String, Double> reqs;
        int gap = 0;
        if (!XP.checkReq(player, res, jType) && (reqs = XP.getReqMap(res.toString(), jType)) != null) {
            gap = (int)Math.floor(reqs.entrySet().stream().map(entry -> XP.getGap((int)Math.floor((Double)entry.getValue()), Skill.getSkill((String)entry.getKey()).getLevel(player))).reduce(0, Math::max).intValue());
        }
        return gap;
    }

    public static BlockPos vecToBlock(Vec3d pos) {
        return new BlockPos(pos);
    }

    public static Vec3d blockToVec(BlockPos pos) {
        return new Vec3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
    }

    public static Vec3d blockToMiddleVec(BlockPos pos) {
        return new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
    }

    public static void spawnRocket(World world, BlockPos pos, Skill skill) {
        XP.spawnRocket(world, new Vec3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), skill);
    }

    public static void spawnRocket(World world, Vec3d pos, Skill skill) {
        CompoundNBT nbt = new CompoundNBT();
        CompoundNBT fw = new CompoundNBT();
        ListNBT explosion = new ListNBT();
        CompoundNBT l = new CompoundNBT();
        int[] colors = new int[]{XP.getSkillColor(skill)};
        l.func_74768_a("Flicker", 1);
        l.func_74768_a("Trail", 0);
        l.func_74768_a("Type", 1);
        l.func_218657_a("Colors", (INBT)new IntArrayNBT(colors));
        explosion.add((Object)l);
        fw.func_218657_a("Explosions", (INBT)explosion);
        fw.func_74768_a("Flight", 0);
        nbt.func_218657_a("Fireworks", (INBT)fw);
        ItemStack itemStack = new ItemStack((IItemProvider)Items.field_196152_dE);
        itemStack.func_77982_d(nbt);
        PMMOFireworkEntity fireworkRocketEntity = new PMMOFireworkEntity(world, pos.func_82615_a() + 0.5, pos.func_82617_b() + 0.5, pos.func_82616_c() + 0.5, itemStack);
        world.func_217376_c((Entity)fireworkRocketEntity);
    }

    public static void applyWornPenalty(PlayerEntity player, ItemStack itemStack) {
        ResourceLocation resLoc = itemStack.func_77973_b().getRegistryName();
        if (!XP.checkReq(player, resLoc, JType.REQ_WEAR)) {
            int gap = XP.getSkillReqGap(player, resLoc, JType.REQ_WEAR);
            if (gap > 9) {
                gap = 9;
            }
            player.func_195064_c(new EffectInstance(Effects.field_76419_f, 75, gap, false, true));
            player.func_195064_c(new EffectInstance(Effects.field_76437_t, 75, gap, false, true));
            player.func_195064_c(new EffectInstance(Effects.field_76421_d, 75, gap, false, true));
            if (Config.forgeConfig.strictReqWear.get().booleanValue() || EnchantmentHelper.func_190938_b((ItemStack)itemStack)) {
                ItemStack droppedItemStack = itemStack.func_77946_l();
                player.func_146097_a(droppedItemStack, false, false);
                itemStack.func_190920_e(0);
                player.func_146105_b(new TranslationTextComponent("pmmo.notSkilledEnoughToWearDropped", new Object[]{new TranslationTextComponent(droppedItemStack.func_77973_b().func_77658_a(), new Object[0])}).func_150255_a(textStyle.get("red")), true);
                player.func_146105_b(new TranslationTextComponent("pmmo.notSkilledEnoughToWearDropped", new Object[]{new TranslationTextComponent(droppedItemStack.func_77973_b().func_77658_a(), new Object[0])}).func_150255_a(textStyle.get("red")), false);
            } else {
                player.func_146105_b(new TranslationTextComponent("pmmo.notSkilledEnoughToWear", new Object[]{new TranslationTextComponent(itemStack.func_77973_b().func_77658_a(), new Object[0])}).func_150255_a(textStyle.get("red")), true);
            }
        }
    }

    public static void checkBiomeLevelReq(PlayerEntity player) {
        Map<String, Double> negativeEffect;
        Biome biome = player.field_70170_p.func_226691_t_(XP.vecToBlock(player.func_213303_ch()));
        ResourceLocation resLoc = biome.getRegistryName();
        if (resLoc == null) {
            return;
        }
        String biomeKey = resLoc.toString();
        UUID playerUUID = player.func_110124_au();
        Map<String, Double> biomeReq = JsonConfig.data.get((Object)JType.REQ_BIOME).get(biomeKey);
        Map<String, Map<String, Double>> negativeEffects = JsonConfig.data.get((Object)JType.BIOME_EFFECT_NEGATIVE);
        Map<String, Map<String, Double>> positiveEffects = JsonConfig.data.get((Object)JType.BIOME_EFFECT_POSITIVE);
        if (!lastBiome.containsKey(playerUUID)) {
            lastBiome.put(playerUUID, "none");
        }
        if (XP.checkReq(player, resLoc, JType.REQ_BIOME)) {
            Map<String, Double> positiveEffect;
            if (positiveEffects != null && (positiveEffect = positiveEffects.get(biomeKey)) != null) {
                for (Map.Entry<String, Double> entry : positiveEffect.entrySet()) {
                    Effect effect = (Effect)ForgeRegistries.POTIONS.getValue(XP.getResLoc(entry.getKey()));
                    if (effect == null) continue;
                    player.func_195064_c(new EffectInstance(effect, 75, (int)Math.floor(entry.getValue()), false, false));
                }
            }
        } else if (negativeEffects != null && (negativeEffect = negativeEffects.get(biomeKey)) != null) {
            for (Map.Entry<String, Double> entry : negativeEffect.entrySet()) {
                Effect effect = (Effect)ForgeRegistries.POTIONS.getValue(XP.getResLoc(entry.getKey()));
                if (effect == null) continue;
                player.func_195064_c(new EffectInstance(effect, 75, (int)Math.floor(entry.getValue()), false, true));
            }
            if (player.field_70170_p.func_201670_d() && !lastBiome.get(playerUUID).equals(biomeKey)) {
                player.func_146105_b(new TranslationTextComponent("pmmo.notSkilledEnoughToSurvive", new Object[]{new TranslationTextComponent(biome.getRegistryName().toString(), new Object[0])}).func_150255_a(textStyle.get("red")), true);
                player.func_146105_b(new TranslationTextComponent("pmmo.notSkilledEnoughToSurvive", new Object[]{new TranslationTextComponent(biome.getRegistryName().toString(), new Object[0])}).func_150255_a(textStyle.get("red")), false);
                for (Map.Entry<String, Double> entry : biomeReq.entrySet()) {
                    int startLevel = Skill.getSkill(entry.getKey()).getLevel(player);
                    if ((double)startLevel < entry.getValue()) {
                        player.func_146105_b(new TranslationTextComponent("pmmo.levelDisplay", new Object[]{" " + new TranslationTextComponent("pmmo." + entry.getKey(), new Object[0]).getString(), "" + (int)Math.floor(entry.getValue())}).func_150255_a(textStyle.get("red")), false);
                        continue;
                    }
                    player.func_146105_b(new TranslationTextComponent("pmmo.levelDisplay", new Object[]{" " + new TranslationTextComponent("pmmo." + entry.getKey(), new Object[0]).getString(), "" + (int)Math.floor(entry.getValue())}).func_150255_a(textStyle.get("green")), false);
                }
            }
        }
        lastBiome.put(playerUUID, biomeKey);
    }

    public static double getWeight(int startLevel, Map<String, Double> fishItem) {
        return DP.mapCapped(startLevel, fishItem.get("startLevel"), fishItem.get("endLevel"), fishItem.get("startWeight"), fishItem.get("endWeight"));
    }

    public static Map<Skill, Double> getOfflineXpMap(UUID uuid) {
        if (!offlineXp.containsKey(uuid)) {
            offlineXp.put(uuid, new HashMap());
        }
        return offlineXp.get(uuid);
    }

    public static void setOfflineXpMap(UUID uuid, Map<Skill, Double> newOfflineXp) {
        offlineXp.put(uuid, newOfflineXp);
    }

    public static void removeOfflineXpUuid(UUID uuid) {
        offlineXp.remove(uuid);
    }

    public static int getOfflineLevel(Skill skill, UUID uuid) {
        return XP.levelAtXp(XP.getOfflineXp(skill, uuid));
    }

    public static double getOfflineXp(Skill skill, UUID uuid) {
        if (skill.equals((Object)Skill.INVALID_SKILL)) {
            LOGGER.error("Invalid Skill at getOfflineXp");
            return -1.0;
        }
        return ((Map)offlineXp.getOrDefault(uuid, new HashMap())).getOrDefault((Object)skill, 0.0);
    }

    public static double logBase(double base, double goal) {
        return Math.log(goal) / Math.log(base);
    }

    public static int levelAtXp(float xp) {
        return XP.levelAtXp((double)xp);
    }

    public static int levelAtXp(double xp) {
        boolean useExponentialFormula = Config.getConfig("useExponentialFormula") != 0.0;
        double baseXp = Config.getConfig("baseXp");
        double exponentialBaseXp = Config.getConfig("exponentialBaseXp");
        double exponentialBase = Config.getConfig("exponentialBase");
        double exponentialRate = Config.getConfig("exponentialRate");
        int maxLevel = (int)Math.floor(Config.getConfig("maxLevel"));
        double xpIncreasePerLevel = Config.getConfig("xpIncreasePerLevel");
        int theXp = 0;
        int startLevel = 0;
        while (!(xp < (double)theXp) && startLevel < maxLevel) {
            theXp = useExponentialFormula ? (int)((double)theXp + exponentialBaseXp * Math.pow(exponentialBase, exponentialRate * (double)startLevel)) : (int)((double)theXp + (baseXp + (double)startLevel * xpIncreasePerLevel));
            ++startLevel;
        }
        return startLevel;
    }

    public static float levelAtXpDecimal(float xp) {
        return (float)XP.levelAtXpDecimal((double)xp);
    }

    public static double levelAtXpDecimal(double xp) {
        double goalXp;
        int startLevel;
        double startXp;
        int maxLevel = (int)Math.floor(Config.getConfig("maxLevel"));
        if (XP.levelAtXp(xp) == maxLevel) {
            xp = XP.xpAtLevel(maxLevel);
        }
        if ((startXp = XP.xpAtLevel(startLevel = XP.levelAtXp(xp))) == (goalXp = XP.xpAtLevel(startLevel + 1))) {
            return maxLevel;
        }
        return (double)startLevel + (xp - startXp) / (goalXp - startXp);
    }

    public static double xpAtLevel(int givenLevel) {
        return XP.xpAtLevel((double)givenLevel);
    }

    public static double xpAtLevel(float givenLevel) {
        return XP.xpAtLevel((double)givenLevel);
    }

    public static double xpAtLevel(double givenLevel) {
        boolean useExponentialFormula = Config.getConfig("useExponentialFormula") != 0.0;
        double baseXp = Config.getConfig("baseXp");
        double exponentialBaseXp = Config.getConfig("exponentialBaseXp");
        double exponentialBase = Config.getConfig("exponentialBase");
        double exponentialRate = Config.getConfig("exponentialRate");
        int maxLevel = (int)Math.floor(Config.getConfig("maxLevel"));
        if (givenLevel > (double)maxLevel) {
            givenLevel = maxLevel;
        }
        double theXp = 0.0;
        double xpIncreasePerLevel = Config.getConfig("xpIncreasePerLevel");
        int startLevel = 1;
        while ((double)startLevel < givenLevel) {
            theXp = useExponentialFormula ? (theXp += exponentialBaseXp * Math.pow(exponentialBase, exponentialRate * (double)(startLevel - 1))) : (theXp += baseXp + (double)(startLevel - 1) * xpIncreasePerLevel);
            ++startLevel;
        }
        return theXp;
    }

    public static double xpAtLevelDecimal(double givenLevel) {
        double startXp = XP.xpAtLevel(Math.floor(givenLevel));
        double endXp = XP.xpAtLevel(Math.floor(givenLevel + 1.0));
        double pos = givenLevel - Math.floor(givenLevel);
        return startXp + (endXp - startXp) * pos;
    }
}

