/*
 * Decompiled with CFR 0.152.
 */
package com.MrVorgan.peashootersmod.util.handlers;

import com.MrVorgan.peashootersmod.init.ModBiomes;
import com.MrVorgan.peashootersmod.init.ModBlocks;
import com.MrVorgan.peashootersmod.init.ModEntities;
import com.MrVorgan.peashootersmod.init.ModItems;
import com.MrVorgan.peashootersmod.util.IHasModel;
import com.MrVorgan.peashootersmod.util.handlers.RenderHandler;
import com.MrVorgan.peashootersmod.util.handlers.SoundsHandler;
import com.MrVorgan.peashootersmod.world.biome.WorldGenCustomStructures;
import com.MrVorgan.peashootersmod.world.biome.types.WorldTypeZomburbia;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class RegistryHandler {
    @SubscribeEvent
    public static void onItemRegister(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModItems.ITEMS.toArray(new Item[0]));
    }

    @SubscribeEvent
    public static void onBlockRegister(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModBlocks.BLOCKS.toArray(new Block[0]));
    }

    @SubscribeEvent
    public static void onModelRegister(ModelRegistryEvent event) {
        for (Item item : ModItems.ITEMS) {
            if (!(item instanceof IHasModel)) continue;
            ((IHasModel)item).registerModels();
        }
        for (Block block : ModBlocks.BLOCKS) {
            if (!(block instanceof IHasModel)) continue;
            ((IHasModel)block).registerModels();
        }
    }

    public static void preInitRegistries() {
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenCustomStructures(), (int)0);
        ModBiomes.registerBiomes();
        ModEntities.registerEntities();
        RenderHandler.registerEntityRenderers();
    }

    public static void initRegistries() {
        SoundsHandler.registerSounds();
    }

    public static void postInitRegistries() {
        WorldTypeZomburbia ZOMBURBIA = new WorldTypeZomburbia();
    }
}

