/*
 * Decompiled with CFR 0.152.
 */
package com.MrVorgan.peashootersmod.world.biome;

import com.MrVorgan.peashootersmod.world.biome.BiomeFrostbiteCaves;
import com.MrVorgan.peashootersmod.world.biome.BiomeZomburbia;
import com.MrVorgan.peashootersmod.world.biome.WorldGenStructure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenCustomStructures
implements IWorldGenerator {
    public final WorldGenStructure DEAD_FOUNTAIN = new WorldGenStructure("dead tree");
    public final WorldGenStructure GARDEN = new WorldGenStructure("garden");
    public final WorldGenStructure DEAD_GARDEN = new WorldGenStructure("dead_garden");
    public final WorldGenStructure DEAD_TREE1 = new WorldGenStructure("deadtree1");
    public final WorldGenStructure DEAD_TREE2 = new WorldGenStructure("deadtree2");
    public final WorldGenStructure DEAD_TREE3 = new WorldGenStructure("deadtree3");
    public final WorldGenStructure FROZEN_YETI = new WorldGenStructure("frozen_yeti");

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.getDimension()) {
            case 1: {
                break;
            }
            case 0: {
                this.generateStructure(this.DEAD_FOUNTAIN, world, random, chunkX, chunkZ, 200, (Block)Blocks.field_150391_bh, BiomeZomburbia.class);
                this.generateStructure(this.GARDEN, world, random, chunkX, chunkZ, 300, (Block)Blocks.field_150391_bh, BiomeZomburbia.class);
                this.generateStructure(this.FROZEN_YETI, world, random, chunkX, chunkZ, 50, Blocks.field_150433_aE, BiomeFrostbiteCaves.class);
                this.generateStructure(this.DEAD_GARDEN, world, random, chunkX, chunkZ, 300, (Block)Blocks.field_150391_bh, BiomeZomburbia.class);
                this.generateStructure(this.DEAD_TREE3, world, random, chunkX, chunkZ, 5, (Block)Blocks.field_150391_bh, BiomeZomburbia.class);
                this.generateStructure(this.DEAD_TREE2, world, random, chunkX, chunkZ, 5, (Block)Blocks.field_150391_bh, BiomeZomburbia.class);
                this.generateStructure(this.DEAD_TREE1, world, random, chunkX, chunkZ, 5, (Block)Blocks.field_150391_bh, BiomeZomburbia.class);
                break;
            }
        }
    }

    private void generateStructure(WorldGenerator generator, World world, Random random, int chunkX, int chunkZ, int chance, Block topBlock, Class<?> ... classes) {
        ArrayList classesList = new ArrayList(Arrays.asList(classes));
        int x = chunkX * 16 + random.nextInt(15);
        int z = chunkZ * 16 + random.nextInt(15);
        int y = this.calculateGenerationHeight(world, x, z, topBlock);
        BlockPos pos = new BlockPos(x, y, z);
        Class<?> biome = world.field_73011_w.getBiomeForCoords(pos).getClass();
        if (world.func_175624_G() != WorldType.field_77138_c && classesList.contains(biome) && random.nextInt(chance) == 0) {
            generator.func_180709_b(world, random, pos);
        }
    }

    private int calculateGenerationHeight(World world, int x, int z, Block topBlock) {
        int y = world.func_72800_K();
        boolean foundGround = false;
        while (!foundGround && y-- >= 0) {
            Block block = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
            foundGround = block == topBlock;
        }
        return y;
    }
}

