/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import java.io.File;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.command.CommandSource;
import net.minecraft.data.IDataProvider;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.threetag.threecore.ThreeCoreCommonConfig;
import net.threetag.threecore.ThreeCoreServerConfig;
import net.threetag.threecore.ability.AbilityClientEventHandler;
import net.threetag.threecore.ability.AbilityHelper;
import net.threetag.threecore.ability.AbilityType;
import net.threetag.threecore.ability.condition.ConditionType;
import net.threetag.threecore.ability.superpower.SuperpowerManager;
import net.threetag.threecore.accessoires.AccessoireLayerRenderer;
import net.threetag.threecore.accessoires.Accessoires;
import net.threetag.threecore.addonpacks.AddonPackManager;
import net.threetag.threecore.block.TCBlocks;
import net.threetag.threecore.capability.CapabilityAbilityContainer;
import net.threetag.threecore.capability.ThreeCoreCapabilities;
import net.threetag.threecore.client.renderer.AbilityBarRenderer;
import net.threetag.threecore.client.renderer.KarmaBarRenderer;
import net.threetag.threecore.client.renderer.UnconsciousRenderer;
import net.threetag.threecore.client.renderer.entity.model.EntityModelManager;
import net.threetag.threecore.client.renderer.entity.modellayer.ModelLayerLoader;
import net.threetag.threecore.client.renderer.entity.modellayer.ModelLayerManager;
import net.threetag.threecore.client.renderer.tileentity.HydraulicPressTileEntityRenderer;
import net.threetag.threecore.command.ArmorStandPoseCommand;
import net.threetag.threecore.command.KarmaCommand;
import net.threetag.threecore.command.SizeChangeCommand;
import net.threetag.threecore.command.SuperpowerCommand;
import net.threetag.threecore.compat.curios.CuriosHandler;
import net.threetag.threecore.container.TCContainerTypes;
import net.threetag.threecore.data.ThreeCoreBlockTagsProvider;
import net.threetag.threecore.data.ThreeCoreEntityTypeTagsProvider;
import net.threetag.threecore.data.ThreeCoreItemTagsProvider;
import net.threetag.threecore.data.ThreeCoreRecipeProvider;
import net.threetag.threecore.data.lang.English;
import net.threetag.threecore.entity.TCEntityTypes;
import net.threetag.threecore.entity.armorstand.ArmorStandPoseManager;
import net.threetag.threecore.entity.attributes.TCAttributes;
import net.threetag.threecore.event.GenerateDocumentationFilesEvent;
import net.threetag.threecore.item.TCItems;
import net.threetag.threecore.item.recipe.TCRecipeSerializers;
import net.threetag.threecore.item.recipe.ToolIngredient;
import net.threetag.threecore.loot.function.TCLootFunctions;
import net.threetag.threecore.network.AbilityKeyMessage;
import net.threetag.threecore.network.AddAbilityContainerMessage;
import net.threetag.threecore.network.AddAbilityMessage;
import net.threetag.threecore.network.BuyConditionMessage;
import net.threetag.threecore.network.EmptyHandInteractMessage;
import net.threetag.threecore.network.KarmaInfoMessage;
import net.threetag.threecore.network.MultiJumpMessage;
import net.threetag.threecore.network.OpenConstructionTableTabMessage;
import net.threetag.threecore.network.RemoveAbilityContainerMessage;
import net.threetag.threecore.network.RemoveAbilityMessage;
import net.threetag.threecore.network.SendArmorStandCommandMessage;
import net.threetag.threecore.network.SendPlayerAbilityContainerMessage;
import net.threetag.threecore.network.SendSuperpowerToastMessage;
import net.threetag.threecore.network.SetAbilityKeybindMessage;
import net.threetag.threecore.network.SetArmorStandPoseMessage;
import net.threetag.threecore.network.SyncAccessoiresMessage;
import net.threetag.threecore.network.SyncKarmaMessage;
import net.threetag.threecore.network.SyncMultiverseMessage;
import net.threetag.threecore.network.SyncSizeMessage;
import net.threetag.threecore.network.SyncThreeDataMessage;
import net.threetag.threecore.network.ToggleAccessoireMessage;
import net.threetag.threecore.network.UpdateAbilityMessage;
import net.threetag.threecore.network.UpdateSizeData;
import net.threetag.threecore.network.UpdateThreeDataMessage;
import net.threetag.threecore.potion.TCEffects;
import net.threetag.threecore.scripts.ScriptEventManager;
import net.threetag.threecore.scripts.ScriptManager;
import net.threetag.threecore.scripts.accessors.ScriptAccessor;
import net.threetag.threecore.sound.TCSounds;
import net.threetag.threecore.tileentity.TCTileEntityTypes;
import net.threetag.threecore.util.RenderUtil;
import net.threetag.threecore.util.SupporterHandler;
import net.threetag.threecore.util.entityeffect.EntityEffectUpdateMessage;
import net.threetag.threecore.util.icon.IconSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="threecore")
public class ThreeCore {
    public static final String MODID = "threecore";
    public static final Logger LOGGER = LogManager.getLogger();
    public static SimpleChannel NETWORK_CHANNEL;
    private static int networkId;
    public static final File MOD_SUBFOLDER;
    private static boolean htmlGenerated;

    public ThreeCore() {
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new Events());
        this.registerMessages();
        MinecraftForge.EVENT_BUS.addListener(TCBlocks::initOres);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, ThreeCoreCommonConfig.generateConfig());
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, ThreeCoreServerConfig.generateConfig());
        AddonPackManager.init();
        MinecraftForge.EVENT_BUS.addListener(TCItems::onLootTableLoad);
        TCContainerTypes.registerConstructionTableTables();
        AbilityHelper.registerAbilityContainer(p -> {
            ArrayList containerList = Lists.newArrayList();
            p.getCapability(CapabilityAbilityContainer.MULTI_ABILITY_CONTAINER).ifPresent(containers -> containerList.addAll(containers.getAllContainers()));
            return containerList;
        });
        AbilityHelper.registerAbilityContainer(p -> {
            ArrayList containerList = Lists.newArrayList();
            for (EquipmentSlotType slots : EquipmentSlotType.values()) {
                p.func_184582_a(slots).getCapability(CapabilityAbilityContainer.ABILITY_CONTAINER).ifPresent(containerList::add);
            }
            return containerList;
        });
        CraftingHelper.register((ResourceLocation)ToolIngredient.ID, (IIngredientSerializer)ToolIngredient.Serializer.INSTANCE);
        TCItems.ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        TCBlocks.BLOCKS.register(FMLJavaModLoadingContext.get().getModEventBus());
        TCTileEntityTypes.TILE_ENTITIES.register(FMLJavaModLoadingContext.get().getModEventBus());
        TCContainerTypes.CONTAINER_TYPES.register(FMLJavaModLoadingContext.get().getModEventBus());
        TCRecipeSerializers.RECIPE_SERIALIZERS.register(FMLJavaModLoadingContext.get().getModEventBus());
        TCEntityTypes.ENTITIES.register(FMLJavaModLoadingContext.get().getModEventBus());
        TCSounds.SOUND_EVENTS.register(FMLJavaModLoadingContext.get().getModEventBus());
        TCEffects.EFFECTS.register(FMLJavaModLoadingContext.get().getModEventBus());
        TCAttributes.ATTRIBUTES.register(FMLJavaModLoadingContext.get().getModEventBus());
        Accessoires.ACCESSOIRES.register(FMLJavaModLoadingContext.get().getModEventBus());
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            MinecraftForge.EVENT_BUS.addListener(RenderUtil::onRenderGlobal);
            MinecraftForge.EVENT_BUS.register((Object)new KarmaBarRenderer());
            MinecraftForge.EVENT_BUS.register((Object)new AbilityBarRenderer());
            MinecraftForge.EVENT_BUS.register((Object)new UnconsciousRenderer());
            MinecraftForge.EVENT_BUS.register((Object)new AbilityClientEventHandler());
            if (Minecraft.func_71410_x() != null) {
                ((IReloadableResourceManager)Minecraft.func_71410_x().func_195551_G()).func_219534_a((IFutureReloadListener)new EntityModelManager());
                ((IReloadableResourceManager)Minecraft.func_71410_x().func_195551_G()).func_219534_a((IFutureReloadListener)new ModelLayerLoader());
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void registries(RegistryEvent.NewRegistry e) {
        TCLootFunctions.register();
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void setup(FMLCommonSetupEvent e) {
        ThreeCoreCapabilities.init();
        TCItems.loadItemColors();
        e.enqueueWork(TCEntityTypes::initAttributes);
        if (ModList.get().isLoaded("curios")) {
            CuriosHandler.enable();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void setupClient(FMLClientSetupEvent e) {
        TCBlocks.initRenderTypes();
        TCTileEntityTypes.initRenderers();
        TCEntityTypes.initRenderers();
        TCContainerTypes.initContainerScreens();
        ArmorStandPoseManager.init();
        TCItems.initItemProperties();
        if (!SupporterHandler.loadPlayerData(Minecraft.func_71410_x().func_110432_I().func_148256_e().getId()).hasModAccess() && SupporterHandler.isSupporterCheckEnabled()) {
            throw new RuntimeException("You are not allowed to play this mod!");
        }
        Minecraft.func_71410_x().func_175598_ae().getSkinMap().forEach((s, pl) -> pl.func_177094_a((LayerRenderer)new AccessoireLayerRenderer((PlayerRenderer)pl)));
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void textureStichPre(TextureStitchEvent.Pre e) {
        e.addSprite(HydraulicPressTileEntityRenderer.TEXTURE.func_229313_b_());
    }

    public void registerMessages() {
        ThreeCore.registerMessage(OpenConstructionTableTabMessage.class, OpenConstructionTableTabMessage::toBytes, OpenConstructionTableTabMessage::new, OpenConstructionTableTabMessage::handle);
        ThreeCore.registerMessage(SendPlayerAbilityContainerMessage.class, SendPlayerAbilityContainerMessage::toBytes, SendPlayerAbilityContainerMessage::new, SendPlayerAbilityContainerMessage::handle);
        ThreeCore.registerMessage(UpdateAbilityMessage.class, UpdateAbilityMessage::toBytes, UpdateAbilityMessage::new, UpdateAbilityMessage::handle);
        ThreeCore.registerMessage(AddAbilityMessage.class, AddAbilityMessage::toBytes, AddAbilityMessage::new, AddAbilityMessage::handle);
        ThreeCore.registerMessage(RemoveAbilityMessage.class, RemoveAbilityMessage::toBytes, RemoveAbilityMessage::new, RemoveAbilityMessage::handle);
        ThreeCore.registerMessage(AbilityKeyMessage.class, AbilityKeyMessage::toBytes, AbilityKeyMessage::new, AbilityKeyMessage::handle);
        ThreeCore.registerMessage(SendSuperpowerToastMessage.class, SendSuperpowerToastMessage::toBytes, SendSuperpowerToastMessage::new, SendSuperpowerToastMessage::handle);
        ThreeCore.registerMessage(BuyConditionMessage.class, BuyConditionMessage::toBytes, BuyConditionMessage::new, BuyConditionMessage::handle);
        ThreeCore.registerMessage(SetAbilityKeybindMessage.class, SetAbilityKeybindMessage::toBytes, SetAbilityKeybindMessage::new, SetAbilityKeybindMessage::handle);
        ThreeCore.registerMessage(MultiJumpMessage.class, MultiJumpMessage::toBytes, MultiJumpMessage::new, MultiJumpMessage::handle);
        ThreeCore.registerMessage(EmptyHandInteractMessage.class, EmptyHandInteractMessage::toBytes, EmptyHandInteractMessage::new, EmptyHandInteractMessage::handle);
        ThreeCore.registerMessage(AddAbilityContainerMessage.class, AddAbilityContainerMessage::toBytes, AddAbilityContainerMessage::new, AddAbilityContainerMessage::handle);
        ThreeCore.registerMessage(RemoveAbilityContainerMessage.class, RemoveAbilityContainerMessage::toBytes, RemoveAbilityContainerMessage::new, RemoveAbilityContainerMessage::handle);
        ThreeCore.registerMessage(SyncKarmaMessage.class, SyncKarmaMessage::toBytes, SyncKarmaMessage::new, SyncKarmaMessage::handle);
        ThreeCore.registerMessage(KarmaInfoMessage.class, KarmaInfoMessage::toBytes, KarmaInfoMessage::new, KarmaInfoMessage::handle);
        ThreeCore.registerMessage(SyncSizeMessage.class, SyncSizeMessage::toBytes, SyncSizeMessage::new, SyncSizeMessage::handle);
        ThreeCore.registerMessage(UpdateSizeData.class, UpdateSizeData::toBytes, UpdateSizeData::new, UpdateSizeData::handle);
        ThreeCore.registerMessage(SetArmorStandPoseMessage.class, SetArmorStandPoseMessage::toBytes, SetArmorStandPoseMessage::new, SetArmorStandPoseMessage::handle);
        ThreeCore.registerMessage(SendArmorStandCommandMessage.class, SendArmorStandCommandMessage::toBytes, SendArmorStandCommandMessage::new, SendArmorStandCommandMessage::handle);
        ThreeCore.registerMessage(UpdateThreeDataMessage.class, UpdateThreeDataMessage::toBytes, UpdateThreeDataMessage::new, UpdateThreeDataMessage::handle);
        ThreeCore.registerMessage(SyncThreeDataMessage.class, SyncThreeDataMessage::toBytes, SyncThreeDataMessage::new, SyncThreeDataMessage::handle);
        ThreeCore.registerMessage(EntityEffectUpdateMessage.class, EntityEffectUpdateMessage::toBytes, EntityEffectUpdateMessage::new, EntityEffectUpdateMessage::handle);
        ThreeCore.registerMessage(SyncMultiverseMessage.class, SyncMultiverseMessage::toBytes, SyncMultiverseMessage::new, SyncMultiverseMessage::handle);
        ThreeCore.registerMessage(SyncAccessoiresMessage.class, SyncAccessoiresMessage::toBytes, SyncAccessoiresMessage::new, SyncAccessoiresMessage::handle);
        ThreeCore.registerMessage(ToggleAccessoireMessage.class, ToggleAccessoireMessage::toBytes, ToggleAccessoireMessage::new, ToggleAccessoireMessage::handle);
    }

    @SubscribeEvent
    public void gatherData(GatherDataEvent e) {
        ThreeCoreBlockTagsProvider b = new ThreeCoreBlockTagsProvider(e.getGenerator());
        e.getGenerator().func_200390_a((IDataProvider)b);
        e.getGenerator().func_200390_a((IDataProvider)new ThreeCoreItemTagsProvider(e.getGenerator(), b));
        e.getGenerator().func_200390_a((IDataProvider)new ThreeCoreEntityTypeTagsProvider(e.getGenerator()));
        e.getGenerator().func_200390_a((IDataProvider)new ThreeCoreRecipeProvider(e.getGenerator()));
        e.getGenerator().func_200390_a((IDataProvider)new English(e.getGenerator()));
    }

    public static <MSG> int registerMessage(Class<MSG> messageType, BiConsumer<MSG, PacketBuffer> encoder, Function<PacketBuffer, MSG> decoder, BiConsumer<MSG, Supplier<NetworkEvent.Context>> messageConsumer) {
        if (NETWORK_CHANNEL == null) {
            NETWORK_CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(MODID, MODID), () -> "1.0", s -> true, s -> true);
        }
        int id = networkId++;
        NETWORK_CHANNEL.registerMessage(id, messageType, encoder, decoder, messageConsumer);
        return id;
    }

    static {
        networkId = -1;
        MOD_SUBFOLDER = new File("mods/threecore");
        htmlGenerated = false;
    }

    public static class Events {
        @SubscribeEvent
        public void serverStarting(RegisterCommandsEvent e) {
            SuperpowerCommand.register((CommandDispatcher<CommandSource>)e.getDispatcher());
            KarmaCommand.register((CommandDispatcher<CommandSource>)e.getDispatcher());
            SizeChangeCommand.register((CommandDispatcher<CommandSource>)e.getDispatcher());
            ArmorStandPoseCommand.register((CommandDispatcher<CommandSource>)e.getDispatcher());
        }

        @SubscribeEvent
        public void addListenerEvent(AddReloadListenerEvent event) {
            event.addListener((IFutureReloadListener)new SuperpowerManager());
            event.addListener((IFutureReloadListener)new ScriptManager());
        }

        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent
        public void initGui(GuiScreenEvent.InitGuiEvent e) {
            if (e.getGui() instanceof MainMenuScreen && !htmlGenerated) {
                DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
                    AbilityType.generateDocumentation();
                    ConditionType.generateDocumentation();
                    ScriptAccessor.generateDocumentation();
                    ScriptEventManager.generateDocumentation();
                    IconSerializer.generateDocumentation();
                    ModelLayerManager.generateDocumentation();
                    MinecraftForge.EVENT_BUS.post((Event)new GenerateDocumentationFilesEvent());
                });
                htmlGenerated = true;
            }
        }
    }
}

