/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.ability;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;
import net.threetag.threecore.ability.Ability;
import net.threetag.threecore.ability.AcceleratingFlightAbility;
import net.threetag.threecore.ability.AttributeModifierAbility;
import net.threetag.threecore.ability.ChangeAbilityTabTextureAbility;
import net.threetag.threecore.ability.CommandAbility;
import net.threetag.threecore.ability.CustomHotbarAbility;
import net.threetag.threecore.ability.DamageImmunityAbility;
import net.threetag.threecore.ability.DropArmorAbility;
import net.threetag.threecore.ability.DummyAbility;
import net.threetag.threecore.ability.EnergyAbility;
import net.threetag.threecore.ability.FlightAbility;
import net.threetag.threecore.ability.HUDAbility;
import net.threetag.threecore.ability.HealingAbility;
import net.threetag.threecore.ability.HideBodyPartsAbility;
import net.threetag.threecore.ability.InvisibilityAbility;
import net.threetag.threecore.ability.ModelLayerAbility;
import net.threetag.threecore.ability.MultiJumpAbility;
import net.threetag.threecore.ability.NameChangeAbility;
import net.threetag.threecore.ability.OpeningNbtTimerAbility;
import net.threetag.threecore.ability.PotionEffectAbility;
import net.threetag.threecore.ability.ProjectileAbility;
import net.threetag.threecore.ability.SizeChangeAbility;
import net.threetag.threecore.ability.SkinChangeAbility;
import net.threetag.threecore.ability.SlowfallAbility;
import net.threetag.threecore.ability.TeleportAbility;
import net.threetag.threecore.ability.WaterBreathingAbility;
import net.threetag.threecore.scripts.events.RegisterAbilityThreeDataScriptEvent;
import net.threetag.threecore.util.documentation.DocumentationBuilder;
import net.threetag.threecore.util.threedata.ThreeData;

@Mod.EventBusSubscriber(modid="threecore", bus=Mod.EventBusSubscriber.Bus.MOD)
public class AbilityType
extends ForgeRegistryEntry<AbilityType> {
    public static IForgeRegistry<AbilityType> REGISTRY;
    public static final AbilityType DUMMY;
    public static final AbilityType COMMAND;
    public static final AbilityType HEALING;
    public static final AbilityType FLIGHT;
    public static final AbilityType ACCELERATING_FLIGHT;
    public static final AbilityType TELEPORT;
    public static final AbilityType ATTRIBUTE_MODIFIER;
    public static final AbilityType INVISIBILITY;
    public static final AbilityType SLOWFALL;
    public static final AbilityType WATER_BREATHING;
    public static final AbilityType SIZE_CHANGE;
    public static final AbilityType CUSTOM_HOTBAR;
    public static final AbilityType OPENING_NBT_TIMER;
    public static final AbilityType MODEL_LAYER;
    public static final AbilityType PROJECTILE;
    public static final AbilityType DAMAGE_IMMUNITY;
    public static final AbilityType POTION_EFFECT;
    public static final AbilityType MULTI_JUMP;
    public static final AbilityType NAME_CHANGE;
    public static final AbilityType HUD;
    public static final AbilityType SKIN_CHANGE;
    public static final AbilityType HIDE_BODY_PARTS;
    public static final AbilityType CHANGE_ABILITY_TAB_TEXTURE;
    public static final AbilityType ENERGY;
    public static final AbilityType DROP_ARMOR;
    private Supplier<Ability> supplier;

    @SubscribeEvent
    public static void onRegisterNewRegistries(RegistryEvent.NewRegistry e) {
        REGISTRY = new RegistryBuilder().setName(new ResourceLocation("threecore", "ability_types")).setType(AbilityType.class).setIDRange(0, 2048).create();
    }

    @SubscribeEvent
    public static void onRegisterAbilityTypes(RegistryEvent.Register<AbilityType> e) {
        e.getRegistry().register((IForgeRegistryEntry)DUMMY);
        e.getRegistry().register((IForgeRegistryEntry)COMMAND);
        e.getRegistry().register((IForgeRegistryEntry)HEALING);
        e.getRegistry().register((IForgeRegistryEntry)FLIGHT);
        e.getRegistry().register((IForgeRegistryEntry)ACCELERATING_FLIGHT);
        e.getRegistry().register((IForgeRegistryEntry)TELEPORT);
        e.getRegistry().register((IForgeRegistryEntry)ATTRIBUTE_MODIFIER);
        e.getRegistry().register((IForgeRegistryEntry)INVISIBILITY);
        e.getRegistry().register((IForgeRegistryEntry)SLOWFALL);
        e.getRegistry().register((IForgeRegistryEntry)WATER_BREATHING);
        e.getRegistry().register((IForgeRegistryEntry)SIZE_CHANGE);
        e.getRegistry().register((IForgeRegistryEntry)CUSTOM_HOTBAR);
        e.getRegistry().register((IForgeRegistryEntry)OPENING_NBT_TIMER);
        e.getRegistry().register((IForgeRegistryEntry)MODEL_LAYER);
        e.getRegistry().register((IForgeRegistryEntry)PROJECTILE);
        e.getRegistry().register((IForgeRegistryEntry)DAMAGE_IMMUNITY);
        e.getRegistry().register((IForgeRegistryEntry)POTION_EFFECT);
        e.getRegistry().register((IForgeRegistryEntry)MULTI_JUMP);
        e.getRegistry().register((IForgeRegistryEntry)NAME_CHANGE);
        e.getRegistry().register((IForgeRegistryEntry)HUD);
        e.getRegistry().register((IForgeRegistryEntry)SKIN_CHANGE);
        e.getRegistry().register((IForgeRegistryEntry)HIDE_BODY_PARTS);
        e.getRegistry().register((IForgeRegistryEntry)CHANGE_ABILITY_TAB_TEXTURE);
        e.getRegistry().register((IForgeRegistryEntry)ENERGY);
        e.getRegistry().register((IForgeRegistryEntry)DROP_ARMOR);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void generateDocumentation() {
        HashMap<String, List> sorted = new HashMap<String, List>();
        for (AbilityType types : REGISTRY.getValues()) {
            Ability ability = types.create("");
            String modName = AbilityType.getModContainerFromId(types.getRegistryName().func_110624_b()) != null ? AbilityType.getModContainerFromId(types.getRegistryName().func_110624_b()).getDisplayName() : types.getRegistryName().func_110624_b();
            List<Ability> modsAbilities = sorted.containsKey(modName) ? (List)sorted.get(modName) : new ArrayList();
            modsAbilities.add(ability);
            sorted.put(modName, modsAbilities);
        }
        DocumentationBuilder.HTMLObject overview = DocumentationBuilder.paragraph(DocumentationBuilder.subHeading("Overview"));
        DocumentationBuilder builder = new DocumentationBuilder(new ResourceLocation("threecore", "abilities"), "Abilities").addStyle(".json-block { background-color: lightgray; display: inline-block; border: 5px solid darkgray; padding: 10px }").add(DocumentationBuilder.heading("Abilities")).add(DocumentationBuilder.hr()).add(overview);
        sorted.forEach((mod, abilities) -> {
            overview.add(DocumentationBuilder.subSubHeading(mod));
            overview.add(DocumentationBuilder.list(abilities.stream().map(ability -> DocumentationBuilder.link(StringUtils.func_76338_a((String)ability.dataManager.get(Ability.TITLE).getString()), "#" + ability.type.getRegistryName().toString())).collect(Collectors.toList())));
        });
        sorted.values().forEach(modAbilities -> modAbilities.forEach(ability -> {
            LinkedList data = new LinkedList();
            List<ThreeData<?>> dataList = ability.getDataManager().getSettingData();
            StringBuilder jsonText = new StringBuilder("{\"example_ability\":{\"ability\":\"").append(ability.type.getRegistryName().toString()).append("\",");
            for (int i = 0; i < dataList.size(); ++i) {
                ThreeData<?> threeData = dataList.get(i);
                String s = threeData.getJsonString(ability.getDataManager().getDefaultValue(threeData));
                LinkedList<Object> settings = new LinkedList<Object>();
                settings.add(threeData.getJsonKey());
                settings.add(threeData.getType().getTypeName().substring(threeData.getType().getTypeName().lastIndexOf(".") + 1));
                settings.add(new DocumentationBuilder.HTMLObject("code", s));
                settings.add(threeData.getDescription() == null || threeData.getDescription().isEmpty() ? "/" : threeData.getDescription());
                data.add(settings);
                jsonText.append("  \"").append(threeData.getJsonKey()).append("\": ").append(s).append(i < dataList.size() - 1 ? "," : "");
            }
            jsonText.append("}}");
            builder.add(DocumentationBuilder.hr()).add(DocumentationBuilder.div(new Object[0]).setId(ability.type.getRegistryName().toString()).add(DocumentationBuilder.subHeading(StringUtils.func_76338_a((String)ability.dataManager.get(Ability.TITLE).getString())).add(new DocumentationBuilder.HTMLObject("code", ability.type.getRegistryName().toString()))).add(DocumentationBuilder.subSubHeading("Data Settings:")).add(DocumentationBuilder.table(Arrays.asList("Setting", "Type", "Fallback Value", "Description"), data)).add(DocumentationBuilder.subSubHeading("Example:")).add(new DocumentationBuilder.HTMLObject("pre").addAttribute("class", "json-block").setId(ability.type.getRegistryName().toString() + "_example")).add(DocumentationBuilder.js("var json = JSON.parse('" + jsonText.toString() + "'); document.getElementById('" + ability.type.getRegistryName().toString() + "_example').innerHTML = JSON.stringify(json, undefined, 2);")));
        }));
        builder.save();
    }

    public static ModInfo getModContainerFromId(String modid) {
        for (ModInfo modInfo : ModList.get().getMods()) {
            if (!modInfo.getModId().equals(modid)) continue;
            return modInfo;
        }
        return null;
    }

    public AbilityType(Supplier<Ability> supplier) {
        this.supplier = supplier;
    }

    public AbilityType(Supplier<Ability> supplier, String modid, String name) {
        this.supplier = supplier;
        this.setRegistryName(modid, name);
    }

    public Ability create(String id) {
        Ability a = this.supplier.get();
        a.id = id;
        new RegisterAbilityThreeDataScriptEvent(a).fire();
        return a;
    }

    static {
        DUMMY = new AbilityType(DummyAbility::new, "threecore", "dummy");
        COMMAND = new AbilityType(CommandAbility::new, "threecore", "command");
        HEALING = new AbilityType(HealingAbility::new, "threecore", "healing");
        FLIGHT = new AbilityType(FlightAbility::new, "threecore", "flight");
        ACCELERATING_FLIGHT = new AbilityType(AcceleratingFlightAbility::new, "threecore", "accelerating_flight");
        TELEPORT = new AbilityType(TeleportAbility::new, "threecore", "teleport");
        ATTRIBUTE_MODIFIER = new AbilityType(AttributeModifierAbility::new, "threecore", "attribute_modifier");
        INVISIBILITY = new AbilityType(InvisibilityAbility::new, "threecore", "invisibility");
        SLOWFALL = new AbilityType(SlowfallAbility::new, "threecore", "slowfall");
        WATER_BREATHING = new AbilityType(WaterBreathingAbility::new, "threecore", "water_breathing");
        SIZE_CHANGE = new AbilityType(SizeChangeAbility::new, "threecore", "size_change");
        CUSTOM_HOTBAR = new AbilityType(CustomHotbarAbility::new, "threecore", "custom_hotbar");
        OPENING_NBT_TIMER = new AbilityType(OpeningNbtTimerAbility::new, "threecore", "opening_nbt_timer");
        MODEL_LAYER = new AbilityType(ModelLayerAbility::new, "threecore", "model_layer");
        PROJECTILE = new AbilityType(ProjectileAbility::new, "threecore", "projectile");
        DAMAGE_IMMUNITY = new AbilityType(DamageImmunityAbility::new, "threecore", "damage_immunity");
        POTION_EFFECT = new AbilityType(PotionEffectAbility::new, "threecore", "potion_effect");
        MULTI_JUMP = new AbilityType(MultiJumpAbility::new, "threecore", "multi_jump");
        NAME_CHANGE = new AbilityType(NameChangeAbility::new, "threecore", "name_change");
        HUD = new AbilityType(HUDAbility::new, "threecore", "hud");
        SKIN_CHANGE = new AbilityType(SkinChangeAbility::new, "threecore", "skin_change");
        HIDE_BODY_PARTS = new AbilityType(HideBodyPartsAbility::new, "threecore", "hide_body_parts");
        CHANGE_ABILITY_TAB_TEXTURE = new AbilityType(ChangeAbilityTabTextureAbility::new, "threecore", "change_ability_tab_texture");
        ENERGY = new AbilityType(EnergyAbility::new, "threecore", "energy");
        DROP_ARMOR = new AbilityType(DropArmorAbility::new, "threecore", "drop_armor");
    }
}

