/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.ability;

import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.threetag.threecore.ability.Ability;
import net.threetag.threecore.ability.AbilityType;
import net.threetag.threecore.util.threedata.AttributeOperationThreeData;
import net.threetag.threecore.util.threedata.AttributeThreeData;
import net.threetag.threecore.util.threedata.DoubleThreeData;
import net.threetag.threecore.util.threedata.EnumSync;
import net.threetag.threecore.util.threedata.ThreeData;
import net.threetag.threecore.util.threedata.UUIDThreeData;

public class AttributeModifierAbility
extends Ability {
    public static final ThreeData<Attribute> ATTRIBUTE = new AttributeThreeData("attribute").setSyncType(EnumSync.SELF).enableSetting("attribute", "Determines which attribute should be modified. Possible attribute: " + AttributeModifierAbility.getAttributeList());
    public static final ThreeData<Double> AMOUNT = new DoubleThreeData("amount").setSyncType(EnumSync.SELF).enableSetting("amount", "The amount for the giving attribute modifier");
    public static final ThreeData<AttributeModifier.Operation> OPERATION = new AttributeOperationThreeData("operation").setSyncType(EnumSync.SELF).enableSetting("operation", "The operation for the giving attribute modifier (More: https://minecraft.gamepedia.com/Attribute#Operations)");
    public static final ThreeData<UUID> UUID = new UUIDThreeData("uuid").setSyncType(EnumSync.SELF).enableSetting("uuid", "Sets the unique identifier for this attribute modifier. If not specified it will generate a random one");

    public AttributeModifierAbility() {
        super(AbilityType.ATTRIBUTE_MODIFIER);
    }

    @Override
    public void registerData() {
        super.registerData();
        this.dataManager.register((ThreeData)ATTRIBUTE, Attributes.field_233826_i_);
        this.dataManager.register((ThreeData)AMOUNT, (Object)1.0);
        this.dataManager.register((ThreeData)OPERATION, AttributeModifier.Operation.ADDITION);
        this.dataManager.register((ThreeData)UUID, java.util.UUID.fromString("498be4fb-af04-42f2-8948-e6ccdc0d99e1"));
    }

    @Override
    public void action(LivingEntity entity) {
        Attribute attribute = this.dataManager.get(ATTRIBUTE);
        ModifiableAttributeInstance instance = entity.func_110148_a(attribute);
        if (instance == null || entity.field_70170_p.field_72995_K) {
            return;
        }
        UUID uuid = this.dataManager.get(UUID);
        AttributeModifier modifier = instance.func_111127_a(uuid);
        if (modifier != null && (modifier.func_111164_d() != ((Double)this.get(AMOUNT)).doubleValue() || modifier.func_220375_c() != this.get(OPERATION))) {
            instance.func_188479_b(uuid);
        }
        if ((modifier = instance.func_111127_a(uuid)) == null) {
            modifier = new AttributeModifier(uuid, ((ITextComponent)this.dataManager.get(TITLE)).getString(), this.dataManager.get(AMOUNT).doubleValue(), this.dataManager.get(OPERATION));
            instance.func_233767_b_(modifier);
        }
    }

    @Override
    public void lastTick(LivingEntity entity) {
        if (entity.func_110148_a(this.dataManager.get(ATTRIBUTE)) != null && entity.func_110148_a(this.dataManager.get(ATTRIBUTE)).func_111127_a(this.dataManager.get(UUID)) != null) {
            entity.func_110148_a(this.dataManager.get(ATTRIBUTE)).func_188479_b(this.dataManager.get(UUID));
        }
    }

    private static String getAttributeList() {
        StringBuilder stringBuilder = new StringBuilder();
        ForgeRegistries.ATTRIBUTES.forEach(attribute -> stringBuilder.append(", \"").append(ForgeRegistries.ATTRIBUTES.getKey((IForgeRegistryEntry)attribute).toString()).append("\""));
        return stringBuilder.toString().substring(2);
    }
}

