/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.ability;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.threetag.threecore.ability.Ability;
import net.threetag.threecore.ability.AbilityType;
import net.threetag.threecore.scripts.ScriptEventManager;
import net.threetag.threecore.scripts.events.MultiJumpScriptEvent;
import net.threetag.threecore.util.icon.TexturedIcon;
import net.threetag.threecore.util.threedata.EnumSync;
import net.threetag.threecore.util.threedata.IntegerThreeData;
import net.threetag.threecore.util.threedata.ThreeData;

public class MultiJumpAbility
extends Ability {
    public static final ThreeData<Integer> JUMPS = new IntegerThreeData("jumps").setSyncType(EnumSync.NONE).enableSetting("Determines how often the player can jump in the air");
    public int jumps;

    public MultiJumpAbility() {
        super(AbilityType.MULTI_JUMP);
    }

    @Override
    public void registerData() {
        super.registerData();
        this.register(ICON, new TexturedIcon(TexturedIcon.ICONS_TEXTURE, 144, 16, 16, 16));
        this.register(JUMPS, 2);
    }

    @Override
    public void action(LivingEntity entity) {
        if (entity.func_233570_aj_() && this.jumps > 0) {
            this.jumps = 0;
        }
    }

    public void jump(PlayerEntity player) {
        if (!player.func_233570_aj_() && this.jumps < (Integer)this.get(JUMPS) - 1) {
            ++this.jumps;
            MultiJumpScriptEvent event = new MultiJumpScriptEvent((LivingEntity)player, this, this.jumps);
            ScriptEventManager.fireEvent(event);
            if (!event.isCancelled()) {
                player.func_70664_aZ();
                player.field_70143_R = 0.0f;
                ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket((Entity)player));
            }
        }
    }
}

