/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.ability.condition;

import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.INBTSerializable;
import net.threetag.threecore.ability.Ability;
import net.threetag.threecore.ability.condition.ConditionType;
import net.threetag.threecore.client.gui.ability.AbilitiesScreen;
import net.threetag.threecore.scripts.events.ConditionDataUpdatedScriptEvent;
import net.threetag.threecore.util.threedata.BooleanThreeData;
import net.threetag.threecore.util.threedata.EnumSync;
import net.threetag.threecore.util.threedata.IThreeDataHolder;
import net.threetag.threecore.util.threedata.IWrappedThreeDataHolder;
import net.threetag.threecore.util.threedata.TextComponentThreeData;
import net.threetag.threecore.util.threedata.ThreeData;
import net.threetag.threecore.util.threedata.ThreeDataManager;

public abstract class Condition
implements INBTSerializable<CompoundNBT>,
IWrappedThreeDataHolder {
    public final Ability ability;
    public final ConditionType type;
    UUID id;
    protected ThreeDataManager dataManager = new ThreeDataManager().setListener(new ThreeDataManager.Listener(){

        @Override
        public <T> void dataChanged(ThreeData<T> data, T oldValue, T value) {
            Condition.this.ability.sync = data.getSyncType().add(data.getSyncType());
            Condition.this.setDirty();
            if (Condition.this.ability.entity != null) {
                new ConditionDataUpdatedScriptEvent(Condition.this.ability.entity, Condition.this.ability, Condition.this, data.getKey(), value, oldValue).fire();
            }
        }
    });
    public static final ThreeData<ITextComponent> CUSTOM_TITLE = new TextComponentThreeData("custom_title").setSyncType(EnumSync.SELF).enableSetting("custom_title", "A custom display name for the condition.");
    public static final ThreeData<Boolean> INVERT = new BooleanThreeData("invert").enableSetting("invert", "Lets you invert the condition");
    public static final ThreeData<Boolean> ENABLING = new BooleanThreeData("enabling").setSyncType(EnumSync.SELF).enableSetting("enabling", "If this condition enables. If false it instead decides whether the ability is unlocked.");
    public static final ThreeData<Boolean> NEEDS_KEY = new BooleanThreeData("needs_key").setSyncType(EnumSync.SELF).enableSetting("needs_key", "If this condition requires a key");

    public Condition(ConditionType type, Ability ability) {
        this.type = type;
        this.ability = ability;
        this.registerData();
    }

    @Override
    public IThreeDataHolder getThreeDataHolder() {
        return this.dataManager;
    }

    public void registerData() {
        this.dataManager.register((ThreeData)CUSTOM_TITLE, new StringTextComponent("empty"));
        this.dataManager.register((ThreeData)INVERT, (Object)false);
        this.dataManager.register((ThreeData)ENABLING, (Object)false);
        this.dataManager.register((ThreeData)NEEDS_KEY, (Object)false);
    }

    public final ITextComponent getDisplayName() {
        ITextComponent custom = this.dataManager.get(CUSTOM_TITLE);
        if (custom instanceof StringTextComponent && ((StringTextComponent)custom).func_150265_g().equalsIgnoreCase("empty")) {
            return this.createTitle();
        }
        return custom;
    }

    public ITextComponent createTitle() {
        return new TranslationTextComponent(Util.func_200697_a((String)"ability.condition", (ResourceLocation)this.type.getRegistryName()) + (this.dataManager.get(INVERT) != false ? ".not" : ""));
    }

    public final UUID getUniqueId() {
        return this.id;
    }

    public void readFromJson(JsonObject json) {
        this.dataManager.readFromJson(json);
    }

    public ThreeDataManager getDataManager() {
        return this.dataManager;
    }

    public abstract boolean test(LivingEntity var1);

    public void firstTick() {
    }

    public void lastTick() {
    }

    public void whileEnabled(LivingEntity entity) {
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("ConditionType", this.type.getRegistryName().toString());
        nbt.func_218657_a("Data", (INBT)this.dataManager.serializeNBT());
        nbt.func_218657_a("UUID", (INBT)NBTUtil.func_240626_a_((UUID)this.id));
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.dataManager.deserializeNBT(nbt.func_74775_l("Data"));
        this.id = NBTUtil.func_186860_b((INBT)Objects.requireNonNull(nbt.func_74781_a("UUID")));
    }

    public void setDirty() {
        this.ability.setDirty();
    }

    @OnlyIn(value=Dist.CLIENT)
    public Screen getScreen(AbilitiesScreen screen) {
        return null;
    }
}

