/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.ability.condition;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;
import net.threetag.threecore.ability.AbilitiesLockedCondition;
import net.threetag.threecore.ability.Ability;
import net.threetag.threecore.ability.AbilityType;
import net.threetag.threecore.ability.AttributeModifierAbility;
import net.threetag.threecore.ability.condition.AbilityEnabledCondition;
import net.threetag.threecore.ability.condition.AbilityUnlockedCondition;
import net.threetag.threecore.ability.condition.ActionCondition;
import net.threetag.threecore.ability.condition.ComboCondition;
import net.threetag.threecore.ability.condition.Condition;
import net.threetag.threecore.ability.condition.CooldownCondition;
import net.threetag.threecore.ability.condition.CuriosSlotCondition;
import net.threetag.threecore.ability.condition.EquipmentSlotCondition;
import net.threetag.threecore.ability.condition.ExclusiveCondition;
import net.threetag.threecore.ability.condition.EyesInFluidCondition;
import net.threetag.threecore.ability.condition.HeldCondition;
import net.threetag.threecore.ability.condition.ItemBuyableAbilityCondition;
import net.threetag.threecore.ability.condition.ItemIntegerNbtCondition;
import net.threetag.threecore.ability.condition.KarmaCondition;
import net.threetag.threecore.ability.condition.LivingValuesCondition;
import net.threetag.threecore.ability.condition.PotionCondition;
import net.threetag.threecore.ability.condition.SizeCondition;
import net.threetag.threecore.ability.condition.ThreeDataCondition;
import net.threetag.threecore.ability.condition.ToggleCondition;
import net.threetag.threecore.ability.condition.WearingCuriosCondition;
import net.threetag.threecore.ability.condition.WearingItemCondition;
import net.threetag.threecore.ability.condition.WearingItemTagCondition;
import net.threetag.threecore.ability.condition.XPBuyableAbilityCondition;
import net.threetag.threecore.ability.condition.XPCondition;
import net.threetag.threecore.util.documentation.DocumentationBuilder;
import net.threetag.threecore.util.threedata.ThreeData;

@Mod.EventBusSubscriber(modid="threecore", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ConditionType
extends ForgeRegistryEntry<ConditionType> {
    public static IForgeRegistry<ConditionType> REGISTRY;
    public static final ConditionType ACTION;
    public static final ConditionType HELD;
    public static final ConditionType TOGGLE;
    public static final ConditionType COOLDOWN;
    public static final ConditionType ABILITY_ENABLED;
    public static final ConditionType ABILITY_UNLOCKED;
    public static final ConditionType KARMA;
    public static final ConditionType XP_BUY;
    public static final ConditionType ITEM_BUY;
    public static final ConditionType EQUIPMENT_SLOT;
    public static final ConditionType XP;
    public static final ConditionType WEARING_ITEM;
    public static final ConditionType WEARING_ITEM_TAG;
    public static final ConditionType ITEM_INTEGER_NBT;
    public static final ConditionType EYES_IN_FLUID;
    public static final ConditionType SIZE;
    public static final ConditionType ABILITIES_LOCKED;
    public static final ConditionType LIVING_VALUES;
    public static final ConditionType POTION;
    public static final ConditionType THREE_DATA;
    public static final ConditionType EXCLUSIVE;
    public static final ConditionType COMBO;
    public static final ConditionType CURIOS_SLOT;
    public static final ConditionType WEARING_CURIOS;
    private Function<Ability, Condition> function;

    @SubscribeEvent
    public static void onRegisterNewRegistries(RegistryEvent.NewRegistry e) {
        REGISTRY = new RegistryBuilder().setName(new ResourceLocation("threecore", "condition_types")).setType(ConditionType.class).setIDRange(0, 2048).create();
    }

    @SubscribeEvent
    public static void onRegisterConditionTypes(RegistryEvent.Register<ConditionType> e) {
        e.getRegistry().register((IForgeRegistryEntry)ACTION);
        e.getRegistry().register((IForgeRegistryEntry)HELD);
        e.getRegistry().register((IForgeRegistryEntry)TOGGLE);
        e.getRegistry().register((IForgeRegistryEntry)COOLDOWN);
        e.getRegistry().register((IForgeRegistryEntry)ABILITY_ENABLED);
        e.getRegistry().register((IForgeRegistryEntry)ABILITY_UNLOCKED);
        e.getRegistry().register((IForgeRegistryEntry)KARMA);
        e.getRegistry().register((IForgeRegistryEntry)XP_BUY);
        e.getRegistry().register((IForgeRegistryEntry)ITEM_BUY);
        e.getRegistry().register((IForgeRegistryEntry)EQUIPMENT_SLOT);
        e.getRegistry().register((IForgeRegistryEntry)XP);
        e.getRegistry().register((IForgeRegistryEntry)WEARING_ITEM);
        e.getRegistry().register((IForgeRegistryEntry)WEARING_ITEM_TAG);
        e.getRegistry().register((IForgeRegistryEntry)ITEM_INTEGER_NBT);
        e.getRegistry().register((IForgeRegistryEntry)EYES_IN_FLUID);
        e.getRegistry().register((IForgeRegistryEntry)SIZE);
        e.getRegistry().register((IForgeRegistryEntry)ABILITIES_LOCKED);
        e.getRegistry().register((IForgeRegistryEntry)LIVING_VALUES);
        e.getRegistry().register((IForgeRegistryEntry)POTION);
        e.getRegistry().register((IForgeRegistryEntry)THREE_DATA);
        e.getRegistry().register((IForgeRegistryEntry)EXCLUSIVE);
        e.getRegistry().register((IForgeRegistryEntry)COMBO);
        e.getRegistry().register((IForgeRegistryEntry)CURIOS_SLOT);
        e.getRegistry().register((IForgeRegistryEntry)WEARING_CURIOS);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void generateDocumentation() {
        HashMap<String, List> sorted = new HashMap<String, List>();
        AttributeModifierAbility ability_ = new AttributeModifierAbility();
        for (ConditionType types : REGISTRY.getValues()) {
            Condition condition = types.create(ability_);
            String modName = AbilityType.getModContainerFromId(types.getRegistryName().func_110624_b()) != null ? AbilityType.getModContainerFromId(types.getRegistryName().func_110624_b()).getDisplayName() : types.getRegistryName().func_110624_b();
            List<Condition> modsConditions = sorted.containsKey(modName) ? (List)sorted.get(modName) : new ArrayList();
            modsConditions.add(condition);
            sorted.put(modName, modsConditions);
        }
        DocumentationBuilder.HTMLObject overview = DocumentationBuilder.paragraph(DocumentationBuilder.subHeading("Overview"));
        DocumentationBuilder builder = new DocumentationBuilder(new ResourceLocation("threecore", "conditions"), "Conditions").addStyle(".json-block { background-color: lightgray; display: inline-block; border: 5px solid darkgray; padding: 10px }").add(DocumentationBuilder.heading("Conditions")).add(DocumentationBuilder.hr()).add(overview);
        sorted.forEach((mod, conditions) -> {
            overview.add(DocumentationBuilder.subSubHeading(mod));
            overview.add(DocumentationBuilder.list(conditions.stream().map(condition -> DocumentationBuilder.link(StringUtils.func_76338_a((String)condition.getDisplayName().getString()), "#" + condition.type.getRegistryName().toString())).collect(Collectors.toList())));
        });
        sorted.values().forEach(modConditions -> modConditions.forEach(condition -> {
            LinkedList data = new LinkedList();
            List<ThreeData<?>> dataList = condition.getDataManager().getSettingData();
            StringBuilder jsonText = new StringBuilder("[{\"type\":\"").append(condition.type.getRegistryName().toString()).append("\",");
            for (int i = 0; i < dataList.size(); ++i) {
                ThreeData<?> threeData = dataList.get(i);
                String s = threeData.getJsonString(condition.getDataManager().getDefaultValue(threeData));
                LinkedList<Object> settings = new LinkedList<Object>();
                settings.add(threeData.getJsonKey());
                settings.add(threeData.getType().getTypeName().substring(threeData.getType().getTypeName().lastIndexOf(".") + 1));
                settings.add(new DocumentationBuilder.HTMLObject("code", s));
                settings.add(threeData.getDescription() == null || threeData.getDescription().isEmpty() ? "/" : threeData.getDescription());
                data.add(settings);
                jsonText.append("  \"").append(threeData.getJsonKey()).append("\": ").append(s).append(i < dataList.size() - 1 ? "," : "");
            }
            jsonText.append("}]");
            builder.add(DocumentationBuilder.hr()).add(DocumentationBuilder.div(new Object[0]).setId(condition.type.getRegistryName().toString()).add(DocumentationBuilder.subHeading(StringUtils.func_76338_a((String)condition.getDisplayName().getString())).add(new DocumentationBuilder.HTMLObject("code", condition.type.getRegistryName().toString()))).add(DocumentationBuilder.subSubHeading("Data Settings:")).add(DocumentationBuilder.table(Arrays.asList("Setting", "Type", "Fallback Value", "Description"), data)).add(DocumentationBuilder.subSubHeading("Example:")).add(new DocumentationBuilder.HTMLObject("pre").addAttribute("class", "json-block").setId(condition.type.getRegistryName().toString() + "_example")).add(DocumentationBuilder.js("var json = JSON.parse('" + jsonText.toString() + "'); document.getElementById('" + condition.type.getRegistryName().toString() + "_example').innerHTML = JSON.stringify(json, undefined, 2);")));
        }));
        builder.save();
    }

    public ConditionType(Function<Ability, Condition> function) {
        this.function = function;
    }

    public ConditionType(Function<Ability, Condition> function, String modid, String name) {
        this.function = function;
        this.setRegistryName(modid, name);
    }

    public Condition create(Ability ability) {
        return this.function.apply(ability);
    }

    static {
        ACTION = new ConditionType(ActionCondition::new, "threecore", "action");
        HELD = new ConditionType(HeldCondition::new, "threecore", "held");
        TOGGLE = new ConditionType(ToggleCondition::new, "threecore", "toggle");
        COOLDOWN = new ConditionType(CooldownCondition::new, "threecore", "cooldown");
        ABILITY_ENABLED = new ConditionType(AbilityEnabledCondition::new, "threecore", "ability_enabled");
        ABILITY_UNLOCKED = new ConditionType(AbilityUnlockedCondition::new, "threecore", "ability_unlocked");
        KARMA = new ConditionType(KarmaCondition::new, "threecore", "karma");
        XP_BUY = new ConditionType(XPBuyableAbilityCondition::new, "threecore", "xp_buy");
        ITEM_BUY = new ConditionType(ItemBuyableAbilityCondition::new, "threecore", "item_buy");
        EQUIPMENT_SLOT = new ConditionType(EquipmentSlotCondition::new, "threecore", "equipment_slot");
        XP = new ConditionType(XPCondition::new, "threecore", "xp");
        WEARING_ITEM = new ConditionType(WearingItemCondition::new, "threecore", "wearing_item");
        WEARING_ITEM_TAG = new ConditionType(WearingItemTagCondition::new, "threecore", "wearing_item_tag");
        ITEM_INTEGER_NBT = new ConditionType(ItemIntegerNbtCondition::new, "threecore", "item_integer_nbt");
        EYES_IN_FLUID = new ConditionType(EyesInFluidCondition::new, "threecore", "eyes_in_fluid");
        SIZE = new ConditionType(SizeCondition::new, "threecore", "size");
        ABILITIES_LOCKED = new ConditionType(AbilitiesLockedCondition::new, "threecore", "abilities_locked");
        LIVING_VALUES = new ConditionType(LivingValuesCondition::new, "threecore", "living_values");
        POTION = new ConditionType(PotionCondition::new, "threecore", "has_potions");
        THREE_DATA = new ConditionType(ThreeDataCondition::new, "threecore", "three_data");
        EXCLUSIVE = new ConditionType(ExclusiveCondition::new, "threecore", "exclusive");
        COMBO = new ConditionType(ComboCondition::new, "threecore", "combo");
        CURIOS_SLOT = new ConditionType(CuriosSlotCondition::new, "threecore", "curios_slot");
        WEARING_CURIOS = new ConditionType(WearingCuriosCondition::new, "threecore", "wearing_curios");
    }
}

