/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.ability.condition;

import com.google.gson.JsonObject;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.CapabilityItemHandler;
import net.threetag.threecore.ability.Ability;
import net.threetag.threecore.ability.condition.BuyableAbilityCondition;
import net.threetag.threecore.ability.condition.ConditionType;
import net.threetag.threecore.client.gui.ability.AbilitiesScreen;
import net.threetag.threecore.client.gui.ability.BuyAbilityScreen;
import net.threetag.threecore.util.icon.ItemIcon;
import net.threetag.threecore.util.threedata.EnumSync;
import net.threetag.threecore.util.threedata.ItemStackThreeData;
import net.threetag.threecore.util.threedata.ThreeData;

public class ItemBuyableAbilityCondition
extends BuyableAbilityCondition {
    public static ThreeData<ItemStack> ITEM = new ItemStackThreeData("item").setSyncType(EnumSync.SELF).enableSetting("item", "Determines the item the player must spend to activate this condition.");

    public ItemBuyableAbilityCondition(Ability ability) {
        super(ConditionType.ITEM_BUY, ability);
    }

    @Override
    public void registerData() {
        super.registerData();
        this.dataManager.register((ThreeData)ITEM, new ItemStack((IItemProvider)Items.field_151034_e));
    }

    @Override
    public void readFromJson(JsonObject json) {
        super.readFromJson(json);
    }

    @Override
    public boolean isAvailable(LivingEntity entity) {
        AtomicBoolean b = new AtomicBoolean(false);
        entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(inv -> {
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack stack = inv.getStackInSlot(i);
                if (!ItemStack.func_77989_b((ItemStack)stack, (ItemStack)this.dataManager.get(ITEM))) continue;
                b.set(!inv.extractItem(i, this.dataManager.get(ITEM).func_190916_E(), true).func_190926_b());
                break;
            }
        });
        return b.get();
    }

    @Override
    public boolean takeFromEntity(LivingEntity entity) {
        AtomicBoolean b = new AtomicBoolean(false);
        entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(inv -> {
            int index = -1;
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack stack = inv.getStackInSlot(i);
                if (!ItemStack.func_77989_b((ItemStack)stack, (ItemStack)this.dataManager.get(ITEM))) continue;
                index = i;
                break;
            }
            if (index >= 0) {
                b.set(!inv.extractItem(index, this.dataManager.get(ITEM).func_190916_E(), false).func_190926_b());
            }
        });
        return b.get();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Screen getScreen(AbilitiesScreen screen) {
        return (Boolean)this.dataManager.get(BOUGHT) != false ? null : new BuyAbilityScreen(this.ability, this, new ItemIcon(this.dataManager.get(ITEM)), (ITextComponent)new TranslationTextComponent("ability.condition.threecore.item_buy.info", new Object[]{this.dataManager.get(ITEM).func_190916_E(), this.dataManager.get(ITEM).func_200301_q()}), screen);
    }
}

