/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.ability.condition;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.threetag.threecore.ability.Ability;
import net.threetag.threecore.ability.condition.Condition;
import net.threetag.threecore.ability.condition.ConditionType;
import net.threetag.threecore.util.threedata.EnumSync;
import net.threetag.threecore.util.threedata.FloatThreeData;
import net.threetag.threecore.util.threedata.StringThreeData;
import net.threetag.threecore.util.threedata.ThreeData;

public class LivingValuesCondition
extends Condition {
    public static final ThreeData<String> VALUE_TYPE = new StringThreeData("value_type").setSyncType(EnumSync.SELF).enableSetting("value_type", "The type of value to test, HEALTH, HUNGER, SATURATION, OXYGEN, ARMOR, TOUGHNESS, EXPERIENCE_BAR, or EXPERIENCE_POINT");
    public static final ThreeData<String> TEST_TYPE = new StringThreeData("test_type").setSyncType(EnumSync.SELF).enableSetting("test_type", "The type of test for the value, GREATER, LESS, EQUAL, PERCENT_GREATER, PERCENT_LESS, PERCENT_EQUAL");
    public static final ThreeData<Float> TEST_VALUE = new FloatThreeData("test_value").setSyncType(EnumSync.SELF).enableSetting("test_value", "The value to test the entity's value against");

    public LivingValuesCondition(Ability ability) {
        super(ConditionType.LIVING_VALUES, ability);
    }

    @Override
    public boolean test(LivingEntity entity) {
        try {
            float value = 0.0f;
            float maxValue = 0.0f;
            float testValue = this.getDataManager().get(TEST_VALUE).floatValue();
            ValueType valueType = ValueType.valueOf(this.getDataManager().get(VALUE_TYPE).toUpperCase());
            TestType testType = TestType.valueOf(this.getDataManager().get(TEST_TYPE).toUpperCase());
            switch (valueType) {
                case HEALTH: {
                    value = entity.func_110143_aJ();
                    maxValue = entity.func_110138_aP();
                    break;
                }
                case HUNGER: {
                    if (entity instanceof PlayerEntity) {
                        value = ((PlayerEntity)entity).func_71024_bL().func_75116_a();
                    }
                    maxValue = 20.0f;
                    break;
                }
                case SATURATION: {
                    if (entity instanceof PlayerEntity) {
                        value = ((PlayerEntity)entity).func_71024_bL().func_75115_e();
                    }
                    maxValue = 20.0f;
                    break;
                }
                case OXYGEN: {
                    value = entity.func_70086_ai();
                    maxValue = entity.func_205010_bg();
                    break;
                }
                case ARMOR: {
                    value = entity.func_70658_aO();
                    maxValue = 20.0f;
                    break;
                }
                case TOUGHNESS: {
                    value = (float)entity.func_110148_a(Attributes.field_233827_j_).func_111126_e();
                    maxValue = 12.0f;
                    break;
                }
                case EXPERIENCE_BAR: {
                    if (!(entity instanceof PlayerEntity)) break;
                    value = ((PlayerEntity)entity).field_71106_cc;
                    maxValue = ((PlayerEntity)entity).func_71050_bK();
                    break;
                }
                case EXPERIENCE_POINT: {
                    if (entity instanceof PlayerEntity) {
                        value = ((PlayerEntity)entity).field_71067_cb;
                    }
                    maxValue = 2.1474836E9f;
                }
            }
            switch (testType) {
                case GREATER: {
                    return value > testValue;
                }
                case LESS: {
                    return value < testValue;
                }
                case EQUAL: {
                    return value == testValue;
                }
                case PERCENT_GREATER: {
                    return value / maxValue * 100.0f > testValue;
                }
                case PERCENT_LESS: {
                    return value / maxValue * 100.0f < testValue;
                }
                case PERCENT_EQUAL: {
                    return value / maxValue * 100.0f == testValue;
                }
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        return true;
    }

    @Override
    public void registerData() {
        super.registerData();
        this.dataManager.register((ThreeData)VALUE_TYPE, "HEALTH");
        this.dataManager.register((ThreeData)TEST_TYPE, "GREATER");
        this.dataManager.register((ThreeData)TEST_VALUE, Float.valueOf(0.0f));
    }

    @Override
    public ITextComponent createTitle() {
        String valueType = this.dataManager.get(VALUE_TYPE);
        String testType = this.dataManager.get(TEST_TYPE);
        float testValue = this.dataManager.get(TEST_VALUE).floatValue();
        return new TranslationTextComponent(Util.func_200697_a((String)"ability.condition", (ResourceLocation)this.type.getRegistryName()) + ((Boolean)this.dataManager.get(INVERT) != false ? ".not" : ""), new Object[]{valueType, testType, Float.valueOf(testValue)});
    }

    static enum TestType {
        GREATER,
        LESS,
        EQUAL,
        PERCENT_GREATER,
        PERCENT_LESS,
        PERCENT_EQUAL;

    }

    static enum ValueType {
        HEALTH,
        HUNGER,
        SATURATION,
        OXYGEN,
        ARMOR,
        TOUGHNESS,
        EXPERIENCE_BAR,
        EXPERIENCE_POINT;

    }
}

