/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.ability.condition;

import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.threetag.threecore.ability.Ability;
import net.threetag.threecore.ability.condition.Condition;
import net.threetag.threecore.ability.condition.ConditionType;
import net.threetag.threecore.capability.CapabilitySizeChanging;
import net.threetag.threecore.util.threedata.EnumSync;
import net.threetag.threecore.util.threedata.FloatThreeData;
import net.threetag.threecore.util.threedata.ThreeData;

public class SizeCondition
extends Condition {
    public static final ThreeData<Float> MIN = new FloatThreeData("min").setSyncType(EnumSync.SELF).enableSetting("min", "The minimum size required for the condition to be true.");
    public static final ThreeData<Float> MAX = new FloatThreeData("max").setSyncType(EnumSync.SELF).enableSetting("max", "The maximum size required for the condition to be true.");

    public SizeCondition(Ability ability) {
        super(ConditionType.SIZE, ability);
    }

    @Override
    public boolean test(LivingEntity entity) {
        AtomicBoolean b = new AtomicBoolean(false);
        entity.getCapability(CapabilitySizeChanging.SIZE_CHANGING).ifPresent(s -> b.set(s.getScale() >= this.dataManager.get(MIN).floatValue() && s.getScale() <= this.dataManager.get(MAX).floatValue()));
        return b.get();
    }

    @Override
    public void registerData() {
        super.registerData();
        this.dataManager.register((ThreeData)MIN, Float.valueOf(0.0f));
        this.dataManager.register((ThreeData)MAX, Float.valueOf(16.0f));
    }

    @Override
    public ITextComponent createTitle() {
        float max;
        float min = this.dataManager.get(MIN).floatValue();
        if (min == (max = this.dataManager.get(MAX).floatValue())) {
            return new TranslationTextComponent(Util.func_200697_a((String)"ability.condition", (ResourceLocation)this.type.getRegistryName()) + "_at" + ((Boolean)this.dataManager.get(INVERT) != false ? ".not" : ""), new Object[]{Float.valueOf(min)});
        }
        if (max != 2.1474836E9f) {
            return new TranslationTextComponent(Util.func_200697_a((String)"ability.condition", (ResourceLocation)this.type.getRegistryName()) + ((Boolean)this.dataManager.get(INVERT) != false ? ".not" : ""), new Object[]{Float.valueOf(min), Float.valueOf(max)});
        }
        return new TranslationTextComponent(Util.func_200697_a((String)"ability.condition", (ResourceLocation)this.type.getRegistryName()) + "_min" + ((Boolean)this.dataManager.get(INVERT) != false ? ".not" : ""), new Object[]{Float.valueOf(min)});
    }
}

