/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.ability.container;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.threetag.threecore.ability.container.DefaultAbilityContainer;
import net.threetag.threecore.ability.container.IAbilityContainer;
import net.threetag.threecore.ability.container.SuperpowerAbilityContainer;

public class AbilityContainerTypes {
    private static final Map<Class<? extends IAbilityContainer>, ResourceLocation> CLASSES = Maps.newHashMap();
    private static final Map<ResourceLocation, BiFunction<CompoundNBT, Boolean, IAbilityContainer>> DESERIALIZER = Maps.newHashMap();

    public static void registerType(ResourceLocation id, Class<? extends IAbilityContainer> clazz, BiFunction<CompoundNBT, Boolean, IAbilityContainer> deserializer) {
        DESERIALIZER.put(id, deserializer);
        CLASSES.put(clazz, id);
    }

    public static IAbilityContainer deserialize(CompoundNBT nbt, boolean network) {
        ResourceLocation id;
        BiFunction<CompoundNBT, Boolean, IAbilityContainer> deserializer;
        if (nbt.func_74764_b("Type") && (deserializer = DESERIALIZER.get(id = new ResourceLocation(nbt.func_74779_i("Type")))) != null) {
            return deserializer.apply(nbt, network);
        }
        return null;
    }

    public static ResourceLocation getTypeId(Class<? extends IAbilityContainer> clazz) {
        return CLASSES.get(clazz);
    }

    static {
        AbilityContainerTypes.registerType(new ResourceLocation("threecore", "default"), DefaultAbilityContainer.class, DefaultAbilityContainer::new);
        AbilityContainerTypes.registerType(new ResourceLocation("threecore", "superpower"), SuperpowerAbilityContainer.class, SuperpowerAbilityContainer::new);
    }
}

