/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.ability.container;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.threetag.threecore.ability.Ability;
import net.threetag.threecore.ability.AbilityHelper;
import net.threetag.threecore.ability.AbilityMap;
import net.threetag.threecore.ability.container.AbilityContainerTypes;
import net.threetag.threecore.ability.container.IAbilityContainer;
import net.threetag.threecore.util.icon.IIcon;
import net.threetag.threecore.util.icon.IconSerializer;
import net.threetag.threecore.util.threedata.EnumSync;

public class DefaultAbilityContainer
implements IAbilityContainer,
INBTSerializable<CompoundNBT> {
    protected final AbilityMap abilityMap = new AbilityMap();
    protected ResourceLocation id;
    protected ITextComponent title;
    protected IIcon icon;
    private int lifetime = -1;
    private int maxLifetime = -1;

    public DefaultAbilityContainer(ResourceLocation id, ITextComponent title, IIcon icon, int lifetime) {
        this.id = id;
        this.title = title;
        this.icon = icon;
        this.lifetime = this.maxLifetime = lifetime;
    }

    public DefaultAbilityContainer(CompoundNBT nbt, boolean network) {
        if (network) {
            this.readUpdateTag(nbt);
        } else {
            this.deserializeNBT(nbt);
        }
    }

    @Override
    public void tick(LivingEntity entity) {
        this.getAbilityMap().forEach((s, a) -> {
            a.container = this;
            a.tick(entity);
            if (a.sync != EnumSync.NONE) {
                this.onUpdated(entity, (Ability)a, a.sync);
                a.sync = EnumSync.NONE;
            }
        });
        if (this.lifetime > 0) {
            --this.lifetime;
        }
    }

    @Override
    public AbilityMap getAbilityMap() {
        return this.abilityMap;
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public ITextComponent getTitle() {
        return this.title;
    }

    @Override
    public ITextComponent getSubtitle() {
        if (this.lifetime >= 0) {
            return new StringTextComponent(StringUtils.func_76337_a((int)this.lifetime));
        }
        return null;
    }

    @Override
    public IIcon getIcon() {
        return this.icon;
    }

    @Override
    public CompoundNBT getNbtTag(@Nonnull LivingEntity entity) {
        return entity.getPersistentData();
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull LivingEntity entity, @Nonnull Capability<T> cap, @Nullable Direction side) {
        return entity.getCapability(cap, side);
    }

    @Override
    public boolean isObsolete() {
        return this.lifetime == 0;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("Type", AbilityContainerTypes.getTypeId(this.getClass()).toString());
        nbt.func_74778_a("ID", this.id.toString());
        nbt.func_74778_a("Title", ITextComponent.Serializer.func_150696_a((ITextComponent)this.title));
        nbt.func_218657_a("Icon", (INBT)this.icon.getSerializer().serializeExt(this.icon));
        nbt.func_218657_a("Abilities", (INBT)AbilityHelper.saveToNBT(this.getAbilityMap()));
        nbt.func_74768_a("Lifetime", this.lifetime);
        nbt.func_74768_a("MaxLifetime", this.maxLifetime);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.id = new ResourceLocation(nbt.func_74779_i("ID"));
        this.title = ITextComponent.Serializer.func_240643_a_((String)nbt.func_74779_i("Title"));
        this.icon = IconSerializer.deserialize(nbt.func_74775_l("Icon"));
        this.abilityMap.clear();
        AbilityHelper.loadFromNBT(nbt.func_74775_l("Abilities"), this.abilityMap);
        this.lifetime = nbt.func_74762_e("Lifetime");
        this.maxLifetime = nbt.func_74762_e("MaxLifetime");
    }

    public CompoundNBT getUpdateTag() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("ID", this.id.toString());
        nbt.func_74778_a("Title", ITextComponent.Serializer.func_150696_a((ITextComponent)this.title));
        nbt.func_218657_a("Icon", (INBT)this.icon.getSerializer().serializeExt(this.icon));
        nbt.func_218657_a("Abilities", (INBT)AbilityHelper.saveToNBT(this.getAbilityMap(), true));
        nbt.func_74768_a("Lifetime", this.lifetime);
        nbt.func_74768_a("MaxLifetime", this.maxLifetime);
        return nbt;
    }

    public void readUpdateTag(CompoundNBT nbt) {
        this.id = new ResourceLocation(nbt.func_74779_i("ID"));
        this.title = ITextComponent.Serializer.func_240643_a_((String)nbt.func_74779_i("Title"));
        this.icon = IconSerializer.deserialize(nbt.func_74775_l("Icon"));
        this.abilityMap.clear();
        AbilityHelper.loadFromNBT(nbt.func_74775_l("Abilities"), this.abilityMap, true);
        this.lifetime = nbt.func_74762_e("Lifetime");
        this.maxLifetime = nbt.func_74762_e("MaxLifetime");
    }

    public int getLifetime() {
        return this.lifetime;
    }

    public int getMaxLifetime() {
        return this.maxLifetime;
    }
}

