/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.ability.container;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.PacketDistributor;
import net.threetag.threecore.ThreeCore;
import net.threetag.threecore.ability.Ability;
import net.threetag.threecore.ability.AbilityMap;
import net.threetag.threecore.ability.IAbilityProvider;
import net.threetag.threecore.network.AddAbilityMessage;
import net.threetag.threecore.network.RemoveAbilityMessage;
import net.threetag.threecore.network.UpdateAbilityMessage;
import net.threetag.threecore.util.icon.IIcon;
import net.threetag.threecore.util.threedata.EnumSync;

public interface IAbilityContainer {
    default public void tick(LivingEntity entity) {
        this.getAbilityMap().forEach((s, a) -> {
            a.container = this;
            a.tick(entity);
            if (a.sync != EnumSync.NONE) {
                this.onUpdated(entity, (Ability)a, a.sync);
                a.sync = EnumSync.NONE;
            }
        });
    }

    default public void onUpdated(LivingEntity entity, Ability ability, EnumSync sync) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (sync != EnumSync.NONE && entity instanceof ServerPlayerEntity) {
            ThreeCore.NETWORK_CHANNEL.sendTo((Object)new UpdateAbilityMessage(entity.func_145782_y(), this.getId(), ability.getId(), ability.getUpdateTag()), ((ServerPlayerEntity)entity).field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
        }
        if (sync == EnumSync.EVERYONE && entity.field_70170_p instanceof ServerWorld) {
            ThreeCore.NETWORK_CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new UpdateAbilityMessage(entity.func_145782_y(), this.getId(), ability.getId(), ability.getUpdateTag()));
        }
    }

    default public Collection<Ability> getAbilities() {
        return this.getAbilityMap().values();
    }

    default public Ability getAbility(String id) {
        return (Ability)this.getAbilityMap().get(id);
    }

    public AbilityMap getAbilityMap();

    default public void addAbilities(@Nullable LivingEntity entity, IAbilityProvider provider) {
        provider.getAbilities().forEach((s, a) -> this.addAbility(entity, (String)s, (Ability)a));
    }

    default public boolean addAbility(@Nullable LivingEntity entity, String id, Ability ability) {
        if (this.getAbilityMap().containsKey(id)) {
            return false;
        }
        this.getAbilityMap().put(id, ability);
        if (entity != null && entity.field_70170_p instanceof ServerWorld) {
            ThreeCore.NETWORK_CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new AddAbilityMessage(entity.func_145782_y(), this.getId(), id, ability.getUpdateTag()));
        }
        return true;
    }

    default public boolean removeAbility(@Nullable LivingEntity entity, String id) {
        if (!this.getAbilityMap().containsKey(id)) {
            return false;
        }
        ((Ability)this.getAbilityMap().get(id)).lastTick(entity);
        this.getAbilityMap().remove(id);
        if (entity != null && entity.field_70170_p instanceof ServerWorld) {
            ThreeCore.NETWORK_CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new RemoveAbilityMessage(entity.func_145782_y(), this.getId(), id));
        }
        return true;
    }

    default public void clearAbilities(@Nullable LivingEntity entity) {
        ArrayList<Ability> copy = new ArrayList<Ability>(this.getAbilities());
        for (Ability ab : copy) {
            this.removeAbility(entity, ab.getId());
        }
    }

    default public void clearAbilities(@Nullable LivingEntity entity, Predicate<Ability> predicate) {
        ArrayList<Ability> copy = new ArrayList<Ability>(this.getAbilities());
        for (Ability ab : copy) {
            if (!predicate.test(ab)) continue;
            this.removeAbility(entity, ab.getId());
        }
    }

    public ResourceLocation getId();

    public ITextComponent getTitle();

    default public ITextComponent getSubtitle() {
        return null;
    }

    public IIcon getIcon();

    public CompoundNBT getNbtTag(@Nonnull LivingEntity var1);

    @Nonnull
    default public <T> LazyOptional<T> getCapability(@Nonnull LivingEntity entity, @Nonnull Capability<T> cap, @Nullable Direction side) {
        return LazyOptional.empty();
    }

    default public boolean isObsolete() {
        return false;
    }
}

