/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.accessoires;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import net.threetag.threecore.accessoires.AccessoireSlot;
import net.threetag.threecore.util.SupporterHandler;

@Mod.EventBusSubscriber(modid="threecore", bus=Mod.EventBusSubscriber.Bus.MOD)
public abstract class Accessoire
extends ForgeRegistryEntry<Accessoire> {
    public static IForgeRegistry<Accessoire> REGISTRY;

    @SubscribeEvent
    public static void onRegisterNewRegistries(RegistryEvent.NewRegistry e) {
        REGISTRY = new RegistryBuilder().setName(new ResourceLocation("threecore", "accessoires")).setType(Accessoire.class).setIDRange(0, 512).create();
    }

    public boolean isAvailable(PlayerEntity entity) {
        return SupporterHandler.getPlayerData(entity.func_110124_au()).hasAccessoire(this);
    }

    public ITextComponent getDisplayName() {
        return new TranslationTextComponent(Util.func_200697_a((String)"accessoire", (ResourceLocation)this.getRegistryName()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(PlayerRenderer renderer, AccessoireSlot slot, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, AbstractClientPlayerEntity player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isVisible(AccessoireSlot slot, AbstractClientPlayerEntity player) {
        return slot.getCorrespondingEquipmentSlot() == null || player.func_184582_a(slot.getCorrespondingEquipmentSlot()).func_190926_b();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ModelRenderer getArm(PlayerModel<?> model, boolean mainHand, HandSide primaryHand) {
        if (mainHand) {
            return primaryHand == HandSide.RIGHT ? model.field_178723_h : model.field_178724_i;
        }
        return primaryHand == HandSide.RIGHT ? model.field_178724_i : model.field_178723_h;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public RenderType getRenderType(AbstractClientPlayerEntity player, ResourceLocation resourceLocation, Model model) {
        boolean flag1;
        boolean flag = !player.func_82150_aj();
        boolean bl = flag1 = !flag && !player.func_98034_c((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
        if (flag1) {
            return RenderType.func_228644_e_((ResourceLocation)resourceLocation);
        }
        if (flag) {
            return model.func_228282_a_(resourceLocation);
        }
        return player.func_225510_bt_() ? RenderType.func_228654_j_((ResourceLocation)resourceLocation) : null;
    }

    public abstract Collection<AccessoireSlot> getPossibleSlots();

    public static List<Accessoire> getAvailableAccessoires(SupporterHandler.PlayerData data, AccessoireSlot slot) {
        ArrayList<Accessoire> list = new ArrayList<Accessoire>();
        for (Accessoire accessoire : REGISTRY) {
            if (!accessoire.getPossibleSlots().contains(slot) || !data.hasAccessoire(accessoire)) continue;
            list.add(accessoire);
        }
        return list;
    }
}

