/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.accessoires;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AccessoireSlot {
    private static final List<AccessoireSlot> SLOTS = Lists.newArrayList();
    public static final AccessoireSlot HAT = AccessoireSlot.register("hat").setIcon(new ResourceLocation("threecore", "textures/gui/accessoire_slots/hat.png")).setCorrespondingEquipmentSlot(EquipmentSlotType.HEAD);
    public static final AccessoireSlot HEAD = AccessoireSlot.register("head").setIcon(new ResourceLocation("threecore", "textures/gui/accessoire_slots/head.png"));
    public static final AccessoireSlot FACE = AccessoireSlot.register("face").setIcon(new ResourceLocation("threecore", "textures/gui/accessoire_slots/face.png"));
    public static final AccessoireSlot CHEST = AccessoireSlot.register("chest").setIcon(new ResourceLocation("threecore", "textures/gui/accessoire_slots/chest.png"));
    public static final AccessoireSlot BACK = AccessoireSlot.register("back").setIcon(new ResourceLocation("threecore", "textures/gui/accessoire_slots/back.png"));
    public static final AccessoireSlot MAIN_ARM = AccessoireSlot.register("main_arm").setIcon(new ResourceLocation("threecore", "textures/gui/accessoire_slots/main_arm.png"));
    public static final AccessoireSlot OFF_ARM = AccessoireSlot.register("off_arm").setIcon(new ResourceLocation("threecore", "textures/gui/accessoire_slots/off_arm.png"));
    public static final AccessoireSlot MAIN_HAND = AccessoireSlot.register("main_hand").setIcon(new ResourceLocation("threecore", "textures/gui/accessoire_slots/main_hand.png")).setCorrespondingEquipmentSlot(EquipmentSlotType.MAINHAND);
    public static final AccessoireSlot OFF_HAND = AccessoireSlot.register("off_hand").setIcon(new ResourceLocation("threecore", "textures/gui/accessoire_slots/off_hand.png")).setCorrespondingEquipmentSlot(EquipmentSlotType.OFFHAND);
    public static final AccessoireSlot RIGHT_LEG = AccessoireSlot.register("right_leg").setIcon(new ResourceLocation("threecore", "textures/gui/accessoire_slots/right_leg.png"));
    public static final AccessoireSlot LEFT_LEG = AccessoireSlot.register("left_leg").setIcon(new ResourceLocation("threecore", "textures/gui/accessoire_slots/left_leg.png"));
    public static final AccessoireSlot SPECIAL = AccessoireSlot.register("special").setIcon(new ResourceLocation("threecore", "textures/gui/accessoire_slots/special.png")).allowMultiple();
    private final String name;
    private boolean multiple = false;
    private EquipmentSlotType equipmentSlot;
    private ResourceLocation icon;

    public AccessoireSlot(String name) {
        this.name = name;
    }

    public AccessoireSlot allowMultiple() {
        this.multiple = true;
        return this;
    }

    public AccessoireSlot setCorrespondingEquipmentSlot(EquipmentSlotType slot) {
        this.equipmentSlot = slot;
        return this;
    }

    public AccessoireSlot setIcon(ResourceLocation icon) {
        this.icon = icon;
        return this;
    }

    public EquipmentSlotType getCorrespondingEquipmentSlot() {
        return this.equipmentSlot;
    }

    public String getName() {
        return this.name;
    }

    public ITextComponent getDisplayName() {
        return new TranslationTextComponent("accessoire_slot." + this.name);
    }

    public boolean allowsMultiple() {
        return this.multiple;
    }

    public ResourceLocation getIcon() {
        return this.icon;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setVisibility(PlayerModel model, PlayerEntity player, boolean visible) {
        if (this == HEAD) {
            model.field_78116_c.field_78806_j = model.field_178730_v.field_78806_j = visible;
        } else if (this == CHEST) {
            model.field_78115_e.field_78806_j = model.field_178730_v.field_78806_j = visible;
        } else if (this == MAIN_ARM) {
            if (player.func_184591_cq() == HandSide.RIGHT) {
                model.field_178723_h.field_78806_j = model.field_178732_b.field_78806_j = visible;
            } else {
                model.field_178724_i.field_78806_j = model.field_178734_a.field_78806_j = visible;
            }
        } else if (this == OFF_ARM) {
            if (player.func_184591_cq() == HandSide.RIGHT) {
                model.field_178724_i.field_78806_j = model.field_178734_a.field_78806_j = visible;
            } else {
                model.field_178723_h.field_78806_j = model.field_178732_b.field_78806_j = visible;
            }
        } else if (this == RIGHT_LEG) {
            model.field_178721_j.field_78806_j = model.field_178731_d.field_78806_j = visible;
        } else if (this == LEFT_LEG) {
            model.field_178722_k.field_78806_j = model.field_178733_c.field_78806_j = visible;
        }
    }

    public static AccessoireSlot register(String name) {
        AccessoireSlot slot = new AccessoireSlot(name);
        SLOTS.add(slot);
        return slot;
    }

    @Nullable
    public static AccessoireSlot getSlotByName(String name) {
        for (AccessoireSlot slot : SLOTS) {
            if (!slot.getName().equals(name)) continue;
            return slot;
        }
        return null;
    }

    public static List<AccessoireSlot> getSlots() {
        return ImmutableList.copyOf(SLOTS);
    }
}

