/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.block;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.threetag.threecore.util.icon.IIcon;

public class ConstructionTableBlock
extends HorizontalBlock {
    private static Map<ResourceLocation, Tab> TABS = Maps.newLinkedHashMap();
    public static VoxelShape SHAPE;
    private static final ITextComponent TITLE;

    public static void registerTab(ResourceLocation id, Tab tab) {
        TABS.put(id, tab);
    }

    public static Map<ResourceLocation, Tab> getTabs() {
        return TABS;
    }

    public static INamedContainerProvider getContainerProvider(World world, BlockPos pos, Tab tab) {
        return new SimpleNamedContainerProvider((id, playerInventory, p) -> tab.provider.createMenu(id, playerInventory, p, world, pos), TITLE);
    }

    protected ConstructionTableBlock(AbstractBlock.Properties builder) {
        super(builder);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH));
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)context.func_195992_f().func_176734_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_185512_D});
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        player.func_213829_a(state.func_215699_b(worldIn, pos));
        return ActionResultType.SUCCESS;
    }

    public INamedContainerProvider func_220052_b(BlockState state, World worldIn, BlockPos pos) {
        return TABS.size() == 0 ? null : ConstructionTableBlock.getContainerProvider(worldIn, pos, TABS.values().iterator().next());
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public VoxelShape func_199600_g(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return VoxelShapes.func_197868_b();
    }

    static {
        TITLE = new TranslationTextComponent(Util.func_200697_a((String)"container", (ResourceLocation)new ResourceLocation("threecore", "construction_table")));
        SHAPE = Stream.of(Block.func_208617_a((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0), Block.func_208617_a((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0), Block.func_208617_a((double)14.0, (double)0.0, (double)1.0, (double)15.0, (double)13.0, (double)2.0), Block.func_208617_a((double)14.0, (double)0.0, (double)14.0, (double)15.0, (double)13.0, (double)15.0), Block.func_208617_a((double)1.0, (double)0.0, (double)14.0, (double)2.0, (double)13.0, (double)15.0), Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)2.0, (double)13.0, (double)2.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    }

    public static interface IConstructionTableContainerProvider {
        @Nullable
        public Container createMenu(int var1, PlayerInventory var2, PlayerEntity var3, World var4, BlockPos var5);
    }

    public static class Tab {
        public final Supplier<ContainerType> containerType;
        public final IConstructionTableContainerProvider provider;
        public final IIcon icon;

        public Tab(Supplier<ContainerType> containerType, IConstructionTableContainerProvider provider, IIcon icon) {
            this.containerType = containerType;
            this.provider = provider;
            this.icon = icon;
        }
    }
}

