/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.capability;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.threetag.threecore.ThreeCore;
import net.threetag.threecore.accessoires.Accessoire;
import net.threetag.threecore.accessoires.AccessoireSlot;
import net.threetag.threecore.capability.IAccessoireHolder;
import net.threetag.threecore.network.SyncAccessoiresMessage;

public class CapabilityAccessoires
implements IAccessoireHolder,
INBTSerializable<CompoundNBT> {
    @CapabilityInject(value=IAccessoireHolder.class)
    public static Capability<IAccessoireHolder> ACCESSOIRES;
    public Map<AccessoireSlot, Collection<Accessoire>> accessoires = new HashMap<AccessoireSlot, Collection<Accessoire>>();

    @Override
    public void enable(AccessoireSlot slot, Accessoire accessoire, PlayerEntity player) {
        if (slot != null && accessoire != null && accessoire.getPossibleSlots().contains(slot) && this.canEnable(accessoire, player)) {
            if (slot.allowsMultiple()) {
                Collection<Accessoire> accessoires = this.getOrCreateSlotList(slot);
                if (!accessoires.contains((Object)accessoire)) {
                    accessoires.add(accessoire);
                }
            } else {
                this.accessoires.put(slot, Collections.singletonList(accessoire));
            }
            if (!player.field_70170_p.field_72995_K) {
                ThreeCore.NETWORK_CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new SyncAccessoiresMessage(player.func_145782_y(), this.getSlots()));
            }
        }
    }

    public boolean canEnable(Accessoire accessoire, PlayerEntity player) {
        return EffectiveSide.get().isClient() || accessoire.isAvailable(player);
    }

    @Override
    public void disable(AccessoireSlot slot, @Nullable Accessoire accessoire, PlayerEntity player) {
        if (slot != null && accessoire != null) {
            if (slot.allowsMultiple()) {
                if (accessoire == null) {
                    this.accessoires.put(slot, new ArrayList());
                } else {
                    Collection<Accessoire> accessoires = this.getOrCreateSlotList(slot);
                    accessoires.remove((Object)accessoire);
                }
            } else {
                this.accessoires.put(slot, new ArrayList());
            }
            if (!player.field_70170_p.field_72995_K) {
                ThreeCore.NETWORK_CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new SyncAccessoiresMessage(player.func_145782_y(), this.getSlots()));
            }
        }
    }

    @Override
    public void validate(PlayerEntity player) {
        ArrayList disable = new ArrayList();
        this.accessoires.forEach((slot, accessoires) -> {
            for (Accessoire accessoire : accessoires) {
                if (this.canEnable(accessoire, player)) continue;
                disable.add(Pair.of((Object)slot, (Object)((Object)accessoire)));
            }
        });
        for (Pair pair : disable) {
            this.disable((AccessoireSlot)pair.getFirst(), (Accessoire)((Object)pair.getSecond()), player);
        }
    }

    public Collection<Accessoire> getOrCreateSlotList(AccessoireSlot slot) {
        Collection<Accessoire> accessoires = this.accessoires.get(slot);
        if (slot != null) {
            return accessoires;
        }
        accessoires = new ArrayList<Accessoire>();
        this.accessoires.put(slot, accessoires);
        return accessoires;
    }

    @Override
    public void clear(PlayerEntity player) {
        this.accessoires.clear();
        for (AccessoireSlot slot : AccessoireSlot.getSlots()) {
            this.accessoires.put(slot, new ArrayList());
        }
        if (!player.field_70170_p.field_72995_K) {
            ThreeCore.NETWORK_CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new SyncAccessoiresMessage(player.func_145782_y(), this.getSlots()));
        }
    }

    @Override
    public Map<AccessoireSlot, Collection<Accessoire>> getSlots() {
        return this.accessoires;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        this.accessoires.forEach((slot, list) -> {
            ListNBT listNBT = new ListNBT();
            for (Accessoire accessoire : list) {
                listNBT.add((Object)StringNBT.func_229705_a_((String)Accessoire.REGISTRY.getKey((IForgeRegistryEntry)accessoire).toString()));
            }
            nbt.func_218657_a(slot.getName(), (INBT)listNBT);
        });
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.accessoires = new HashMap<AccessoireSlot, Collection<Accessoire>>();
        for (AccessoireSlot slot : AccessoireSlot.getSlots()) {
            ListNBT listNBT = nbt.func_150295_c(slot.getName(), 8);
            ArrayList<Accessoire> accessoires = new ArrayList<Accessoire>();
            for (int i = 0; i < listNBT.size(); ++i) {
                Accessoire accessoire = (Accessoire)Accessoire.REGISTRY.getValue(new ResourceLocation(listNBT.func_150307_f(i)));
                if (accessoire == null) continue;
                accessoires.add(accessoire);
            }
            this.accessoires.put(slot, accessoires);
        }
    }
}

