/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.capability;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.fml.network.NetworkDirection;
import net.threetag.threecore.ThreeCore;
import net.threetag.threecore.karma.IKarma;
import net.threetag.threecore.network.KarmaInfoMessage;
import net.threetag.threecore.network.SyncKarmaMessage;

public class CapabilityKarma
implements IKarma {
    @CapabilityInject(value=IKarma.class)
    public static Capability<IKarma> KARMA;
    public static final int MAX = 1000;
    public static final int MIN = -1000;
    protected int karma;

    @Override
    public int getKarma() {
        return MathHelper.func_76125_a((int)this.karma, (int)-1000, (int)1000);
    }

    @Override
    public void setKarma(int karma) {
        this.karma = MathHelper.func_76125_a((int)karma, (int)-1000, (int)1000);
    }

    public static void setKarma(PlayerEntity player, int karma) {
        player.getCapability(KARMA).ifPresent(k -> {
            k.setKarma(karma);
            if (player instanceof ServerPlayerEntity) {
                ThreeCore.NETWORK_CHANNEL.sendTo((Object)new SyncKarmaMessage(player.func_145782_y(), k.getKarma()), ((ServerPlayerEntity)player).field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
            }
        });
    }

    public static void addKarma(PlayerEntity player, int karma) {
        CapabilityKarma.addKarma(player, karma, true);
    }

    public static void addKarma(PlayerEntity player, int karma, boolean toast) {
        player.getCapability(KARMA).ifPresent(k -> {
            k.setKarma(k.getKarma() + karma);
            if (player instanceof ServerPlayerEntity) {
                ThreeCore.NETWORK_CHANNEL.sendTo((Object)new SyncKarmaMessage(player.func_145782_y(), k.getKarma()), ((ServerPlayerEntity)player).field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
                if (toast) {
                    ThreeCore.NETWORK_CHANNEL.sendTo((Object)new KarmaInfoMessage(karma), ((ServerPlayerEntity)player).field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
                }
            }
        });
    }
}

