/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.capability;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.PacketDistributor;
import net.threetag.threecore.ThreeCore;
import net.threetag.threecore.event.RegisterThreeDataEvent;
import net.threetag.threecore.network.UpdateThreeDataMessage;
import net.threetag.threecore.util.threedata.EnumSync;
import net.threetag.threecore.util.threedata.IThreeDataHolder;
import net.threetag.threecore.util.threedata.IWrappedThreeDataHolder;
import net.threetag.threecore.util.threedata.ThreeData;
import net.threetag.threecore.util.threedata.ThreeDataManager;

public class CapabilityThreeData
implements IWrappedThreeDataHolder,
INBTSerializable<CompoundNBT> {
    @CapabilityInject(value=IThreeDataHolder.class)
    public static Capability<IThreeDataHolder> THREE_DATA;
    public final ThreeDataManager dataManager;
    public final Entity entity;

    public CapabilityThreeData(Entity entity) {
        this.entity = entity;
        this.dataManager = new ThreeDataManager().setListener(new ThreeDataManager.Listener(){

            @Override
            public <T> void dataChanged(ThreeData<T> data, T oldValue, T value) {
                CapabilityThreeData.this.update(data, value);
            }
        });
        MinecraftForge.EVENT_BUS.post((Event)new RegisterThreeDataEvent(entity, this));
    }

    @Override
    public IThreeDataHolder getThreeDataHolder() {
        return this.dataManager;
    }

    public <T> void update(ThreeData<T> data, T value) {
        if (this.entity.field_70170_p.field_72995_K) {
            return;
        }
        CompoundNBT nbt = new CompoundNBT();
        data.writeToNBT(nbt, value);
        if (data.getSyncType() != EnumSync.NONE && this.entity instanceof ServerPlayerEntity) {
            ThreeCore.NETWORK_CHANNEL.sendTo((Object)new UpdateThreeDataMessage(this.entity.func_145782_y(), data.getKey(), nbt), ((ServerPlayerEntity)this.entity).field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
        }
        if (data.getSyncType() == EnumSync.EVERYONE && this.entity.field_70170_p instanceof ServerWorld) {
            ThreeCore.NETWORK_CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> this.entity), (Object)new UpdateThreeDataMessage(this.entity.func_145782_y(), data.getKey(), nbt));
        }
    }

    public CompoundNBT serializeNBT() {
        return this.dataManager.serializeNBT();
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.dataManager.deserializeNBT(nbt);
    }
}

