/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.capability;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.threetag.threecore.ability.AbilityHelper;
import net.threetag.threecore.ability.container.IAbilityContainer;
import net.threetag.threecore.capability.CapabilityAbilityContainer;
import net.threetag.threecore.capability.ItemAbilityContainer;

public class ItemAbilityContainerProvider
implements ICapabilitySerializable<CompoundNBT> {
    public final ItemStack stack;
    public final IAbilityContainer abilityContainer;
    public LazyOptional<IAbilityContainer> lazyOptional;

    public ItemAbilityContainerProvider(ItemStack stack) {
        this.stack = stack;
        this.abilityContainer = new ItemAbilityContainer(stack);
        this.lazyOptional = LazyOptional.of(() -> this.abilityContainer);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return cap == CapabilityAbilityContainer.ABILITY_CONTAINER ? this.lazyOptional : LazyOptional.empty();
    }

    public CompoundNBT serializeNBT() {
        return AbilityHelper.saveToNBT(this.abilityContainer.getAbilityMap());
    }

    public void deserializeNBT(CompoundNBT nbt) {
        AbilityHelper.loadFromNBT(nbt, this.abilityContainer.getAbilityMap());
    }
}

