/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.capability;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.threetag.threecore.capability.CapabilityAbilityContainer;
import net.threetag.threecore.capability.IMultiAbilityContainer;

public class MultiAbilityContainerProvider
implements ICapabilitySerializable<CompoundNBT> {
    public final IMultiAbilityContainer container;
    public final LazyOptional<IMultiAbilityContainer> lazyOptional;

    public MultiAbilityContainerProvider(IMultiAbilityContainer container) {
        this.container = container;
        this.lazyOptional = LazyOptional.of(() -> container);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return cap == CapabilityAbilityContainer.MULTI_ABILITY_CONTAINER ? this.lazyOptional : LazyOptional.empty();
    }

    public CompoundNBT serializeNBT() {
        if (this.container instanceof INBTSerializable) {
            return (CompoundNBT)((INBTSerializable)this.container).serializeNBT();
        }
        return new CompoundNBT();
    }

    public void deserializeNBT(CompoundNBT nbt) {
        if (this.container instanceof INBTSerializable) {
            ((INBTSerializable)this.container).deserializeNBT((INBT)nbt);
        }
    }
}

