/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.capability;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.EnderCrystalEntity;
import net.minecraft.entity.item.HangingEntity;
import net.minecraft.entity.monster.ShulkerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.NetworkDirection;
import net.threetag.threecore.ThreeCore;
import net.threetag.threecore.ability.container.IAbilityContainer;
import net.threetag.threecore.capability.AccessoireCapProvider;
import net.threetag.threecore.capability.CapabilityAbilityContainer;
import net.threetag.threecore.capability.CapabilityAccessoires;
import net.threetag.threecore.capability.CapabilityKarma;
import net.threetag.threecore.capability.CapabilitySizeChanging;
import net.threetag.threecore.capability.CapabilityThreeData;
import net.threetag.threecore.capability.IAccessoireHolder;
import net.threetag.threecore.capability.IMultiAbilityContainer;
import net.threetag.threecore.capability.ISizeChanging;
import net.threetag.threecore.capability.ItemAbilityContainer;
import net.threetag.threecore.capability.KarmaCapProvider;
import net.threetag.threecore.capability.MultiAbilityContainerProvider;
import net.threetag.threecore.capability.SizeChangingProvider;
import net.threetag.threecore.capability.ThreeDataProvider;
import net.threetag.threecore.karma.IKarma;
import net.threetag.threecore.network.SyncAccessoiresMessage;
import net.threetag.threecore.util.threedata.IThreeDataHolder;

@Mod.EventBusSubscriber(modid="threecore")
public class ThreeCoreCapabilities {
    public static void init() {
        CapabilityManager.INSTANCE.register(IAbilityContainer.class, (Capability.IStorage)new Capability.IStorage<IAbilityContainer>(){

            @Nullable
            public INBT writeNBT(Capability<IAbilityContainer> capability, IAbilityContainer instance, Direction direction) {
                if (instance instanceof INBTSerializable) {
                    return ((INBTSerializable)instance).serializeNBT();
                }
                throw new IllegalArgumentException("Can not serialize an instance that isn't an instance of INBTSerializable");
            }

            public void readNBT(Capability<IAbilityContainer> capability, IAbilityContainer instance, Direction direction, INBT nbt) {
                if (!(instance instanceof INBTSerializable)) {
                    throw new IllegalArgumentException("Can not serialize to an instance that isn't an instance of INBTSerializable");
                }
                ((INBTSerializable)instance).deserializeNBT(nbt);
            }
        }, () -> new ItemAbilityContainer(ItemStack.field_190927_a));
        CapabilityManager.INSTANCE.register(IMultiAbilityContainer.class, (Capability.IStorage)new Capability.IStorage<IMultiAbilityContainer>(){

            @Nullable
            public INBT writeNBT(Capability<IMultiAbilityContainer> capability, IMultiAbilityContainer instance, Direction direction) {
                if (instance instanceof INBTSerializable) {
                    return ((INBTSerializable)instance).serializeNBT();
                }
                throw new IllegalArgumentException("Can not serialize an instance that isn't an instance of INBTSerializable");
            }

            public void readNBT(Capability<IMultiAbilityContainer> capability, IMultiAbilityContainer instance, Direction direction, INBT nbt) {
                if (!(instance instanceof INBTSerializable)) {
                    throw new IllegalArgumentException("Can not serialize to an instance that isn't an instance of INBTSerializable");
                }
                ((INBTSerializable)instance).deserializeNBT(nbt);
            }
        }, CapabilityAbilityContainer::new);
        CapabilityManager.INSTANCE.register(IKarma.class, (Capability.IStorage)new Capability.IStorage<IKarma>(){

            @Nullable
            public INBT writeNBT(Capability<IKarma> capability, IKarma instance, Direction side) {
                return IntNBT.func_229692_a_((int)instance.getKarma());
            }

            public void readNBT(Capability<IKarma> capability, IKarma instance, Direction side, INBT nbt) {
                instance.setKarma(((IntNBT)nbt).func_150287_d());
            }
        }, CapabilityKarma::new);
        CapabilityManager.INSTANCE.register(ISizeChanging.class, (Capability.IStorage)new Capability.IStorage<ISizeChanging>(){

            @Nullable
            public INBT writeNBT(Capability<ISizeChanging> capability, ISizeChanging instance, Direction side) {
                if (instance instanceof INBTSerializable) {
                    return ((INBTSerializable)instance).serializeNBT();
                }
                throw new IllegalArgumentException("Can not serialize an instance that isn't an instance of INBTSerializable");
            }

            public void readNBT(Capability<ISizeChanging> capability, ISizeChanging instance, Direction side, INBT nbt) {
                if (!(instance instanceof INBTSerializable)) {
                    throw new IllegalArgumentException("Can not serialize to an instance that isn't an instance of INBTSerializable");
                }
                ((INBTSerializable)instance).deserializeNBT(nbt);
            }
        }, () -> new CapabilitySizeChanging(null));
        CapabilityManager.INSTANCE.register(IThreeDataHolder.class, (Capability.IStorage)new Capability.IStorage<IThreeDataHolder>(){

            @Nullable
            public INBT writeNBT(Capability<IThreeDataHolder> capability, IThreeDataHolder instance, Direction direction) {
                if (instance instanceof INBTSerializable) {
                    return ((INBTSerializable)instance).serializeNBT();
                }
                throw new IllegalArgumentException("Can not serialize an instance that isn't an instance of INBTSerializable");
            }

            public void readNBT(Capability<IThreeDataHolder> capability, IThreeDataHolder instance, Direction direction, INBT nbt) {
                if (!(instance instanceof INBTSerializable)) {
                    throw new IllegalArgumentException("Can not serialize to an instance that isn't an instance of INBTSerializable");
                }
                ((INBTSerializable)instance).deserializeNBT(nbt);
            }
        }, () -> new CapabilityThreeData(null));
        CapabilityManager.INSTANCE.register(IAccessoireHolder.class, (Capability.IStorage)new Capability.IStorage<IAccessoireHolder>(){

            @Nullable
            public INBT writeNBT(Capability<IAccessoireHolder> capability, IAccessoireHolder instance, Direction side) {
                if (instance instanceof INBTSerializable) {
                    return ((INBTSerializable)instance).serializeNBT();
                }
                throw new IllegalArgumentException("Can not serialize an instance that isn't an instance of INBTSerializable");
            }

            public void readNBT(Capability<IAccessoireHolder> capability, IAccessoireHolder instance, Direction side, INBT nbt) {
                if (!(instance instanceof INBTSerializable)) {
                    throw new IllegalArgumentException("Can not serialize to an instance that isn't an instance of INBTSerializable");
                }
                ((INBTSerializable)instance).deserializeNBT(nbt);
            }
        }, CapabilityAccessoires::new);
    }

    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> e) {
        if (e.getObject() instanceof LivingEntity && !((Entity)e.getObject()).getCapability(CapabilityAbilityContainer.MULTI_ABILITY_CONTAINER).isPresent()) {
            e.addCapability(new ResourceLocation("threecore", "multi_ability_container"), (ICapabilityProvider)new MultiAbilityContainerProvider(new CapabilityAbilityContainer()));
        }
        if (e.getObject() instanceof PlayerEntity && !((Entity)e.getObject()).getCapability(CapabilityKarma.KARMA).isPresent()) {
            e.addCapability(new ResourceLocation("threecore", "karma"), (ICapabilityProvider)new KarmaCapProvider());
        }
        if (ThreeCoreCapabilities.canSizeChange((Entity)e.getObject()) && !((Entity)e.getObject()).getCapability(CapabilitySizeChanging.SIZE_CHANGING).isPresent()) {
            e.addCapability(new ResourceLocation("threecore", "size_changing"), (ICapabilityProvider)new SizeChangingProvider(new CapabilitySizeChanging((Entity)e.getObject())));
        }
        if (!((Entity)e.getObject()).getCapability(CapabilityThreeData.THREE_DATA).isPresent()) {
            e.addCapability(new ResourceLocation("threecore", "three_data"), (ICapabilityProvider)new ThreeDataProvider(new CapabilityThreeData((Entity)e.getObject())));
        }
        if (e.getObject() instanceof PlayerEntity && !((Entity)e.getObject()).getCapability(CapabilityAccessoires.ACCESSOIRES).isPresent()) {
            e.addCapability(new ResourceLocation("threecore", "accessoires"), (ICapabilityProvider)new AccessoireCapProvider());
        }
    }

    public static boolean canSizeChange(Entity entity) {
        return !(entity instanceof HangingEntity) && !(entity instanceof ShulkerEntity) && !(entity instanceof EnderCrystalEntity);
    }

    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking e) {
        e.getTarget().getCapability(CapabilityAccessoires.ACCESSOIRES).ifPresent(accessoireHolder -> {
            if (accessoireHolder instanceof INBTSerializable && e.getPlayer() instanceof ServerPlayerEntity) {
                ThreeCore.NETWORK_CHANNEL.sendTo((Object)new SyncAccessoiresMessage(e.getTarget().func_145782_y(), accessoireHolder.getSlots()), ((ServerPlayerEntity)e.getPlayer()).field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
            }
        });
    }

    @SubscribeEvent
    public static void onJoinWorld(EntityJoinWorldEvent e) {
        e.getEntity().getCapability(CapabilityAccessoires.ACCESSOIRES).ifPresent(accessoireHolder -> {
            if (e.getEntity() instanceof ServerPlayerEntity) {
                ThreeCore.NETWORK_CHANNEL.sendTo((Object)new SyncAccessoiresMessage(e.getEntity().func_145782_y(), accessoireHolder.getSlots()), ((ServerPlayerEntity)e.getEntity()).field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
            }
        });
    }
}

