/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.capability;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.NetworkDirection;
import net.threetag.threecore.ThreeCore;
import net.threetag.threecore.capability.CapabilityThreeData;
import net.threetag.threecore.network.SyncThreeDataMessage;
import net.threetag.threecore.util.threedata.IThreeDataHolder;

public class ThreeDataProvider
implements ICapabilitySerializable<CompoundNBT> {
    public final IThreeDataHolder threeData;
    public final LazyOptional<IThreeDataHolder> lazyOptional;

    public ThreeDataProvider(IThreeDataHolder threeData) {
        this.threeData = threeData;
        this.lazyOptional = LazyOptional.of(() -> threeData);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return cap == CapabilityThreeData.THREE_DATA ? this.lazyOptional : LazyOptional.empty();
    }

    public CompoundNBT serializeNBT() {
        if (this.threeData instanceof INBTSerializable) {
            return (CompoundNBT)((INBTSerializable)this.threeData).serializeNBT();
        }
        return new CompoundNBT();
    }

    public void deserializeNBT(CompoundNBT nbt) {
        if (this.threeData instanceof INBTSerializable) {
            ((INBTSerializable)this.threeData).deserializeNBT((INBT)nbt);
        }
    }

    @Mod.EventBusSubscriber(modid="threecore")
    public static class EventHandler {
        @SubscribeEvent
        public static void onStartTracking(PlayerEvent.StartTracking e) {
            e.getTarget().getCapability(CapabilityThreeData.THREE_DATA).ifPresent(threeData -> {
                if (threeData instanceof INBTSerializable && e.getPlayer() instanceof ServerPlayerEntity) {
                    ThreeCore.NETWORK_CHANNEL.sendTo((Object)new SyncThreeDataMessage(e.getTarget().func_145782_y(), (CompoundNBT)((INBTSerializable)threeData).serializeNBT()), ((ServerPlayerEntity)e.getPlayer()).field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
                }
            });
        }
    }
}

