/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.client.renderer.entity.model;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.renderer.model.Model;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModelRegistry {
    private static Map<String, Model> MODELS = Maps.newHashMap();

    public static Model getModel(String key) {
        return MODELS.get(key);
    }

    public static Model registerModel(String key, Model model) {
        MODELS.put(key, model);
        return model;
    }

    public static Model getOrCreateModel(String key, Supplier<Model> modelSupplier) {
        if (MODELS.containsKey(key)) {
            return ModelRegistry.getModel(key);
        }
        return ModelRegistry.registerModel(key, modelSupplier.get());
    }
}

