/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.client.renderer.entity.modellayer.texture;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.threetag.threecore.ThreeCore;
import net.threetag.threecore.client.renderer.entity.modellayer.IModelLayerContext;
import net.threetag.threecore.client.renderer.entity.modellayer.ModelLayerManager;
import net.threetag.threecore.client.renderer.entity.modellayer.texture.DefaultModelTexture;
import net.threetag.threecore.client.renderer.entity.modellayer.texture.transformer.ITextureTransformer;

public abstract class ModelLayerTexture {
    public abstract ResourceLocation getTexture(IModelLayerContext var1);

    public abstract ModelLayerTexture transform(ITextureTransformer var1);

    public static ModelLayerTexture parse(JsonElement jsonElement) {
        if (jsonElement.isJsonPrimitive()) {
            return new DefaultModelTexture(jsonElement.getAsString(), null);
        }
        if (jsonElement.isJsonObject()) {
            JsonObject json = jsonElement.getAsJsonObject();
            String type = JSONUtils.func_151219_a((JsonObject)json, (String)"type", (String)"threecore:default");
            ModelLayerTexture texture = ModelLayerManager.parseTexture(json);
            if (texture == null) {
                ThreeCore.LOGGER.warn("Model layer type '" + type + "' does not exist!");
                return null;
            }
            if (JSONUtils.func_151204_g((JsonObject)json, (String)"transformers")) {
                JsonArray transformers = JSONUtils.func_151214_t((JsonObject)json, (String)"transformers");
                for (int i = 0; i < transformers.size(); ++i) {
                    JsonObject transformerJson = transformers.get(i).getAsJsonObject();
                    ITextureTransformer transformer = ModelLayerManager.parseTextureTransformer(transformerJson);
                    if (transformer != null) {
                        texture.transform(transformer);
                        continue;
                    }
                    ThreeCore.LOGGER.warn("Texture transformer type '" + JSONUtils.func_151200_h((JsonObject)transformerJson, (String)"type") + "' does not exist!");
                }
            }
            return texture;
        }
        return null;
    }
}

