/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.client.renderer.entity.modellayer.texture.transformer;

import java.io.IOException;
import java.io.InputStream;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.threetag.threecore.client.renderer.entity.modellayer.texture.transformer.ITextureTransformer;

public class OverlayTextureTransformer
implements ITextureTransformer {
    private final String overlayLocation;

    public OverlayTextureTransformer(String overlayLocation) {
        this.overlayLocation = overlayLocation;
    }

    @Override
    public NativeImage transform(NativeImage texture, IResourceManager manager, Function<String, String> stringConverter) throws IOException {
        NativeImage overlay = NativeImage.func_195713_a((InputStream)manager.func_199002_a(new ResourceLocation(stringConverter.apply(this.overlayLocation))).func_199027_b());
        for (int y = 0; y < overlay.func_195714_b(); ++y) {
            for (int x = 0; x < overlay.func_195702_a(); ++x) {
                this.blendPixel(texture, x, y, overlay.func_195709_a(x, y));
            }
        }
        return texture;
    }

    public void blendPixel(NativeImage texture, int xIn, int yIn, int colIn) {
        if (texture.func_211678_c() != NativeImage.PixelFormat.RGBA) {
            throw new UnsupportedOperationException("Can only call blendPixel with RGBA format");
        }
        int i = texture.func_195709_a(xIn, yIn);
        float f = (float)NativeImage.func_227786_a_((int)colIn) / 255.0f;
        float f1 = (float)NativeImage.func_227795_d_((int)colIn) / 255.0f;
        float f2 = (float)NativeImage.func_227793_c_((int)colIn) / 255.0f;
        float f3 = (float)NativeImage.func_227791_b_((int)colIn) / 255.0f;
        float f4 = (float)NativeImage.func_227786_a_((int)i) / 255.0f;
        float f5 = (float)NativeImage.func_227795_d_((int)i) / 255.0f;
        float f6 = (float)NativeImage.func_227793_c_((int)i) / 255.0f;
        float f7 = (float)NativeImage.func_227791_b_((int)i) / 255.0f;
        float f8 = 1.0f - f;
        float f9 = f * f + f4 * f8;
        float f10 = f1 * f + f5 * f8;
        float f11 = f2 * f + f6 * f8;
        float f12 = f3 * f + f7 * f8;
        if (f9 > 1.0f) {
            f9 = 1.0f;
        }
        if (f10 > 1.0f) {
            f10 = 1.0f;
        }
        if (f11 > 1.0f) {
            f11 = 1.0f;
        }
        if (f12 > 1.0f) {
            f12 = 1.0f;
        }
        int j = (int)(f9 * 255.0f);
        int k = (int)(f10 * 255.0f);
        int l = (int)(f11 * 255.0f);
        int i1 = (int)(f12 * 255.0f);
        texture.func_195700_a(xIn, yIn, NativeImage.func_227787_a_((int)j, (int)k, (int)l, (int)i1));
    }
}

