/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.client.renderer.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.BitSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fluids.IFluidTank;
import net.threetag.threecore.util.RenderUtil;

public abstract class FastFluidTESR<T extends TileEntity>
extends TileEntityRenderer<T> {
    public FastFluidTESR(TileEntityRendererDispatcher rendererDispatcher) {
        super(rendererDispatcher);
    }

    public void func_225616_a_(T te, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int combinedLightIn, int combinedOverlayIn) {
        for (TankRenderInfo tankRenderInfo : this.getTanksToRender(te)) {
            this.doRender(te, partialTicks, matrixStack, renderTypeBuffer, combinedLightIn, combinedOverlayIn, tankRenderInfo);
        }
    }

    private void doRender(T te, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int combinedLightIn, int combinedOverlayIn, TankRenderInfo tankRenderInfo) {
        IFluidTank tank = tankRenderInfo.tank;
        if (tank.getFluidAmount() == 0) {
            return;
        }
        Fluid f = tank.getFluid().getFluid();
        TextureAtlasSprite still = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(f.getAttributes().getStillTexture());
        float u1 = still.func_94209_e();
        float v1 = still.func_94206_g();
        float u2 = still.func_94212_f();
        float v2 = still.func_94210_h();
        int color = f.getAttributes().getColor(tank.getFluid());
        float red = (float)RenderUtil.red(color) / 255.0f;
        float green = (float)RenderUtil.green(color) / 255.0f;
        float blue = (float)RenderUtil.blue(color) / 255.0f;
        float alpha = (float)RenderUtil.alpha(color) / 255.0f;
        AxisAlignedBB bounds = this.getRenderBounds(tank, tankRenderInfo.bounds);
        IVertexBuilder builder = renderTypeBuffer.getBuffer(RenderType.func_228645_f_());
        matrixStack.func_227860_a_();
        if (tankRenderInfo.shouldRender(Direction.DOWN)) {
            this.add(builder, matrixStack, (float)bounds.field_72340_a, (float)bounds.field_72338_b, (float)bounds.field_72334_f, u1, v2, red, green, blue, alpha, combinedLightIn);
            this.add(builder, matrixStack, (float)bounds.field_72340_a, (float)bounds.field_72338_b, (float)bounds.field_72339_c, u1, v1, red, green, blue, alpha, combinedLightIn);
            this.add(builder, matrixStack, (float)bounds.field_72336_d, (float)bounds.field_72338_b, (float)bounds.field_72339_c, u2, v1, red, green, blue, alpha, combinedLightIn);
            this.add(builder, matrixStack, (float)bounds.field_72336_d, (float)bounds.field_72338_b, (float)bounds.field_72334_f, u2, v2, red, green, blue, alpha, combinedLightIn);
        }
        if (tankRenderInfo.shouldRender(Direction.UP)) {
            this.add(builder, matrixStack, (float)bounds.field_72340_a, (float)bounds.field_72337_e, (float)bounds.field_72334_f, u1, v2, red, green, blue, alpha, combinedLightIn);
            this.add(builder, matrixStack, (float)bounds.field_72336_d, (float)bounds.field_72337_e, (float)bounds.field_72334_f, u2, v2, red, green, blue, alpha, combinedLightIn);
            this.add(builder, matrixStack, (float)bounds.field_72336_d, (float)bounds.field_72337_e, (float)bounds.field_72339_c, u2, v1, red, green, blue, alpha, combinedLightIn);
            this.add(builder, matrixStack, (float)bounds.field_72340_a, (float)bounds.field_72337_e, (float)bounds.field_72339_c, u1, v1, red, green, blue, alpha, combinedLightIn);
        }
        if (tankRenderInfo.shouldRender(Direction.NORTH)) {
            this.add(builder, matrixStack, (float)bounds.field_72340_a, (float)bounds.field_72338_b, (float)bounds.field_72339_c, u1, v1, red, green, blue, alpha, combinedLightIn);
            this.add(builder, matrixStack, (float)bounds.field_72340_a, (float)bounds.field_72337_e, (float)bounds.field_72339_c, u1, v2, red, green, blue, alpha, combinedLightIn);
            this.add(builder, matrixStack, (float)bounds.field_72336_d, (float)bounds.field_72337_e, (float)bounds.field_72339_c, u2, v2, red, green, blue, alpha, combinedLightIn);
            this.add(builder, matrixStack, (float)bounds.field_72336_d, (float)bounds.field_72338_b, (float)bounds.field_72339_c, u2, v1, red, green, blue, alpha, combinedLightIn);
        }
        if (tankRenderInfo.shouldRender(Direction.SOUTH)) {
            this.add(builder, matrixStack, (float)bounds.field_72336_d, (float)bounds.field_72338_b, (float)bounds.field_72334_f, u2, v1, red, green, blue, alpha, combinedLightIn);
            this.add(builder, matrixStack, (float)bounds.field_72336_d, (float)bounds.field_72337_e, (float)bounds.field_72334_f, u2, v2, red, green, blue, alpha, combinedLightIn);
            this.add(builder, matrixStack, (float)bounds.field_72340_a, (float)bounds.field_72337_e, (float)bounds.field_72334_f, u1, v2, red, green, blue, alpha, combinedLightIn);
            this.add(builder, matrixStack, (float)bounds.field_72340_a, (float)bounds.field_72338_b, (float)bounds.field_72334_f, u1, v1, red, green, blue, alpha, combinedLightIn);
        }
        if (tankRenderInfo.shouldRender(Direction.WEST)) {
            this.add(builder, matrixStack, (float)bounds.field_72340_a, (float)bounds.field_72338_b, (float)bounds.field_72334_f, u1, v2, red, green, blue, alpha, combinedLightIn);
            this.add(builder, matrixStack, (float)bounds.field_72340_a, (float)bounds.field_72337_e, (float)bounds.field_72334_f, u2, v2, red, green, blue, alpha, combinedLightIn);
            this.add(builder, matrixStack, (float)bounds.field_72340_a, (float)bounds.field_72337_e, (float)bounds.field_72339_c, u2, v1, red, green, blue, alpha, combinedLightIn);
            this.add(builder, matrixStack, (float)bounds.field_72340_a, (float)bounds.field_72338_b, (float)bounds.field_72339_c, u1, v1, red, green, blue, alpha, combinedLightIn);
        }
        if (tankRenderInfo.shouldRender(Direction.EAST)) {
            this.add(builder, matrixStack, (float)bounds.field_72336_d, (float)bounds.field_72338_b, (float)bounds.field_72339_c, u1, v1, red, green, blue, alpha, combinedLightIn);
            this.add(builder, matrixStack, (float)bounds.field_72336_d, (float)bounds.field_72337_e, (float)bounds.field_72339_c, u2, v1, red, green, blue, alpha, combinedLightIn);
            this.add(builder, matrixStack, (float)bounds.field_72336_d, (float)bounds.field_72337_e, (float)bounds.field_72334_f, u2, v2, red, green, blue, alpha, combinedLightIn);
            this.add(builder, matrixStack, (float)bounds.field_72336_d, (float)bounds.field_72338_b, (float)bounds.field_72334_f, u1, v2, red, green, blue, alpha, combinedLightIn);
        }
        matrixStack.func_227865_b_();
    }

    private void add(IVertexBuilder builder, MatrixStack matrixStack, float x, float y, float z, float u, float v, float red, float green, float blue, float alpha, int light) {
        builder.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), x, y, z).func_227885_a_(red, green, blue, alpha).func_225583_a_(u, v).func_227886_a_(light).func_225584_a_(1.0f, 0.0f, 0.0f).func_181675_d();
    }

    private AxisAlignedBB getRenderBounds(IFluidTank tank, AxisAlignedBB tankBounds) {
        float percent = (float)tank.getFluidAmount() / (float)tank.getCapacity();
        double tankHeight = tankBounds.field_72337_e - tankBounds.field_72338_b;
        double y1 = tankBounds.field_72338_b;
        double y2 = tankBounds.field_72338_b + tankHeight * (double)percent;
        if (tank.getFluid().getFluid().getAttributes().getDensity() < 0) {
            double yOff = tankBounds.field_72337_e - y2;
            y1 += yOff;
            y2 += yOff;
        }
        return new AxisAlignedBB(tankBounds.field_72340_a, y1, tankBounds.field_72339_c, tankBounds.field_72336_d, y2, tankBounds.field_72334_f);
    }

    static AxisAlignedBB rotateY(AxisAlignedBB in, int rot) {
        switch (rot) {
            case 90: {
                return new AxisAlignedBB(1.0 - in.field_72339_c, in.field_72338_b, in.field_72340_a, 1.0 - in.field_72334_f, in.field_72337_e, in.field_72336_d);
            }
            case 180: {
                return new AxisAlignedBB(1.0 - in.field_72340_a, in.field_72338_b, 1.0 - in.field_72339_c, 1.0 - in.field_72336_d, in.field_72337_e, 1.0 - in.field_72334_f);
            }
            case 270: {
                return new AxisAlignedBB(in.field_72339_c, in.field_72338_b, 1.0 - in.field_72340_a, in.field_72334_f, in.field_72337_e, 1.0 - in.field_72336_d);
            }
        }
        throw new IllegalArgumentException("rot must be 90, 180 or 270");
    }

    public abstract List<TankRenderInfo> getTanksToRender(T var1);

    public static class TankRenderInfo {
        final IFluidTank tank;
        final AxisAlignedBB bounds;
        final BitSet faces = new BitSet(6);

        public TankRenderInfo(IFluidTank tank, AxisAlignedBB bounds, Direction ... renderFaces) {
            this.tank = tank;
            this.bounds = bounds;
            if (renderFaces.length == 0) {
                this.faces.set(0, 6, true);
            } else {
                for (Direction face : renderFaces) {
                    this.faces.set(face.func_176745_a(), true);
                }
            }
        }

        TankRenderInfo without(Direction face) {
            this.faces.clear(face.func_176745_a());
            return this;
        }

        boolean shouldRender(Direction face) {
            return this.faces.get(face.func_176745_a());
        }
    }
}

