/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.command;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.EntitySelector;
import net.minecraft.command.arguments.ResourceLocationArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.threetag.threecore.ability.superpower.Superpower;
import net.threetag.threecore.ability.superpower.SuperpowerManager;

public class SuperpowerCommand {
    private static final SuggestionProvider<CommandSource> SUGGEST_SUPERPOWERS = (context, builder) -> {
        Collection<Superpower> superpowers = SuperpowerManager.getInstance().getSuperpowers();
        return ISuggestionProvider.func_212476_a(superpowers.stream().map(Superpower::getId), (SuggestionsBuilder)builder);
    };
    private static final SuggestionProvider<CommandSource> SUGGEST_OWN_SUPERPOWERS = (context, builder) -> {
        ArrayList superpowers = Lists.newArrayList();
        Collection<Object> entities = null;
        try {
            context.getArgument("entities", EntitySelector.class);
            entities = EntityArgument.func_197097_b((CommandContext)context, (String)"entities");
        }
        catch (Exception e) {
            entities = Collections.singleton(((CommandSource)context.getSource()).func_197035_h());
        }
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity)) continue;
            for (ResourceLocation id : SuperpowerManager.getSuperpowers((LivingEntity)entity)) {
                if (superpowers.contains(id)) continue;
                superpowers.add(id);
            }
        }
        return ISuggestionProvider.func_212476_a(superpowers.stream(), (SuggestionsBuilder)builder);
    };
    public static final DynamicCommandExceptionType SUPERPOWER_NOT_FOUND = new DynamicCommandExceptionType(object -> new TranslationTextComponent("commands.superpower.error.superpowerNotFound", new Object[]{object}));

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"superpower").requires(player -> player.func_197034_c(2))).then(Commands.func_197057_a((String)"set").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"superpower", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(SUGGEST_SUPERPOWERS).executes(c -> SuperpowerCommand.setSuperpower((CommandSource)c.getSource(), Collections.singleton(((CommandSource)c.getSource()).func_197035_h()), SuperpowerCommand.getSuperpower((CommandContext<CommandSource>)c, "superpower"), -1))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"entities", (ArgumentType)EntityArgument.func_197093_b()).executes(c -> SuperpowerCommand.setSuperpower((CommandSource)c.getSource(), EntityArgument.func_197097_b((CommandContext)c, (String)"entities"), SuperpowerCommand.getSuperpower((CommandContext<CommandSource>)c, "superpower"), -1))).then(Commands.func_197056_a((String)"lifetime", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(c -> SuperpowerCommand.setSuperpower((CommandSource)c.getSource(), EntityArgument.func_197097_b((CommandContext)c, (String)"entities"), SuperpowerCommand.getSuperpower((CommandContext<CommandSource>)c, "superpower"), IntegerArgumentType.getInteger((CommandContext)c, (String)"lifetime")))))))).then(Commands.func_197057_a((String)"add").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"superpower", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(SUGGEST_SUPERPOWERS).executes(c -> SuperpowerCommand.addSuperpower((CommandSource)c.getSource(), Collections.singleton(((CommandSource)c.getSource()).func_197035_h()), SuperpowerCommand.getSuperpower((CommandContext<CommandSource>)c, "superpower"), -1))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"entities", (ArgumentType)EntityArgument.func_197093_b()).executes(c -> SuperpowerCommand.addSuperpower((CommandSource)c.getSource(), EntityArgument.func_197097_b((CommandContext)c, (String)"entities"), SuperpowerCommand.getSuperpower((CommandContext<CommandSource>)c, "superpower"), -1))).then(Commands.func_197056_a((String)"lifetime", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(c -> SuperpowerCommand.addSuperpower((CommandSource)c.getSource(), EntityArgument.func_197097_b((CommandContext)c, (String)"entities"), SuperpowerCommand.getSuperpower((CommandContext<CommandSource>)c, "superpower"), IntegerArgumentType.getInteger((CommandContext)c, (String)"lifetime")))))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"remove").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"superpower", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(SUGGEST_OWN_SUPERPOWERS).executes(c -> SuperpowerCommand.removeSuperpower((CommandSource)c.getSource(), Collections.singleton(((CommandSource)c.getSource()).func_197035_h()), ResourceLocationArgument.func_197195_e((CommandContext)c, (String)"superpower")))).then(Commands.func_197056_a((String)"entities", (ArgumentType)EntityArgument.func_197093_b()).executes(c -> SuperpowerCommand.removeSuperpower((CommandSource)c.getSource(), EntityArgument.func_197097_b((CommandContext)c, (String)"entities"), ResourceLocationArgument.func_197195_e((CommandContext)c, (String)"superpower")))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"*").executes(c -> SuperpowerCommand.removeAllSuperpowers((CommandSource)c.getSource(), Collections.singleton(((CommandSource)c.getSource()).func_197035_h())))).then(Commands.func_197056_a((String)"entities", (ArgumentType)EntityArgument.func_197093_b()).executes(c -> SuperpowerCommand.removeAllSuperpowers((CommandSource)c.getSource(), EntityArgument.func_197097_b((CommandContext)c, (String)"entities")))))));
    }

    public static Superpower getSuperpower(CommandContext<CommandSource> context, String key) throws CommandSyntaxException {
        ResourceLocation resourceLocation = (ResourceLocation)context.getArgument(key, ResourceLocation.class);
        Superpower superpower = SuperpowerManager.getInstance().getSuperpower(resourceLocation);
        if (superpower == null) {
            throw SUPERPOWER_NOT_FOUND.create((Object)resourceLocation);
        }
        return superpower;
    }

    public static int setSuperpower(CommandSource commandSource, Collection<? extends Entity> entities, Superpower superpower, int lifetime) {
        Iterator<? extends Entity> iterator = entities.iterator();
        int i = 0;
        boolean no = false;
        while (iterator.hasNext()) {
            Entity entity = iterator.next();
            if (entity instanceof LivingEntity) {
                SuperpowerManager.setSuperpower((LivingEntity)entity, superpower, lifetime);
                ++i;
                continue;
            }
            commandSource.func_197021_a((ITextComponent)new TranslationTextComponent("commands.superpower.error.noLivingEntity"));
        }
        if (i == 1) {
            commandSource.func_197030_a((ITextComponent)new TranslationTextComponent("commands.superpower.success.entity.single", new Object[]{entities.iterator().next().func_145748_c_(), superpower.getName()}), true);
        } else {
            commandSource.func_197030_a((ITextComponent)new TranslationTextComponent("commands.superpower.success.entity.multiple", new Object[]{i, superpower.getName()}), true);
        }
        return i;
    }

    public static int addSuperpower(CommandSource commandSource, Collection<? extends Entity> entities, Superpower superpower, int lifetime) {
        Iterator<? extends Entity> iterator = entities.iterator();
        int i = 0;
        boolean no = false;
        while (iterator.hasNext()) {
            Entity entity = iterator.next();
            if (entity instanceof LivingEntity) {
                if (SuperpowerManager.addSuperpower((LivingEntity)entity, superpower, lifetime)) {
                    ++i;
                    continue;
                }
                if (entities.size() != 1) continue;
                no = true;
                commandSource.func_197021_a((ITextComponent)new TranslationTextComponent("commands.superpower.error.alreadyHasSuperpower", new Object[]{entity.func_145748_c_()}));
                continue;
            }
            commandSource.func_197021_a((ITextComponent)new TranslationTextComponent("commands.superpower.error.noLivingEntity"));
        }
        if (!no) {
            if (i == 1) {
                commandSource.func_197030_a((ITextComponent)new TranslationTextComponent("commands.superpower.success.entity.single", new Object[]{entities.iterator().next().func_145748_c_(), superpower.getName()}), true);
            } else {
                commandSource.func_197030_a((ITextComponent)new TranslationTextComponent("commands.superpower.success.entity.multiple", new Object[]{i, superpower.getName()}), true);
            }
        }
        return i;
    }

    public static int removeSuperpower(CommandSource commandSource, Collection<? extends Entity> entities, ResourceLocation id) {
        Iterator<? extends Entity> iterator = entities.iterator();
        int i = 0;
        boolean no = false;
        while (iterator.hasNext()) {
            Entity entity = iterator.next();
            if (entity instanceof LivingEntity) {
                if (SuperpowerManager.removeSuperpower((LivingEntity)entity, id)) {
                    ++i;
                    continue;
                }
                if (entities.size() != 1) continue;
                no = true;
                commandSource.func_197021_a((ITextComponent)new TranslationTextComponent("commands.superpower.error.doesntHaveSuperpower", new Object[]{entity.func_145748_c_()}));
                continue;
            }
            commandSource.func_197021_a((ITextComponent)new TranslationTextComponent("commands.superpower.error.noLivingEntity"));
        }
        if (!no) {
            if (i == 1) {
                commandSource.func_197030_a((ITextComponent)new TranslationTextComponent("commands.superpower.remove.success.entity.single", new Object[]{entities.iterator().next().func_145748_c_()}), true);
            } else {
                commandSource.func_197030_a((ITextComponent)new TranslationTextComponent("commands.superpower.remove.success.entity.multiple", new Object[]{i}), true);
            }
        }
        return i;
    }

    public static int removeAllSuperpowers(CommandSource commandSource, Collection<? extends Entity> entities) {
        Iterator<? extends Entity> iterator = entities.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Entity entity = iterator.next();
            if (entity instanceof LivingEntity) {
                SuperpowerManager.removeSuperpowers((LivingEntity)entity);
                continue;
            }
            commandSource.func_197021_a((ITextComponent)new TranslationTextComponent("commands.superpower.error.noLivingEntity"));
        }
        if (i == 1) {
            commandSource.func_197030_a((ITextComponent)new TranslationTextComponent("commands.superpower.remove.success.entity.single", new Object[]{entities.iterator().next().func_145748_c_()}), true);
        } else {
            commandSource.func_197030_a((ITextComponent)new TranslationTextComponent("commands.superpower.remove.success.entity.multiple", new Object[]{i}), true);
        }
        return i;
    }
}

