/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.compat.jei.pressing;

import com.mojang.blaze3d.matrix.MatrixStack;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.threetag.threecore.block.TCBlocks;
import net.threetag.threecore.compat.jei.ThreeCoreJEIPlugin;
import net.threetag.threecore.item.recipe.PressingRecipe;

public class PressingCategory<T>
implements IRecipeCategory<PressingRecipe> {
    protected static final int castSlot = 0;
    protected static final int inputSlot = 1;
    protected static final int outputSlot = 2;
    private final String title = I18n.func_135052_a((String)"gui.jei.category.threecore.pressing", (Object[])new Object[0]);
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated arrow;

    public PressingCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(ThreeCoreJEIPlugin.RECIPE_GUI_TEXTURE, 0, 26, 116, 60).build();
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)TCBlocks.HYDRAULIC_PRESS.get()));
        this.arrow = guiHelper.drawableBuilder(ThreeCoreJEIPlugin.RECIPE_GUI_TEXTURE, 107, 0, 24, 17).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public ResourceLocation getUid() {
        return ThreeCoreJEIPlugin.PRESSING_CATEGORY;
    }

    public Class<? extends PressingRecipe> getRecipeClass() {
        return PressingRecipe.class;
    }

    public String getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(PressingRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.func_192400_c());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
    }

    public void setRecipe(IRecipeLayout recipeLayout, PressingRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 0, 21);
        guiItemStacks.init(1, true, 32, 21);
        guiItemStacks.init(2, false, 94, 21);
        guiItemStacks.set(ingredients);
    }

    public void draw(PressingRecipe recipe, MatrixStack stack, double mouseX, double mouseY) {
        this.arrow.draw(stack, 58, 21);
        Minecraft minecraft = Minecraft.func_71410_x();
        FontRenderer fontRenderer = minecraft.field_71466_p;
        String energyString = I18n.func_135052_a((String)"threecore.util.energy_display", (Object[])new Object[]{recipe.getRequiredEnergy(), "FE"});
        int stringWidth = fontRenderer.func_78256_a(energyString);
        fontRenderer.func_238421_b_(stack, energyString, (float)(this.background.getWidth() - stringWidth), 50.0f, -8355712);
        float experience = recipe.getExperience();
        if (experience > 0.0f) {
            String experienceString = I18n.func_135052_a((String)"gui.jei.category.threecore.pressing.experience", (Object[])new Object[]{Float.valueOf(experience)});
            int stringWidth2 = fontRenderer.func_78256_a(experienceString);
            fontRenderer.func_238421_b_(stack, experienceString, (float)(this.background.getWidth() - stringWidth2), 3.0f, -8355712);
        }
    }
}

