/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.container;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.threecore.block.TCBlocks;
import net.threetag.threecore.container.TCContainerTypes;
import net.threetag.threecore.item.MultiversalExtrapolatorItem;
import net.threetag.threecore.item.recipe.MultiversalRecipe;

public class MultiversalIteratorContainer
extends Container {
    private final IWorldPosCallable worldPosCallable;
    private final IntReferenceHolder selectedRecipe = IntReferenceHolder.func_221492_a();
    private final World world;
    private List<ItemStack> items = Lists.newArrayList();
    private ItemStack itemStackInput = ItemStack.field_190927_a;
    private String universe = "";
    private long lastOnTake;
    final Slot extrapolatorInventorySlot;
    final Slot inputInventorySlot;
    final Slot outputInventorySlot;
    private Runnable inventoryUpdateListener = () -> {};
    public final IInventory extrapolatorInventory = new Inventory(1){

        public void func_70296_d() {
            super.func_70296_d();
            MultiversalIteratorContainer.this.func_75130_a((IInventory)this);
            MultiversalIteratorContainer.this.inventoryUpdateListener.run();
        }
    };
    public final IInventory inputInventory = new Inventory(1){

        public void func_70296_d() {
            super.func_70296_d();
            MultiversalIteratorContainer.this.func_75130_a((IInventory)this);
            MultiversalIteratorContainer.this.inventoryUpdateListener.run();
        }
    };
    private final CraftResultInventory inventory = new CraftResultInventory();

    public MultiversalIteratorContainer(int windowIdIn, PlayerInventory playerInventoryIn) {
        this(windowIdIn, playerInventoryIn, IWorldPosCallable.field_221489_a);
    }

    public MultiversalIteratorContainer(int windowIdIn, PlayerInventory playerInventoryIn, final IWorldPosCallable worldPosCallableIn) {
        super((ContainerType)TCContainerTypes.MULTIVERSAL_ITERATOR.get(), windowIdIn);
        this.worldPosCallable = worldPosCallableIn;
        this.world = playerInventoryIn.field_70458_d.field_70170_p;
        this.extrapolatorInventorySlot = this.func_75146_a(new Slot(this.extrapolatorInventory, 0, 20, 21){

            public boolean func_75214_a(ItemStack stack) {
                return stack.func_77973_b() instanceof MultiversalExtrapolatorItem;
            }
        });
        this.inputInventorySlot = this.func_75146_a(new Slot(this.inputInventory, 0, 20, 65));
        this.outputInventorySlot = this.func_75146_a(new Slot((IInventory)this.inventory, 1, 143, 65){

            public boolean func_75214_a(ItemStack stack) {
                return false;
            }

            public ItemStack func_190901_a(PlayerEntity thePlayer, ItemStack stack) {
                ItemStack itemstack = MultiversalIteratorContainer.this.inputInventorySlot.func_75209_a(1);
                if (!itemstack.func_190926_b()) {
                    MultiversalIteratorContainer.this.updateRecipeResultSlot();
                }
                stack.func_77973_b().func_77622_d(stack, thePlayer.field_70170_p, thePlayer);
                ItemStack extrapolator = MultiversalIteratorContainer.this.extrapolatorInventory.func_70301_a(0);
                extrapolator.func_222118_a(1, (LivingEntity)thePlayer, player -> MultiversalIteratorContainer.this.extrapolatorInventory.func_70299_a(0, ItemStack.field_190927_a));
                MultiversalIteratorContainer.this.extrapolatorInventory.func_70299_a(0, extrapolator);
                MultiversalIteratorContainer.this.func_75142_b();
                worldPosCallableIn.func_221486_a((world, pos) -> {
                    long l = world.func_82737_E();
                    if (MultiversalIteratorContainer.this.lastOnTake != l) {
                        world.func_184133_a(null, pos, SoundEvents.field_206938_K, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        MultiversalIteratorContainer.this.lastOnTake = l;
                    }
                });
                return super.func_190901_a(thePlayer, stack);
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)playerInventoryIn, j + i * 9 + 9, 8 + j * 18, 116 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.func_75146_a(new Slot((IInventory)playerInventoryIn, k, 8 + k * 18, 174));
        }
        this.func_216958_a(this.selectedRecipe);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getSelectedRecipe() {
        return this.selectedRecipe.func_221495_b();
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<ItemStack> getItemList() {
        return this.items;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getRecipeListSize() {
        return this.items.size();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean hasItemsInInputSlot() {
        return this.inputInventorySlot.func_75216_d() && !this.items.isEmpty();
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return MultiversalIteratorContainer.func_216963_a((IWorldPosCallable)this.worldPosCallable, (PlayerEntity)playerIn, (Block)((Block)TCBlocks.MULTIVERSAL_ITERATOR.get()));
    }

    public boolean func_75140_a(PlayerEntity playerIn, int id) {
        if ((id -= 8) >= 0 && id < this.items.size()) {
            this.selectedRecipe.func_221494_a(id);
            this.updateRecipeResultSlot();
        }
        return true;
    }

    public void func_75130_a(IInventory inventoryIn) {
        ItemStack itemstack = this.inputInventorySlot.func_75211_c();
        ItemStack extrapolator = this.extrapolatorInventorySlot.func_75211_c();
        if (itemstack.func_77973_b() != this.itemStackInput.func_77973_b() || !this.universe.equals(MultiversalExtrapolatorItem.getUniverse(extrapolator))) {
            this.itemStackInput = itemstack.func_77946_l();
            this.universe = MultiversalExtrapolatorItem.getUniverse(extrapolator);
            if (this.universe == null) {
                this.universe = "";
            }
            this.updateAvailableRecipes(inventoryIn, itemstack, this.universe);
        }
    }

    private void updateAvailableRecipes(IInventory inventoryIn, ItemStack stack, String universe) {
        this.items.clear();
        this.selectedRecipe.func_221494_a(-1);
        this.outputInventorySlot.func_75215_d(ItemStack.field_190927_a);
        if (!stack.func_190926_b()) {
            this.items = MultiversalRecipe.getVariations(stack, universe, MultiversalRecipe.getIdentifiersFromItem(stack, this.world), this.world);
        }
    }

    private void updateRecipeResultSlot() {
        if (!this.items.isEmpty()) {
            ItemStack stack = this.items.get(this.selectedRecipe.func_221495_b());
            this.outputInventorySlot.func_75215_d(stack.func_77946_l());
        } else {
            this.outputInventorySlot.func_75215_d(ItemStack.field_190927_a);
        }
        this.func_75142_b();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setInventoryUpdateListener(Runnable listenerIn) {
        this.inventoryUpdateListener = listenerIn;
    }

    public boolean func_94530_a(ItemStack stack, Slot slotIn) {
        return slotIn.field_75224_c != this.inventory && super.func_94530_a(stack, slotIn);
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            Item item = itemstack1.func_77973_b();
            itemstack = itemstack1.func_77946_l();
            if (index == 2) {
                item.func_77622_d(itemstack1, playerIn.field_70170_p, playerIn);
                if (!this.func_75135_a(itemstack1, 3, 39, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (index == 0 ? !this.func_75135_a(itemstack1, 3, 39, false) : (index == 1 ? !this.func_75135_a(itemstack1, 3, 39, false) : (itemstack1.func_77973_b() instanceof MultiversalExtrapolatorItem ? !this.func_75135_a(itemstack1, 0, 1, false) : (MultiversalRecipe.hasVariations(itemstack1, this.world) ? !this.func_75135_a(itemstack1, 1, 2, false) : (index >= 3 && index < 30 ? !this.func_75135_a(itemstack1, 30, 39, false) : index >= 30 && index < 39 && !this.func_75135_a(itemstack1, 3, 30, false)))))) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            }
            slot.func_75218_e();
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, itemstack1);
            this.func_75142_b();
        }
        return itemstack;
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        this.inventory.func_70304_b(1);
        this.worldPosCallable.func_221486_a((world, pos) -> this.func_193327_a(playerIn, playerIn.field_70170_p, this.inputInventory));
        this.worldPosCallable.func_221486_a((world, pos) -> this.func_193327_a(playerIn, playerIn.field_70170_p, this.extrapolatorInventory));
    }
}

