/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;

public class AddConditionRecipeWrapper {
    public static Builder builder() {
        return new Builder();
    }

    private static class Finished
    implements IFinishedRecipe {
        private ResourceLocation id;
        private List<ICondition> conditions = new ArrayList<ICondition>();
        private IFinishedRecipe recipe;

        public Finished(ResourceLocation id, List<ICondition> conditions, IFinishedRecipe recipe) {
            this.id = id;
            this.conditions = conditions;
            this.recipe = recipe;
        }

        public void func_218610_a(JsonObject jsonObject) {
            if (this.conditions != null && !this.conditions.isEmpty()) {
                JsonArray conds = new JsonArray();
                for (ICondition c : this.conditions) {
                    conds.add((JsonElement)CraftingHelper.serialize((ICondition)c));
                }
                jsonObject.add("conditions", (JsonElement)conds);
            }
            JsonObject recipeJson = this.recipe.func_200441_a();
            for (Map.Entry entry : recipeJson.entrySet()) {
                jsonObject.add((String)entry.getKey(), (JsonElement)entry.getValue());
            }
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return this.recipe.func_218609_c();
        }

        @Nullable
        public JsonObject func_200440_c() {
            return this.recipe.func_200440_c();
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return this.recipe.func_200443_d();
        }
    }

    public static class Builder {
        private List<ICondition> conditions = new ArrayList<ICondition>();
        private IFinishedRecipe recipe;

        public Builder addCondition(ICondition condition) {
            this.conditions.add(condition);
            return this;
        }

        public Builder setRecipe(Consumer<Consumer<IFinishedRecipe>> callable) {
            callable.accept(this::setRecipe);
            return this;
        }

        public Builder setRecipe(IFinishedRecipe recipe) {
            this.recipe = recipe;
            return this;
        }

        public void build(Consumer<IFinishedRecipe> consumer) {
            this.build(consumer, this.recipe.func_200442_b());
        }

        public void build(Consumer<IFinishedRecipe> consumer, String namespace, String path) {
            this.build(consumer, new ResourceLocation(namespace, path));
        }

        public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
            if (this.recipe == null) {
                throw new IllegalStateException("Invalid ConditionalRecipe builder, No recipe");
            }
            consumer.accept(new Finished(id, this.conditions, this.recipe));
        }
    }
}

