/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.SlabBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.LootTableProvider;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.DynamicLootEntry;
import net.minecraft.loot.ILootConditionConsumer;
import net.minecraft.loot.ILootFunctionConsumer;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.conditions.BlockStateProperty;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.conditions.SurvivesExplosion;
import net.minecraft.loot.functions.CopyName;
import net.minecraft.loot.functions.CopyNbt;
import net.minecraft.loot.functions.ExplosionDecay;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.SetContents;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.state.Property;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class BaseLootTableProvider
extends LootTableProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    protected final Map<Block, LootTable.Builder> lootTables = new HashMap<Block, LootTable.Builder>();
    private final DataGenerator generator;

    public BaseLootTableProvider(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
        this.generator = dataGeneratorIn;
    }

    protected abstract void addTables();

    protected LootTable.Builder createStandardTable(String name, Block block) {
        LootPool.Builder builder = LootPool.func_216096_a().name(name).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block).func_212841_b_((ILootFunction.IBuilder)CopyName.func_215893_a((CopyName.Source)CopyName.Source.BLOCK_ENTITY)).func_212841_b_((ILootFunction.IBuilder)CopyNbt.func_215881_a((CopyNbt.Source)CopyNbt.Source.BLOCK_ENTITY).func_216055_a("inv", "BlockEntityTag.inv", CopyNbt.Action.REPLACE).func_216055_a("energy", "BlockEntityTag.energy", CopyNbt.Action.REPLACE)).func_212841_b_((ILootFunction.IBuilder)SetContents.func_215920_b().func_216075_a((LootEntry.Builder)DynamicLootEntry.func_216162_a((ResourceLocation)new ResourceLocation("minecraft", "contents")))));
        return LootTable.func_216119_b().func_216040_a(builder);
    }

    public void standardBlockTable(Block block) {
        this.lootTables.put(block, this.createStandardTable(block.getRegistryName().toString(), block));
    }

    public static LootTable.Builder droppingSlab(Block block) {
        return LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)BaseLootTableProvider.withExplosionDecay((IItemProvider)block, ItemLootEntry.func_216168_a((IItemProvider)block).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)2)).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)block).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227193_a_((Property)SlabBlock.field_196505_a, (Comparable)SlabType.DOUBLE)))))));
    }

    public static LootTable.Builder droppingWithName(Block block) {
        return LootTable.func_216119_b().func_216040_a((LootPool.Builder)BaseLootTableProvider.withSurvivesExplosion((IItemProvider)block, LootPool.func_216096_a().name(block.getRegistryName().toString()).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block).func_212841_b_((ILootFunction.IBuilder)CopyName.func_215893_a((CopyName.Source)CopyName.Source.BLOCK_ENTITY)))));
    }

    public static <T> T withExplosionDecay(IItemProvider itemProvider, ILootFunctionConsumer<T> lootFunctionConsumer) {
        return (T)(!BlockLootTables.field_218578_f.contains(itemProvider.func_199767_j()) ? lootFunctionConsumer.func_212841_b_((ILootFunction.IBuilder)ExplosionDecay.func_215863_b()) : lootFunctionConsumer.func_212862_c_());
    }

    protected static <T> T withSurvivesExplosion(IItemProvider itemProvider, ILootConditionConsumer<T> lootFunctionConsumer) {
        return (T)(!BlockLootTables.field_218578_f.contains(itemProvider.func_199767_j()) ? lootFunctionConsumer.func_212840_b_(SurvivesExplosion.func_215968_b()) : lootFunctionConsumer.func_212862_c_());
    }

    public void func_200398_a(DirectoryCache cache) {
        this.addTables();
        HashMap<ResourceLocation, LootTable> tables = new HashMap<ResourceLocation, LootTable>();
        for (Map.Entry<Block, LootTable.Builder> entry : this.lootTables.entrySet()) {
            tables.put(entry.getKey().func_220068_i(), entry.getValue().func_216039_a(LootParameterSets.field_216267_h).func_216038_b());
        }
        this.writeTables(cache, tables);
    }

    private void writeTables(DirectoryCache cache, Map<ResourceLocation, LootTable> tables) {
        Path outputFolder = this.generator.func_200391_b();
        tables.forEach((key, lootTable) -> {
            Path path = outputFolder.resolve("data/" + key.func_110624_b() + "/loot_tables/" + key.func_110623_a() + ".json");
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)LootTableManager.func_215301_a((LootTable)lootTable), (Path)path);
            }
            catch (IOException e) {
                LOGGER.error("Couldn't write loot table {}", (Object)path, (Object)e);
            }
        });
    }
}

