/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.entity.attributes;

import java.util.UUID;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.threetag.threecore.capability.CapabilitySizeChanging;
import net.threetag.threecore.capability.ISizeChanging;

@Mod.EventBusSubscriber(modid="threecore")
public class TCAttributes {
    public static final DeferredRegister<Attribute> ATTRIBUTES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ATTRIBUTES, (String)"threecore");
    public static final RegistryObject<Attribute> STEP_HEIGHT = ATTRIBUTES.register("step_height", () -> new RangedAttribute("threecore.stepHeight", 0.5, 0.0, 20.0).func_233753_a_(true));
    public static final RegistryObject<Attribute> FALL_RESISTANCE = ATTRIBUTES.register("fall_resistance", () -> new RangedAttribute("threecore.fallResistance", 0.0, 0.0, Double.MAX_VALUE));
    public static final RegistryObject<Attribute> JUMP_HEIGHT = ATTRIBUTES.register("jump_height", () -> new RangedAttribute("threecore.jumpHeight", 0.0, 0.0, Double.MAX_VALUE).func_233753_a_(true));
    public static final RegistryObject<Attribute> SPRINT_SPEED = ATTRIBUTES.register("sprint_speed", () -> new RangedAttribute("threecore.sprintSpeed", 0.0, 0.0, Double.MAX_VALUE).func_233753_a_(true));
    public static final RegistryObject<Attribute> SIZE_WIDTH = ATTRIBUTES.register("size_width", () -> new RangedAttribute("threecore.sizeWidth", 1.0, 0.1, 32.0).func_233753_a_(true));
    public static final RegistryObject<Attribute> SIZE_HEIGHT = ATTRIBUTES.register("size_height", () -> new RangedAttribute("threecore.sizeHeight", 1.0, 0.1, 32.0).func_233753_a_(true));
    public static float stepHeight;
    public static final UUID SPRINT_UUID;

    @SubscribeEvent
    public static void onFall(LivingFallEvent e) {
        ModifiableAttributeInstance fallAttribute = e.getEntityLiving().func_110148_a((Attribute)FALL_RESISTANCE.get());
        if (fallAttribute != null) {
            fallAttribute.func_111128_a((double)e.getDamageMultiplier());
            e.setDamageMultiplier((float)fallAttribute.func_111126_e());
        }
    }

    @SubscribeEvent
    public static void onFall(LivingEvent.LivingJumpEvent e) {
        if (!e.getEntityLiving().func_213453_ef()) {
            e.getEntityLiving().func_213293_j(e.getEntity().func_213322_ci().field_72450_a, e.getEntity().func_213322_ci().field_72448_b + (double)0.1f * e.getEntityLiving().func_110148_a((Attribute)JUMP_HEIGHT.get()).func_111126_e(), e.getEntity().func_213322_ci().field_72449_c);
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.PlayerTickEvent e) {
        if (e.phase == TickEvent.Phase.END) {
            if (e.player.field_70173_aa > 20 && e.player.field_70170_p.field_72995_K) {
                e.player.field_70138_W = stepHeight;
            }
            return;
        }
        if (e.player.field_70173_aa > 20 && e.player.field_70170_p.field_72995_K) {
            stepHeight = e.player.field_70138_W;
            ModifiableAttributeInstance attributeInstance = e.player.func_110148_a((Attribute)STEP_HEIGHT.get());
            attributeInstance.func_111128_a((double)stepHeight);
            e.player.field_70138_W = (float)attributeInstance.func_111126_e();
            ISizeChanging sizeChanging = (ISizeChanging)e.player.getCapability(CapabilitySizeChanging.SIZE_CHANGING).orElseGet(() -> null);
            if (sizeChanging != null) {
                e.player.field_70138_W *= sizeChanging.getHeight();
            }
        }
        e.player.func_110148_a(Attributes.field_233821_d_).func_188479_b(SPRINT_UUID);
        if (e.player.func_70051_ag() && e.player.func_110148_a((Attribute)SPRINT_SPEED.get()).func_225505_c_().size() > 0) {
            double amount = e.player.func_110148_a((Attribute)SPRINT_SPEED.get()).func_111126_e();
            e.player.func_110148_a(Attributes.field_233821_d_).func_233767_b_(new AttributeModifier(SPRINT_UUID, "Sprint modifier", amount, AttributeModifier.Operation.MULTIPLY_BASE));
        }
    }

    static {
        SPRINT_UUID = UUID.fromString("11faf62f-c271-4601-809e-83d982687b69");
    }
}

