/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.item;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.item.IItemTier;
import net.minecraft.item.ItemTier;

public class ItemTierRegistry {
    private static Map<String, IItemTier> ITEM_TIERS = new HashMap<String, IItemTier>();

    public static IItemTier getItemTier(String name) {
        return ITEM_TIERS.get(name.toLowerCase());
    }

    public static IItemTier addItemTier(String name, IItemTier itemTier) {
        ITEM_TIERS.put(name.toLowerCase(), itemTier);
        return itemTier;
    }

    public static IItemTier getOrCreateItemTier(String name, Supplier<IItemTier> itemTierSupplier) {
        return ItemTierRegistry.getItemTier(name) != null ? ItemTierRegistry.getItemTier(name) : ItemTierRegistry.addItemTier(name, itemTierSupplier.get());
    }

    static {
        ItemTierRegistry.addItemTier("wood", (IItemTier)ItemTier.WOOD);
        ItemTierRegistry.addItemTier("stone", (IItemTier)ItemTier.STONE);
        ItemTierRegistry.addItemTier("iron", (IItemTier)ItemTier.WOOD);
        ItemTierRegistry.addItemTier("gold", (IItemTier)ItemTier.GOLD);
        ItemTierRegistry.addItemTier("diamond", (IItemTier)ItemTier.DIAMOND);
    }
}

