/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.item;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.threetag.threecore.item.recipe.MultiverseManager;
import net.threetag.threecore.sound.TCSounds;
import net.threetag.threecore.util.PlayerUtil;

public class MultiversalExtrapolatorItem
extends Item {
    public MultiversalExtrapolatorItem(Item.Properties properties) {
        super(properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (stack.func_196082_o().func_74764_b("Universe") && MultiverseManager.CLIENT_UNIVERSES.contains(stack.func_196082_o().func_74779_i("Universe"))) {
            tooltip.add((ITextComponent)new TranslationTextComponent("universe." + stack.func_196082_o().func_74779_i("Universe")).func_240699_a_(TextFormatting.GOLD));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (!stack.func_196082_o().func_74764_b("Universe") || !MultiversalExtrapolatorItem.hasValidUniverse(stack)) {
            stack.func_196082_o().func_74757_a("Searching", true);
            return ActionResult.func_226248_a_((Object)stack);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack != newStack;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!worldIn.field_72995_K && entityIn instanceof PlayerEntity && stack.func_196082_o().func_74767_n("Searching")) {
            int progress = stack.func_196082_o().func_74762_e("SearchTimer");
            if (progress < 80) {
                stack.func_196082_o().func_74768_a("SearchTimer", progress + 1);
                if (progress < 60) {
                    Random random = new Random(entityIn.field_70173_aa / 2);
                    String number = random.nextInt(10) + "" + random.nextInt(10) + "" + random.nextInt(10);
                    ((PlayerEntity)entityIn).func_146105_b((ITextComponent)new TranslationTextComponent("universe.earth_search", new Object[]{number}), true);
                    if (entityIn.field_70173_aa % 2 == 0) {
                        PlayerUtil.playSound((PlayerEntity)entityIn, entityIn.func_226277_ct_(), entityIn.func_226278_cu_() + (double)entityIn.func_213302_cg() / 2.0, entityIn.func_226281_cx_(), (SoundEvent)TCSounds.MULTIVERSE_SEARCH.get(), SoundCategory.PLAYERS);
                    }
                } else {
                    if (progress == 60) {
                        stack.func_196082_o().func_74778_a("Universe", MultiverseManager.getRandomAvailableUniverse((PlayerEntity)entityIn).getIdentifier());
                    }
                    ((PlayerEntity)entityIn).func_146105_b((ITextComponent)new TranslationTextComponent("universe." + stack.func_196082_o().func_74779_i("Universe")).func_240699_a_(TextFormatting.GOLD), true);
                }
            } else {
                stack.func_196082_o().func_82580_o("Searching");
                stack.func_196082_o().func_82580_o("SearchTimer");
            }
        }
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        super.func_150895_a(group, items);
        if (this.func_194125_a(group)) {
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
                for (String universe : MultiverseManager.CLIENT_UNIVERSES) {
                    ItemStack stack = new ItemStack((IItemProvider)this);
                    stack.func_196082_o().func_74778_a("Universe", universe);
                    items.add((Object)stack);
                }
            });
            DistExecutor.runWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> {
                for (MultiverseManager.Universe s : MultiverseManager.getUniverses()) {
                    ItemStack stack = new ItemStack((IItemProvider)this);
                    stack.func_196082_o().func_74778_a("Universe", s.getIdentifier());
                    items.add((Object)stack);
                }
            });
        }
    }

    public static boolean hasValidUniverse(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_196082_o().func_74764_b("Universe") && MultiverseManager.getUniverse(stack.func_196082_o().func_74779_i("Universe")) != null;
    }

    public static boolean hasValidUniverseClient(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_196082_o().func_74764_b("Universe") && MultiverseManager.CLIENT_UNIVERSES.contains(stack.func_196082_o().func_74779_i("Universe"));
    }

    public static String getUniverse(ItemStack stack) {
        return MultiversalExtrapolatorItem.hasValidUniverse(stack) ? stack.func_196082_o().func_74779_i("Universe") : null;
    }
}

