/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.item.recipe;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.Month;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.threetag.threecore.ThreeCore;
import net.threetag.threecore.item.recipe.MultiversalRecipe;
import net.threetag.threecore.network.SyncMultiverseMessage;

@Mod.EventBusSubscriber(modid="threecore")
public class MultiverseManager {
    private static final Map<String, Universe> UNIVERSES = Maps.newHashMap();
    public static final List<String> CLIENT_UNIVERSES = Lists.newArrayList();
    private static final Map<ResourceLocation, Function<JsonObject, Function<PlayerEntity, Boolean>>> CONDITIONS = Maps.newHashMap();
    public static Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public static void reload(IResourceManager resourceManagerIn) {
        UNIVERSES.clear();
        MultiverseManager.registerUniverse("earth-18515");
        AtomicInteger i = new AtomicInteger();
        for (String namespace : resourceManagerIn.func_199001_a()) {
            try {
                for (IResource resource : resourceManagerIn.func_199004_b(new ResourceLocation(namespace, "multiverse.json"))) {
                    try {
                        InputStream inputstream = resource.func_199027_b();
                        Throwable throwable = null;
                        try {
                            InputStreamReader reader = new InputStreamReader(inputstream, StandardCharsets.UTF_8);
                            Throwable throwable2 = null;
                            try {
                                JsonObject json = (JsonObject)JSONUtils.func_193839_a((Gson)GSON, (Reader)reader, JsonObject.class);
                                json.entrySet().forEach(e -> {
                                    String id = (String)e.getKey();
                                    Universe universe = new Universe(id);
                                    universe.addConditions(MultiverseManager.parseConditions(((JsonElement)e.getValue()).getAsJsonObject().get("conditions")));
                                    MultiverseManager.registerUniverse(universe);
                                    i.incrementAndGet();
                                });
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (reader == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        ((Reader)reader).close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable2.addSuppressed(throwable4);
                                    }
                                    continue;
                                }
                                ((Reader)reader).close();
                            }
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (inputstream == null) continue;
                            if (throwable != null) {
                                try {
                                    inputstream.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                                continue;
                            }
                            inputstream.close();
                        }
                    }
                    catch (RuntimeException runtimeexception) {
                        ThreeCore.LOGGER.warn("Invalid multiverse.json in datapack: '{}'", (Object)resource.func_199026_d(), (Object)runtimeexception);
                    }
                }
            }
            catch (IOException iOException) {
            }
        }
        ThreeCore.LOGGER.info(i.get() + " universes read from multiverse.json files!");
    }

    public static void sync() {
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            List<String> ids = MultiverseManager.getUniverses().stream().map(Universe::getIdentifier).collect(Collectors.toList());
            for (ServerPlayerEntity player : ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v()) {
                ThreeCore.NETWORK_CHANNEL.sendTo((Object)new SyncMultiverseMessage(ids), player.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
            }
        }
    }

    @SubscribeEvent
    public static void onJoin(EntityJoinWorldEvent e) {
        if (e.getEntity() instanceof ServerPlayerEntity) {
            List<String> ids = MultiverseManager.getUniverses().stream().map(Universe::getIdentifier).collect(Collectors.toList());
            ThreeCore.NETWORK_CHANNEL.sendTo((Object)new SyncMultiverseMessage(ids), ((ServerPlayerEntity)e.getEntity()).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent e) {
        if (InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)340)) {
            for (String s : MultiversalRecipe.getUniversesFromItem(e.getItemStack(), e.getEntity().field_70170_p)) {
                e.getToolTip().add(1, new TranslationTextComponent("universe." + s).func_240699_a_(TextFormatting.GRAY));
            }
        }
    }

    public static Universe registerUniverse(String id) {
        if (!UNIVERSES.containsKey(id)) {
            Universe universe = new Universe(id);
            UNIVERSES.put(id, universe);
            return universe;
        }
        return UNIVERSES.get(id);
    }

    public static Universe registerUniverse(Universe universe) {
        if (UNIVERSES.containsKey(universe.identifier)) {
            Universe u = UNIVERSES.get(universe.identifier);
            u.conditions.addAll(universe.conditions);
            return u;
        }
        UNIVERSES.put(universe.identifier, universe);
        return universe;
    }

    public static boolean registerCondition(ResourceLocation id, Function<JsonObject, Function<PlayerEntity, Boolean>> function) {
        if (CONDITIONS.containsKey(id)) {
            ThreeCore.LOGGER.warn("Universe condition '" + id.toString() + "' already exists!");
            return false;
        }
        CONDITIONS.put(id, function);
        return true;
    }

    private static List<Function<PlayerEntity, Boolean>> parseConditions(JsonElement jsonElement) {
        if (jsonElement == null) {
            return Collections.emptyList();
        }
        if (jsonElement.isJsonObject()) {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            ResourceLocation id = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"type"));
            Function<JsonObject, Function<PlayerEntity, Boolean>> function = CONDITIONS.get(id);
            if (function == null) {
                ThreeCore.LOGGER.warn("Multiverse condition '" + JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"type") + "' does not exist!");
                return Collections.emptyList();
            }
            return Collections.singletonList(function.apply(jsonObject));
        }
        if (jsonElement.isJsonArray()) {
            ArrayList list = Lists.newArrayList();
            for (JsonElement jsonElement1 : jsonElement.getAsJsonArray()) {
                JsonObject jsonObject = jsonElement1.getAsJsonObject();
                ResourceLocation id = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"type"));
                Function<JsonObject, Function<PlayerEntity, Boolean>> function = CONDITIONS.get(id);
                if (function == null) {
                    ThreeCore.LOGGER.warn("Multiverse condition '" + JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"type") + "' does not exist!");
                    continue;
                }
                list.add(function.apply(jsonObject));
            }
            return list;
        }
        throw new JsonParseException("Condition list must be a json object or json array!");
    }

    public static Universe getRandomAvailableUniverse(PlayerEntity playerEntity) {
        List universes = MultiverseManager.getUniverses().stream().filter(universe -> universe.isAvailable(playerEntity)).collect(Collectors.toList());
        return (Universe)universes.get(new Random().nextInt(universes.size()));
    }

    public static List<Universe> getUniverses() {
        return ImmutableList.copyOf(UNIVERSES.values());
    }

    public static Universe getUniverse(String id) {
        return UNIVERSES.get(id);
    }

    static {
        MultiverseManager.registerCondition(new ResourceLocation("threecore", "date"), json -> {
            LocalDate start = LocalDate.of(JSONUtils.func_151203_m((JsonObject)json, (String)"startYear"), Month.of(JSONUtils.func_151203_m((JsonObject)json, (String)"startMonth")), JSONUtils.func_151203_m((JsonObject)json, (String)"startDay"));
            LocalDate end = LocalDate.of(JSONUtils.func_151203_m((JsonObject)json, (String)"endYear"), Month.of(JSONUtils.func_151203_m((JsonObject)json, (String)"endMonth")), JSONUtils.func_151203_m((JsonObject)json, (String)"endDay"));
            return player -> LocalDate.now().isAfter(start) && LocalDate.now().isBefore(end);
        });
        MultiverseManager.registerCondition(new ResourceLocation("threecore", "date_without_year"), json -> {
            LocalDate now = LocalDate.now();
            LocalDate start = LocalDate.of(now.getYear(), Month.of(JSONUtils.func_151203_m((JsonObject)json, (String)"startMonth")), JSONUtils.func_151203_m((JsonObject)json, (String)"startDay"));
            LocalDate end = LocalDate.of(now.getYear(), Month.of(JSONUtils.func_151203_m((JsonObject)json, (String)"endMonth")), JSONUtils.func_151203_m((JsonObject)json, (String)"endDay"));
            return player -> now.isAfter(start) && now.isBefore(end);
        });
    }

    public static class Universe {
        private final String identifier;
        private List<Function<PlayerEntity, Boolean>> conditions;

        public Universe(String identifier) {
            this.identifier = identifier;
            this.conditions = Lists.newArrayList();
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public Universe addCondition(Function<PlayerEntity, Boolean> condition) {
            this.conditions.add(condition);
            return this;
        }

        public Universe addConditions(List<Function<PlayerEntity, Boolean>> conditions) {
            this.conditions.addAll(conditions);
            return this;
        }

        public boolean isAvailable(PlayerEntity playerEntity) {
            for (Function<PlayerEntity, Boolean> condition : this.conditions) {
                if (condition.apply(playerEntity).booleanValue()) continue;
                return false;
            }
            return true;
        }
    }
}

