/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.item.recipe;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShearsItem;
import net.minecraft.item.SwordItem;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import net.threetag.threecore.item.HammerItem;

public class ToolIngredient
extends Ingredient {
    public static final ResourceLocation ID = new ResourceLocation("threecore", "tool");
    private final ToolType toolType;

    public ToolIngredient(ToolType type) {
        super(Stream.of(new ItemList(type)));
        this.toolType = type;
    }

    public boolean test(@Nullable ItemStack stack) {
        return this.toolType.test(stack);
    }

    public IIngredientSerializer<ToolIngredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static enum ToolType implements IStringSerializable,
    Predicate<ItemStack>
    {
        ALL("all", s -> {
            for (ToolType type : ToolType.values()) {
                if (type.func_176610_l().equalsIgnoreCase("all") || !type.test((ItemStack)s)) continue;
                return true;
            }
            return false;
        }),
        AXE("axe", s -> s.getToolTypes().contains(net.minecraftforge.common.ToolType.AXE)),
        PICKAXE("pickaxe", s -> s.getToolTypes().contains(net.minecraftforge.common.ToolType.PICKAXE)),
        SHOVEL("shovel", s -> s.getToolTypes().contains(net.minecraftforge.common.ToolType.SHOVEL)),
        SWORD("sword", s -> s.func_77973_b() instanceof SwordItem),
        SHEARS("shears", s -> s.func_77973_b() instanceof ShearsItem),
        HAMMER("hammer", s -> s.func_77973_b() instanceof HammerItem);

        private final String name;
        private final Predicate<ItemStack> predicate;

        private ToolType(String name, Predicate<ItemStack> predicate) {
            this.name = name;
            this.predicate = predicate;
        }

        @Override
        public boolean test(ItemStack stack) {
            return this.predicate.test(stack);
        }

        public static ToolType fromName(String name) {
            for (ToolType type : ToolType.values()) {
                if (!type.func_176610_l().equalsIgnoreCase(name)) continue;
                return type;
            }
            return null;
        }

        public String func_176610_l() {
            return this.name;
        }
    }

    public static class ItemList
    implements Ingredient.IItemList {
        private final ToolType toolType;

        public ItemList(ToolType toolType) {
            this.toolType = toolType;
        }

        public Collection<ItemStack> func_199799_a() {
            ArrayList list = Lists.newArrayList();
            for (Item item : ForgeRegistries.ITEMS.getValues()) {
                ItemStack stack = new ItemStack((IItemProvider)item);
                if (!this.toolType.test(stack)) continue;
                list.add(stack);
            }
            return list;
        }

        public JsonObject func_200303_b() {
            JsonObject json = new JsonObject();
            json.addProperty("type", ID.toString());
            json.addProperty("tool", this.toolType.func_176610_l());
            return json;
        }
    }

    public static class Serializer
    implements IIngredientSerializer<ToolIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        public ToolIngredient parse(PacketBuffer buffer) {
            ToolType type = ToolType.fromName(buffer.func_150789_c(Short.MAX_VALUE));
            return new ToolIngredient(type == null ? ToolType.ALL : type);
        }

        public ToolIngredient parse(JsonObject json) {
            ToolType type = ToolType.fromName(JSONUtils.func_151200_h((JsonObject)json, (String)"tool"));
            if (type == null) {
                throw new JsonParseException("Unknown tool type '" + JSONUtils.func_151200_h((JsonObject)json, (String)"tool") + "' in ingredient!");
            }
            return new ToolIngredient(type);
        }

        public void write(PacketBuffer buffer, ToolIngredient ingredient) {
            buffer.func_180714_a(ingredient.toolType.func_176610_l());
        }
    }
}

