/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.karma;

import net.minecraft.entity.IAngerable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.AnimalTameEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.NetworkDirection;
import net.threetag.threecore.ThreeCore;
import net.threetag.threecore.capability.CapabilityKarma;
import net.threetag.threecore.karma.KarmaClass;
import net.threetag.threecore.network.SyncKarmaMessage;

@Mod.EventBusSubscriber(modid="threecore")
public class KarmaEventHandler {
    @SubscribeEvent
    public static void onPlayerCloned(PlayerEvent.Clone e) {
        if (e.isWasDeath()) {
            e.getOriginal().getCapability(CapabilityKarma.KARMA).ifPresent(oldCap -> e.getPlayer().getCapability(CapabilityKarma.KARMA).ifPresent(newCap -> newCap.setKarma(oldCap.getKarma())));
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent e) {
        if (e.getEntity() instanceof ServerPlayerEntity) {
            e.getEntity().getCapability(CapabilityKarma.KARMA).ifPresent(k -> ThreeCore.NETWORK_CHANNEL.sendTo((Object)new SyncKarmaMessage(e.getEntity().func_145782_y(), k.getKarma()), ((ServerPlayerEntity)e.getEntity()).field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT));
        }
    }

    @SubscribeEvent
    public static void onDeath(LivingDeathEvent e) {
        if (e.getSource() != null && e.getSource().func_76346_g() != null && e.getSource().func_76346_g() instanceof PlayerEntity) {
            PlayerEntity attacker = (PlayerEntity)e.getSource().func_76346_g();
            LivingEntity killed = e.getEntityLiving();
            if (KarmaEventHandler.isMonster(killed)) {
                CapabilityKarma.addKarma(attacker, 2);
            } else if (killed.getCapability(CapabilityKarma.KARMA).isPresent()) {
                killed.getCapability(CapabilityKarma.KARMA).ifPresent(k -> {
                    if (KarmaClass.fromKarma(k.getKarma()).isGood()) {
                        CapabilityKarma.addKarma(attacker, -2);
                    } else {
                        CapabilityKarma.addKarma(attacker, 2);
                    }
                });
            } else if (killed instanceof VillagerEntity) {
                CapabilityKarma.addKarma(attacker, -2);
            } else if (killed instanceof TameableEntity && ((TameableEntity)killed).func_70909_n()) {
                CapabilityKarma.addKarma(attacker, -2);
            } else if (killed instanceof WitherEntity) {
                CapabilityKarma.addKarma(attacker, 15);
            } else if (killed instanceof EnderDragonEntity) {
                CapabilityKarma.addKarma(attacker, 30);
            }
        }
    }

    @SubscribeEvent
    public static void onDamage(LivingHurtEvent e) {
        if (e.getAmount() > 0.0f && e.getSource() != null && e.getSource().func_76346_g() != null && e.getSource().func_76346_g() instanceof PlayerEntity) {
            PlayerEntity attacker = (PlayerEntity)e.getSource().func_76346_g();
            LivingEntity attacked = e.getEntityLiving();
            if (attacked instanceof IAngerable && !((IAngerable)attacked).func_233678_J__()) {
                CapabilityKarma.addKarma(attacker, -1);
            } else if (attacked instanceof SpiderEntity && attacked.func_70013_c() >= 0.5f) {
                CapabilityKarma.addKarma(attacker, -1);
            }
        }
    }

    @SubscribeEvent
    public static void onAnimalTame(AnimalTameEvent e) {
        e.getTamer().getCapability(CapabilityKarma.KARMA).ifPresent(k -> CapabilityKarma.addKarma(e.getTamer(), 1));
    }

    @SubscribeEvent
    public static void onCropTrample(BlockEvent.FarmlandTrampleEvent e) {
        if (!(e.getEntity() instanceof PlayerEntity)) {
            return;
        }
        e.getEntity().getCapability(CapabilityKarma.KARMA).ifPresent(k -> CapabilityKarma.addKarma((PlayerEntity)e.getEntity(), -1));
    }

    public static boolean isMonster(LivingEntity entity) {
        return !entity.func_200600_R().func_220339_d().func_75599_d();
    }
}

