/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.threetag.threecore.ability.container.AbilityContainerTypes;
import net.threetag.threecore.ability.container.IAbilityContainer;
import net.threetag.threecore.capability.CapabilityAbilityContainer;
import net.threetag.threecore.client.gui.toast.SuperpowerTimerToast;

public class AddAbilityContainerMessage {
    private final int entityID;
    private final CompoundNBT nbt;

    public AddAbilityContainerMessage(int entityID, CompoundNBT nbt) {
        this.entityID = entityID;
        this.nbt = nbt;
    }

    public AddAbilityContainerMessage(PacketBuffer buffer) {
        this.entityID = buffer.readInt();
        this.nbt = buffer.func_150793_b();
    }

    public void toBytes(PacketBuffer buffer) {
        buffer.writeInt(this.entityID);
        buffer.func_150786_a(this.nbt);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            IAbilityContainer container;
            Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(this.entityID);
            if (entity instanceof LivingEntity && (container = AbilityContainerTypes.deserialize(this.nbt, false)) != null) {
                entity.getCapability(CapabilityAbilityContainer.MULTI_ABILITY_CONTAINER).ifPresent(multiContainer -> {
                    multiContainer.addContainer((LivingEntity)entity, container);
                    if (entity == Minecraft.func_71410_x().field_71439_g) {
                        SuperpowerTimerToast.add(container.getId());
                    }
                });
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

